/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.IdentityInfoEntity;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class DeleteUserPictureCmd
implements Command<Void> {
    protected String userId;

    public DeleteUserPictureCmd(String userId) {
        this.userId = userId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("UserId", (Object)this.userId);
        IdentityInfoEntity infoEntity = commandContext.getIdentityInfoManager().findUserInfoByUserIdAndKey(this.userId, "picture");
        if (infoEntity != null) {
            String byteArrayId = infoEntity.getValue();
            if (byteArrayId != null) {
                commandContext.getByteArrayManager().deleteByteArrayById(byteArrayId);
            }
            commandContext.getIdentityInfoManager().delete(infoEntity);
        }
        return null;
    }
}

