/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.event.EventType;
import org.cibseven.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;
import org.cibseven.bpm.engine.impl.pvm.process.ScopeImpl;
import org.cibseven.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.cibseven.bpm.engine.impl.tree.FlowScopeWalker;
import org.cibseven.bpm.engine.impl.tree.ReferenceWalker;
import org.cibseven.bpm.engine.impl.tree.TreeVisitor;
import org.cibseven.bpm.engine.variable.impl.VariableMapImpl;

public class CompensationUtil {
    public static final String SIGNAL_COMPENSATION_DONE = "compensationDone";

    public static void throwCompensationEvent(List<EventSubscriptionEntity> eventSubscriptions, ActivityExecution execution, boolean async) {
        for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
            ExecutionEntity compensatingExecution = CompensationUtil.getCompensatingExecution(eventSubscription);
            if (compensatingExecution != null) {
                if (compensatingExecution.getParent() != execution) {
                    compensatingExecution.setParent((PvmExecutionImpl)execution);
                }
                compensatingExecution.setEventScope(false);
            } else {
                compensatingExecution = (ExecutionEntity)execution.createExecution();
                eventSubscription.setConfiguration(compensatingExecution.getId());
            }
            compensatingExecution.setConcurrent(true);
        }
        Collections.sort(eventSubscriptions, new Comparator<EventSubscriptionEntity>(){

            @Override
            public int compare(EventSubscriptionEntity o1, EventSubscriptionEntity o2) {
                return o2.getCreated().compareTo(o1.getCreated());
            }
        });
        for (EventSubscriptionEntity compensateEventSubscriptionEntity : eventSubscriptions) {
            compensateEventSubscriptionEntity.eventReceived(null, async);
        }
    }

    public static void createEventScopeExecution(ExecutionEntity execution) {
        ActivityImpl activity = execution.getActivity();
        ExecutionEntity scopeExecution = (ExecutionEntity)execution.findExecutionForFlowScope(activity.getFlowScope());
        List<EventSubscriptionEntity> eventSubscriptions = execution.getCompensateEventSubscriptions();
        if (eventSubscriptions.size() > 0 || CompensationUtil.hasCompensationEventSubprocess(activity)) {
            ExecutionEntity eventScopeExecution = scopeExecution.createExecution();
            eventScopeExecution.setActivity(execution.getActivity());
            eventScopeExecution.activityInstanceStarting();
            eventScopeExecution.enterActivityInstance();
            eventScopeExecution.setActive(false);
            eventScopeExecution.setConcurrent(false);
            eventScopeExecution.setEventScope(true);
            VariableMapImpl variables = execution.getVariablesLocal();
            for (Map.Entry entry : variables.entrySet()) {
                eventScopeExecution.setVariableLocal((String)entry.getKey(), entry.getValue());
            }
            for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
                EventSubscriptionEntity newSubscription = EventSubscriptionEntity.createAndInsert(eventScopeExecution, EventType.COMPENSATE, eventSubscriptionEntity.getActivity());
                newSubscription.setConfiguration(eventSubscriptionEntity.getConfiguration());
                newSubscription.setCreated(eventSubscriptionEntity.getCreated());
            }
            for (PvmExecutionImpl pvmExecutionImpl : execution.getEventScopeExecutions()) {
                pvmExecutionImpl.setParent(eventScopeExecution);
            }
            ActivityImpl compensationHandler = CompensationUtil.getEventScopeCompensationHandler(execution);
            EventSubscriptionEntity eventSubscriptionEntity = EventSubscriptionEntity.createAndInsert(scopeExecution, EventType.COMPENSATE, compensationHandler);
            eventSubscriptionEntity.setConfiguration(eventScopeExecution.getId());
        }
    }

    protected static boolean hasCompensationEventSubprocess(ActivityImpl activity) {
        ActivityImpl compensationHandler = activity.findCompensationHandler();
        return compensationHandler != null && compensationHandler.isSubProcessScope() && compensationHandler.isTriggeredByEvent();
    }

    protected static ActivityImpl getEventScopeCompensationHandler(ExecutionEntity execution) {
        ActivityImpl activity = execution.getActivity();
        ActivityImpl compensationHandler = activity.findCompensationHandler();
        if (compensationHandler != null && compensationHandler.isSubProcessScope()) {
            return compensationHandler;
        }
        return activity;
    }

    public static List<EventSubscriptionEntity> collectCompensateEventSubscriptionsForScope(ActivityExecution execution) {
        final Map<ScopeImpl, PvmExecutionImpl> scopeExecutionMapping = execution.createActivityExecutionMapping();
        ScopeImpl activity = (ScopeImpl)((Object)execution.getActivity());
        final HashSet subscriptions = new HashSet();
        TreeVisitor<ScopeImpl> eventSubscriptionCollector = new TreeVisitor<ScopeImpl>(){

            @Override
            public void visit(ScopeImpl obj) {
                PvmExecutionImpl execution = (PvmExecutionImpl)scopeExecutionMapping.get(obj);
                subscriptions.addAll(((ExecutionEntity)execution).getCompensateEventSubscriptions());
            }
        };
        new FlowScopeWalker(activity).addPostVisitor(eventSubscriptionCollector).walkUntil(new ReferenceWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl element) {
                Boolean consumesCompensationProperty = (Boolean)element.getProperty("consumesCompensation");
                return consumesCompensationProperty == null || consumesCompensationProperty == Boolean.TRUE;
            }
        });
        return new ArrayList<EventSubscriptionEntity>(subscriptions);
    }

    public static List<EventSubscriptionEntity> collectCompensateEventSubscriptionsForActivity(ActivityExecution execution, String activityRef) {
        List<EventSubscriptionEntity> eventSubscriptions = CompensationUtil.collectCompensateEventSubscriptionsForScope(execution);
        String subscriptionActivityId = CompensationUtil.getSubscriptionActivityId(execution, activityRef);
        ArrayList<EventSubscriptionEntity> eventSubscriptionsForActivity = new ArrayList<EventSubscriptionEntity>();
        for (EventSubscriptionEntity subscription : eventSubscriptions) {
            if (!subscriptionActivityId.equals(subscription.getActivityId())) continue;
            eventSubscriptionsForActivity.add(subscription);
        }
        return eventSubscriptionsForActivity;
    }

    public static ExecutionEntity getCompensatingExecution(EventSubscriptionEntity eventSubscription) {
        String configuration = eventSubscription.getConfiguration();
        if (configuration != null) {
            return Context.getCommandContext().getExecutionManager().findExecutionById(configuration);
        }
        return null;
    }

    private static String getSubscriptionActivityId(ActivityExecution execution, String activityRef) {
        ActivityImpl activityToCompensate = ((ExecutionEntity)execution).getProcessDefinition().findActivity(activityRef);
        if (activityToCompensate.isMultiInstance()) {
            ActivityImpl flowScope = (ActivityImpl)activityToCompensate.getFlowScope();
            return flowScope.getActivityId();
        }
        ActivityImpl compensationHandler = activityToCompensate.findCompensationHandler();
        if (compensationHandler != null) {
            return compensationHandler.getActivityId();
        }
        return activityRef;
    }
}

