/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl;

import org.cibseven.bpm.engine.BadUserRequestException;
import org.cibseven.bpm.engine.exception.NotValidException;
import org.cibseven.bpm.engine.history.UserOperationLogEntry;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class SetAnnotationForOperationLog
implements Command<Void> {
    protected String operationId;
    protected String annotation;

    public SetAnnotationForOperationLog(String operationId, String annotation) {
        this.operationId = operationId;
        this.annotation = annotation;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(NotValidException.class, "operation id", (Object)this.operationId);
        UserOperationLogEntry operationLogEntry = commandContext.getOperationLogManager().findOperationLogByOperationId(this.operationId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "operation", (Object)operationLogEntry);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateUserOperationLog(operationLogEntry);
        }
        commandContext.getOperationLogManager().updateOperationLogAnnotationByOperationId(this.operationId, this.annotation);
        if (this.annotation == null) {
            commandContext.getOperationLogManager().logClearAnnotationOperation(this.operationId, operationLogEntry.getTenantId());
        } else {
            commandContext.getOperationLogManager().logSetAnnotationOperation(this.operationId, operationLogEntry.getTenantId());
        }
        return null;
    }
}

