/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl;

import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.PriorityProvider;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.cibseven.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;

public abstract class DefaultPriorityProvider<T>
implements PriorityProvider<T> {
    public static long DEFAULT_PRIORITY = 0L;
    public static long DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE = 0L;

    public long getDefaultPriority() {
        return DEFAULT_PRIORITY;
    }

    public long getDefaultPriorityOnResolutionFailure() {
        return DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE;
    }

    protected Long evaluateValueProvider(ParameterValueProvider valueProvider, ExecutionEntity execution, String errorMessageHeading) {
        Object value;
        try {
            value = valueProvider.getValue(execution);
        }
        catch (ProcessEngineException e) {
            if (Context.getProcessEngineConfiguration().isEnableGracefulDegradationOnContextSwitchFailure() && this.isSymptomOfContextSwitchFailure(e, execution)) {
                value = this.getDefaultPriorityOnResolutionFailure();
                this.logNotDeterminingPriority(execution, value, e);
            }
            throw e;
        }
        if (!(value instanceof Number)) {
            throw new ProcessEngineException(errorMessageHeading + ": Priority value is not an Integer");
        }
        Number numberValue = (Number)value;
        if (this.isValidLongValue(numberValue)) {
            return numberValue.longValue();
        }
        throw new ProcessEngineException(errorMessageHeading + ": Priority value must be either Short, Integer, or Long");
    }

    @Override
    public long determinePriority(ExecutionEntity execution, T param, String jobDefinitionId) {
        if (param != null || execution != null) {
            Long specificPriority = this.getSpecificPriority(execution, param, jobDefinitionId);
            if (specificPriority != null) {
                return specificPriority;
            }
            Long processDefinitionPriority = this.getProcessDefinitionPriority(execution, param);
            if (processDefinitionPriority != null) {
                return processDefinitionPriority;
            }
        }
        return this.getDefaultPriority();
    }

    protected abstract Long getSpecificPriority(ExecutionEntity var1, T var2, String var3);

    protected abstract Long getProcessDefinitionPriority(ExecutionEntity var1, T var2);

    protected Long getProcessDefinedPriority(ProcessDefinitionImpl processDefinition, String propertyKey, ExecutionEntity execution, String errorMsgHead) {
        ParameterValueProvider priorityProvider;
        if (processDefinition != null && (priorityProvider = (ParameterValueProvider)processDefinition.getProperty(propertyKey)) != null) {
            return this.evaluateValueProvider(priorityProvider, execution, errorMsgHead);
        }
        return null;
    }

    protected abstract void logNotDeterminingPriority(ExecutionEntity var1, Object var2, ProcessEngineException var3);

    protected boolean isSymptomOfContextSwitchFailure(Throwable t, ExecutionEntity contextExecution) {
        return ProcessApplicationContextUtil.getTargetProcessApplication(contextExecution) == null;
    }

    protected boolean isValidLongValue(Number value) {
        return value instanceof Short || value instanceof Integer || value instanceof Long;
    }
}

