/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.spring.components.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.cibseven.bpm.engine.ProcessEngine;
import org.cibseven.bpm.engine.impl.bpmn.behavior.ReceiveTaskActivityBehavior;
import org.cibseven.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.cibseven.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.cibseven.bpm.engine.spring.components.registry.ActivitiStateHandlerRegistration;
import org.cibseven.commons.utils.StringUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ActivitiStateHandlerRegistry
extends ReceiveTaskActivityBehavior
implements BeanFactoryAware,
BeanNameAware,
ActivityBehavior,
InitializingBean {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private String beanName;
    private BeanFactory beanFactory;
    private volatile ConcurrentHashMap<String, ActivitiStateHandlerRegistration> registrations = new ConcurrentHashMap();
    private ProcessEngine processEngine;

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public void execute(ActivityExecution execution) throws Exception {
    }

    public void signal(ActivityExecution execution, String signalName, Object data) throws Exception {
        this.leave(execution);
    }

    protected String registrationKey(String stateName, String processName) {
        return (StringUtil.defaultString((String)processName) + ":" + StringUtil.defaultString((String)stateName)).toLowerCase();
    }

    public void registerActivitiStateHandler(ActivitiStateHandlerRegistration registration) {
        String regKey = this.registrationKey(registration.getProcessName(), registration.getStateName());
        this.registrations.put(regKey, registration);
    }

    public Collection<ActivitiStateHandlerRegistration> findRegistrationsForProcessAndState(String processName, String stateName) {
        ArrayList<ActivitiStateHandlerRegistration> registrationCollection = new ArrayList<ActivitiStateHandlerRegistration>();
        String regKeyFull = this.registrationKey(processName, stateName);
        String regKeyWithJustState = this.registrationKey(null, stateName);
        for (String k : this.registrations.keySet()) {
            if (!k.contains(regKeyFull)) continue;
            registrationCollection.add(this.registrations.get(k));
        }
        if (registrationCollection.size() == 0) {
            for (String k : this.registrations.keySet()) {
                if (!k.contains(regKeyWithJustState)) continue;
                registrationCollection.add(this.registrations.get(k));
            }
        }
        return registrationCollection;
    }

    public ActivitiStateHandlerRegistration findRegistrationForProcessAndState(String processName, String stateName) {
        String kName;
        ActivitiStateHandlerRegistration r = null;
        String key = this.registrationKey(processName, stateName);
        Collection<ActivitiStateHandlerRegistration> rs = this.findRegistrationsForProcessAndState(processName, stateName);
        for (ActivitiStateHandlerRegistration sr : rs) {
            kName = this.registrationKey(sr.getProcessName(), sr.getStateName());
            if (!key.equalsIgnoreCase(kName)) continue;
            r = sr;
            break;
        }
        for (ActivitiStateHandlerRegistration sr : rs) {
            kName = this.registrationKey(null, sr.getStateName());
            if (!key.equalsIgnoreCase(kName)) continue;
            r = sr;
            break;
        }
        if (r == null && rs.size() > 0) {
            r = rs.iterator().next();
        }
        return r;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.processEngine, (String)"the 'processEngine' can't be null");
        this.logger.info("this bean contains a processEngine reference. " + this.processEngine);
        this.logger.info("starting " + ((Object)((Object)this)).getClass().getName());
    }
}

