/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.spring.components.scope;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.cibseven.bpm.engine.ProcessEngine;
import org.cibseven.bpm.engine.RuntimeService;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.runtime.ProcessInstance;
import org.cibseven.bpm.engine.spring.components.aop.util.Scopifier;
import org.cibseven.commons.utils.StringUtil;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.scope.ScopedObject;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ProcessScope
implements Scope,
InitializingBean,
BeanFactoryPostProcessor,
DisposableBean {
    public static final String PROCESS_SCOPE_PROCESS_VARIABLES_SINGLETON = "processVariables";
    public static final String PROCESS_SCOPE_NAME = "process";
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private boolean proxyTargetClass = true;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private ProcessEngine processEngine;
    private RuntimeService runtimeService;
    private final ConcurrentHashMap<String, Object> processVariablesMap = new ConcurrentHashMap<String, Object>(){

        @Override
        public Object get(Object o) {
            ExecutionEntity processInstance;
            Assert.isInstanceOf(String.class, (Object)o, (String)"the 'key' must be a String");
            String varName = (String)o;
            ExecutionEntity executionEntity = processInstance = Context.getExecutionContext().getProcessInstance();
            if (executionEntity.getVariableNames().contains(varName)) {
                return executionEntity.getVariable(varName);
            }
            throw new RuntimeException("no processVariable by the name of '" + varName + "' is available!");
        }
    };

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        ExecutionEntity executionEntity = null;
        try {
            ExecutionEntity processInstance;
            this.logger.fine("returning scoped object having beanName '" + name + "' for conversation ID '" + this.getConversationId() + "'. ");
            executionEntity = processInstance = Context.getExecutionContext().getProcessInstance();
            Object scopedObject = executionEntity.getVariable(name);
            if (scopedObject == null) {
                scopedObject = objectFactory.getObject();
                if (scopedObject instanceof ScopedObject) {
                    ScopedObject sc = (ScopedObject)scopedObject;
                    scopedObject = sc.getTargetObject();
                    this.logger.fine("de-referencing " + ScopedObject.class.getName() + "#targetObject before persisting variable");
                }
                this.persistVariable(name, scopedObject);
            }
            Object object = this.createDirtyCheckingProxy(name, scopedObject);
            return object;
        }
        catch (Throwable th) {
            this.logger.warning("couldn't return value from process scope! " + StringUtil.getStackTrace((Throwable)th));
        }
        finally {
            if (executionEntity != null) {
                this.logger.fine("set variable '" + name + "' on executionEntity# " + executionEntity.getId());
            }
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        this.logger.fine("no support for registering descruction callbacks implemented currently. registerDestructionCallback('" + name + "',callback) will do nothing.");
    }

    private String getExecutionId() {
        return ((ExecutionEntity)Context.getExecutionContext().getExecution()).getId();
    }

    public Object remove(String name) {
        this.logger.fine("remove '" + name + "'");
        return this.runtimeService.getVariable(this.getExecutionId(), name);
    }

    public Object resolveContextualObject(String key) {
        if ("executionId".equalsIgnoreCase(key)) {
            return ((ExecutionEntity)Context.getExecutionContext().getExecution()).getId();
        }
        if ("processInstance".equalsIgnoreCase(key)) {
            return Context.getExecutionContext().getProcessInstance();
        }
        if ("processInstanceId".equalsIgnoreCase(key)) {
            return Context.getExecutionContext().getProcessInstance().getId();
        }
        return null;
    }

    private Object createSharedProcessInstance() {
        ProxyFactory proxyFactoryBean = new ProxyFactory(ProcessInstance.class, (Interceptor)new MethodInterceptor(){

            public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                String methodName = methodInvocation.getMethod().getName();
                ProcessScope.this.logger.info("method invocation for " + methodName + ".");
                if (methodName.equals("toString")) {
                    return "SharedProcessInstance";
                }
                ExecutionEntity processInstance = Context.getExecutionContext().getProcessInstance();
                Method method = methodInvocation.getMethod();
                Object[] args = methodInvocation.getArguments();
                Object result = method.invoke((Object)processInstance, args);
                return result;
            }
        });
        return proxyFactoryBean.getProxy(this.classLoader);
    }

    public String getConversationId() {
        return this.getExecutionId();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerScope(PROCESS_SCOPE_NAME, (Scope)this);
        Assert.isInstanceOf(BeanDefinitionRegistry.class, (Object)beanFactory, (String)"BeanFactory was not a BeanDefinitionRegistry, so ProcessScope cannot be used.");
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            boolean scoped = PROCESS_SCOPE_NAME.equals(definition.getScope());
            Scopifier scopifier = new Scopifier(registry, PROCESS_SCOPE_NAME, this.proxyTargetClass, scoped);
            scopifier.visitBeanDefinition(definition);
            if (!scoped) continue;
            Scopifier.createScopedProxy(beanName, definition, registry, this.proxyTargetClass);
        }
        beanFactory.registerSingleton(PROCESS_SCOPE_PROCESS_VARIABLES_SINGLETON, this.processVariablesMap);
        beanFactory.registerResolvableDependency(ProcessInstance.class, this.createSharedProcessInstance());
    }

    public void destroy() throws Exception {
        this.logger.info(ProcessScope.class.getName() + "#destroy() called ...");
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.processEngine, (String)"the 'processEngine' must not be null!");
        this.runtimeService = this.processEngine.getRuntimeService();
    }

    private Object createDirtyCheckingProxy(final String name, final Object scopedObject) throws Throwable {
        ProxyFactory proxyFactoryBean = new ProxyFactory(scopedObject);
        proxyFactoryBean.setProxyTargetClass(this.proxyTargetClass);
        proxyFactoryBean.addAdvice((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation methodInvocation) throws Throwable {
                Object result = methodInvocation.proceed();
                ProcessScope.this.persistVariable(name, scopedObject);
                return result;
            }
        });
        return proxyFactoryBean.getProxy(this.classLoader);
    }

    private void persistVariable(String variableName, Object scopedObject) {
        ExecutionEntity processInstance;
        ExecutionEntity executionEntity = processInstance = Context.getExecutionContext().getProcessInstance();
        Assert.isTrue((boolean)(scopedObject instanceof Serializable), (String)("the scopedObject is not " + Serializable.class.getName() + "!"));
        executionEntity.setVariable(variableName, scopedObject);
    }
}

