/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.spring;

import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandInterceptor;
import org.cibseven.bpm.engine.impl.util.ExceptionUtil;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionInterceptor
extends CommandInterceptor {
    protected PlatformTransactionManager transactionManager;
    protected int transactionPropagation;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Deprecated
    public SpringTransactionInterceptor(PlatformTransactionManager transactionManager, int transactionPropagation) {
        this(transactionManager, transactionPropagation, null);
    }

    public SpringTransactionInterceptor(PlatformTransactionManager transactionManager, int transactionPropagation, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.transactionManager = transactionManager;
        this.transactionPropagation = transactionPropagation;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public <T> T execute(Command<T> command) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(this.transactionPropagation);
        try {
            return (T)transactionTemplate.execute(status -> this.next.execute(command));
        }
        catch (TransactionSystemException ex) {
            throw ExceptionUtil.wrapPersistenceException((Exception)((Object)ex));
        }
    }
}

