/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.spring.application;

import jakarta.servlet.ServletContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cibseven.bpm.application.AbstractProcessApplication;
import org.cibseven.bpm.application.ProcessApplicationElResolver;
import org.cibseven.bpm.application.impl.JakartaServletProcessApplication;
import org.cibseven.bpm.engine.spring.ApplicationContextElResolver;
import org.cibseven.bpm.engine.spring.application.SpringProcessApplication;
import org.cibseven.bpm.impl.juel.jakarta.el.ELResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringProcessApplicationElResolver
implements ProcessApplicationElResolver {
    private static final Logger LOGGER = Logger.getLogger(SpringProcessApplicationElResolver.class.getName());

    public Integer getPrecedence() {
        return 100;
    }

    public ELResolver getElResolver(AbstractProcessApplication processApplication) {
        if (processApplication instanceof SpringProcessApplication) {
            SpringProcessApplication springProcessApplication = (SpringProcessApplication)processApplication;
            return new ApplicationContextElResolver(springProcessApplication.getApplicationContext());
        }
        if (processApplication instanceof JakartaServletProcessApplication) {
            JakartaServletProcessApplication servletProcessApplication = (JakartaServletProcessApplication)processApplication;
            if (!ClassUtils.isPresent((String)"org.springframework.web.context.support.WebApplicationContextUtils", (ClassLoader)processApplication.getProcessApplicationClassloader())) {
                LOGGER.log(Level.FINE, "WebApplicationContextUtils must be present for SpringProcessApplicationElResolver to work");
                return null;
            }
            ServletContext servletContext = servletProcessApplication.getServletContext();
            WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            if (applicationContext != null) {
                return new ApplicationContextElResolver((ApplicationContext)applicationContext);
            }
        }
        LOGGER.log(Level.FINE, "Process application class {0} unsupported by SpringProcessApplicationElResolver", processApplication);
        return null;
    }
}

