/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.cutoffseq;

import org.chocosolver.cutoffseq.AbstractCutoffStrategy;

public final class GeometricalCutoffStrategy
extends AbstractCutoffStrategy {
    public final double geometricalFactor;
    public double geometricalFactorPower;

    public GeometricalCutoffStrategy(long s, double g) {
        super(s);
        if (g <= 1.0) {
            throw new IllegalArgumentException("The geometrical factor of the restart strategy must be strictly greater than 1.");
        }
        this.geometricalFactor = g;
        this.geometricalFactorPower = 1.0;
    }

    @Override
    public long getNextCutoff() {
        long cutoff = (int)Math.ceil((double)this.scaleFactor * this.geometricalFactorPower);
        this.geometricalFactorPower *= this.geometricalFactor;
        return cutoff;
    }

    public String toString() {
        return "GEOMETRICAL(s=" + this.scaleFactor + ", g=" + this.geometricalFactor + ')';
    }
}

