/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test.diagnostics;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.framework.test.diagnostics.TestDiagnostic;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticLine;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticUtils;

public class JavaDiagnosticReader
implements Iterator<TestDiagnosticLine> {
    private final StringToTestDiagnosticLine codec;
    private final String filename;
    private LineNumberReader reader;
    private @Nullable String nextLine = null;
    private @GTENegativeOne int nextLineNumber = -1;

    public static List<TestDiagnostic> readJavaSourceFiles(Iterable<? extends Object> files) {
        ArrayList<JavaDiagnosticReader> readers = new ArrayList<JavaDiagnosticReader>();
        for (Object object : files) {
            if (object instanceof JavaFileObject) {
                readers.add(new JavaDiagnosticReader((JavaFileObject)object, TestDiagnosticUtils::fromJavaSourceLine));
                continue;
            }
            if (object instanceof File) {
                readers.add(new JavaDiagnosticReader((File)object, TestDiagnosticUtils::fromJavaSourceLine));
                continue;
            }
            throw new IllegalArgumentException(String.format("Elements of argument should be File or JavaFileObject, not %s: %s", object.getClass(), object));
        }
        return JavaDiagnosticReader.readDiagnostics(readers);
    }

    public static List<TestDiagnostic> readDiagnosticFiles(Iterable<? extends File> files) {
        ArrayList<JavaDiagnosticReader> readers = new ArrayList<JavaDiagnosticReader>();
        for (File file : files) {
            readers.add(new JavaDiagnosticReader(file, (filename, line, lineNumber) -> TestDiagnosticUtils.fromDiagnosticFileLine(line)));
        }
        return JavaDiagnosticReader.readDiagnostics(readers);
    }

    private static List<TestDiagnostic> readDiagnostics(Iterable<JavaDiagnosticReader> readers) {
        return JavaDiagnosticReader.diagnosticLinesToDiagnostics(JavaDiagnosticReader.readDiagnosticLines(readers));
    }

    private static List<TestDiagnosticLine> readDiagnosticLines(Iterable<JavaDiagnosticReader> readers) {
        ArrayList<TestDiagnosticLine> result = new ArrayList<TestDiagnosticLine>();
        for (JavaDiagnosticReader reader : readers) {
            result.addAll(JavaDiagnosticReader.readDiagnosticLines(reader));
        }
        return result;
    }

    private static List<TestDiagnosticLine> readDiagnosticLines(JavaDiagnosticReader reader) {
        ArrayList<TestDiagnosticLine> diagnosticLines = new ArrayList<TestDiagnosticLine>();
        while (reader.hasNext()) {
            TestDiagnosticLine line = reader.next();
            if (!line.hasDiagnostics()) continue;
            diagnosticLines.add(line);
        }
        return diagnosticLines;
    }

    private static List<TestDiagnostic> diagnosticLinesToDiagnostics(List<TestDiagnosticLine> lines) {
        ArrayList<TestDiagnostic> result = new ArrayList<TestDiagnostic>((int)((double)lines.size() * 1.1));
        for (TestDiagnosticLine line : lines) {
            result.addAll(line.getDiagnostics());
        }
        return result;
    }

    private JavaDiagnosticReader(File toRead, StringToTestDiagnosticLine codec) {
        this.codec = codec;
        this.filename = toRead.getName();
        try {
            this.reader = new LineNumberReader(new FileReader(toRead));
            this.advance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JavaDiagnosticReader(JavaFileObject toReadFileObject, StringToTestDiagnosticLine codec) {
        this.codec = codec;
        this.filename = new File(toReadFileObject.getName()).getName();
        try {
            this.reader = new LineNumberReader(toReadFileObject.openReader(true));
            this.advance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements using JavaDiagnosticFileReader.");
    }

    @Override
    public TestDiagnosticLine next() {
        if (this.nextLine == null) {
            throw new NoSuchElementException();
        }
        String currentLine = this.nextLine;
        int currentLineNumber = this.nextLineNumber;
        try {
            this.advance();
            currentLine = TestDiagnosticUtils.handleEndOfLineJavaDiagnostic(currentLine);
            if (TestDiagnosticUtils.isJavaDiagnosticLineStart(currentLine)) {
                while (TestDiagnosticUtils.isJavaDiagnosticLineContinuation(this.nextLine)) {
                    currentLine = currentLine.trim() + " " + TestDiagnosticUtils.continuationPart(this.nextLine);
                    currentLineNumber = this.nextLineNumber;
                    this.advance();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.codec.createTestDiagnosticLine(this.filename, currentLine, currentLineNumber);
    }

    @RequiresNonNull(value={"reader"})
    protected void advance(@UnknownInitialization JavaDiagnosticReader this) throws IOException {
        this.nextLine = this.reader.readLine();
        this.nextLineNumber = this.reader.getLineNumber();
        if (this.nextLine == null) {
            this.reader.close();
        }
    }

    private static interface StringToTestDiagnosticLine {
        public TestDiagnosticLine createTestDiagnosticLine(String var1, String var2, long var3);
    }
}

