/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test.diagnostics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum DiagnosticKind {
    Warning("warning"),
    Error("error"),
    Jspecify("jspecify"),
    Other("other");

    public final String parseString;
    private static final Map<String, DiagnosticKind> stringToCategory;

    private DiagnosticKind(String parseString) {
        this.parseString = parseString;
    }

    public static @Nullable DiagnosticKind fromParseString(String parseStr) {
        return stringToCategory.get(parseStr);
    }

    static {
        stringToCategory = new LinkedHashMap<String, DiagnosticKind>();
        for (DiagnosticKind cat : DiagnosticKind.values()) {
            stringToCategory.put(cat.parseString, cat);
        }
    }
}

