/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test.diagnostics;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.framework.test.diagnostics.TestDiagnostic;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticLine;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticUtils;

public class JavaDiagnosticReader
implements Iterator<TestDiagnosticLine> {
    private final @Nullable File toRead;
    private final @Nullable JavaFileObject toReadFileObject;
    private final DiagnosticCodec codec;
    private final String filename;
    private boolean initialized = false;
    private boolean closed = false;
    private @MonotonicNonNull LineNumberReader reader = null;
    private @Nullable String nextLine = null;
    private @GTENegativeOne int nextLineNumber = -1;

    public static List<TestDiagnostic> readJavaSourceFiles(Iterable<? extends Object> files) {
        ArrayList<JavaDiagnosticReader> readers = new ArrayList<JavaDiagnosticReader>();
        for (Object object : files) {
            if (object instanceof JavaFileObject) {
                readers.add(new JavaDiagnosticReader((JavaFileObject)object, TestDiagnosticUtils::fromJavaSourceLine));
                continue;
            }
            if (object instanceof File) {
                readers.add(new JavaDiagnosticReader((File)object, TestDiagnosticUtils::fromJavaSourceLine));
                continue;
            }
            throw new IllegalArgumentException(String.format("Elements of argument should be File or JavaFileObject, not %s: %s", object.getClass(), object));
        }
        return JavaDiagnosticReader.readDiagnostics(readers);
    }

    public static List<TestDiagnostic> readDiagnosticFiles(Iterable<? extends File> files) {
        ArrayList<JavaDiagnosticReader> readers = new ArrayList<JavaDiagnosticReader>();
        for (File file : files) {
            readers.add(new JavaDiagnosticReader(file, (filename, line, lineNumber) -> TestDiagnosticUtils.fromDiagnosticFileLine(line)));
        }
        return JavaDiagnosticReader.readDiagnostics(readers);
    }

    private static List<TestDiagnostic> readDiagnostics(Iterable<JavaDiagnosticReader> readers) {
        return JavaDiagnosticReader.getDiagnostics(JavaDiagnosticReader.readDiagnosticLines(readers));
    }

    private static List<TestDiagnosticLine> readDiagnosticLines(Iterable<JavaDiagnosticReader> readers) {
        ArrayList<TestDiagnosticLine> result = new ArrayList<TestDiagnosticLine>();
        for (JavaDiagnosticReader reader : readers) {
            result.addAll(JavaDiagnosticReader.readDiagnosticLines(reader));
        }
        return result;
    }

    private static List<TestDiagnosticLine> readDiagnosticLines(JavaDiagnosticReader reader) {
        ArrayList<TestDiagnosticLine> diagnosticLines = new ArrayList<TestDiagnosticLine>();
        while (reader.hasNext()) {
            TestDiagnosticLine line = reader.next();
            if (!line.hasDiagnostics()) continue;
            diagnosticLines.add(line);
        }
        reader.close();
        return diagnosticLines;
    }

    private static List<TestDiagnostic> getDiagnostics(List<TestDiagnosticLine> lines) {
        ArrayList<TestDiagnostic> result = new ArrayList<TestDiagnostic>((int)((double)lines.size() * 1.1));
        for (TestDiagnosticLine line : lines) {
            result.addAll(line.getDiagnostics());
        }
        return result;
    }

    private JavaDiagnosticReader(File toRead, DiagnosticCodec codec) {
        this.toRead = toRead;
        this.toReadFileObject = null;
        this.codec = codec;
        this.filename = JavaDiagnosticReader.shortFileName(toRead.getName());
    }

    private JavaDiagnosticReader(JavaFileObject toRead, DiagnosticCodec codec) {
        this.toRead = null;
        this.toReadFileObject = toRead;
        this.codec = codec;
        this.filename = JavaDiagnosticReader.shortFileName(this.toReadFileObject.getName());
    }

    private static String shortFileName(String name) {
        int index = name.lastIndexOf(File.separator);
        return name.substring(index + 1, name.length());
    }

    @EnsuresNonNull(value={"reader"})
    private void init() throws IOException {
        if (!this.initialized && !this.closed) {
            this.initialized = true;
            Reader fileReader = this.toRead != null ? new FileReader(this.toRead) : this.toReadFileObject.openReader(true);
            this.reader = new LineNumberReader(fileReader);
            this.advance();
        }
    }

    @Override
    @EnsuresNonNull(value={"reader"})
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        try {
            this.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.nextLine != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements using JavaDiagnosticFileReader.");
    }

    @Override
    public TestDiagnosticLine next() {
        try {
            this.init();
            if (this.nextLine == null) {
                throw new NoSuchElementException();
            }
            if (this.closed) {
                throw new RuntimeException("Reader has been closed: " + (this.toRead != null ? this.toRead.getAbsolutePath() : this.toReadFileObject));
            }
            String current = this.nextLine;
            int currentLineNumber = this.nextLineNumber;
            this.advance();
            current = TestDiagnosticUtils.handleEndOfLineJavaDiagnostic(current);
            if (TestDiagnosticUtils.isJavaDiagnosticLineStart(current)) {
                while (TestDiagnosticUtils.isJavaDiagnosticLineContinuation(this.nextLine)) {
                    current = current.trim() + " " + TestDiagnosticUtils.continuationPart(this.nextLine);
                    currentLineNumber = this.nextLineNumber;
                    this.advance();
                }
            }
            if (this.nextLine == null) {
                this.close();
            }
            return this.codec.convertLine(this.filename, current, currentLineNumber);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequiresNonNull(value={"reader"})
    protected void advance() throws IOException {
        this.nextLine = this.reader.readLine();
        this.nextLineNumber = this.reader.getLineNumber();
    }

    @RequiresNonNull(value={"reader"})
    public void close() {
        try {
            if (this.initialized) {
                this.reader.close();
            }
            this.closed = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface DiagnosticCodec {
        public TestDiagnosticLine convertLine(String var1, String var2, long var3);
    }
}

