/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.framework.test.TestUtilities;
import org.checkerframework.javacutil.BugInCF;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class PerFileSuite
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();
    private static final String requiredFormsMessage = "Parameter method must have one of the following two forms:%n@Parameters String [] getTestDirs()%n@Parameters List<File> getTestFiles()%ntestClass=%s%nparameterMethods=%s";

    protected List<Runner> getChildren() {
        return this.runners;
    }

    public PerFileSuite(Class<?> klass) throws Throwable {
        super(klass, Collections.emptyList());
        TestClass testClass = this.getTestClass();
        Class javaTestClass = testClass.getJavaClass();
        List<Object[]> parametersList = this.getParametersList(testClass);
        for (Object[] parameters : parametersList) {
            this.runners.add((Runner)new PerParameterSetTestRunner(javaTestClass, parameters));
        }
    }

    private List<Object[]> getParametersList(TestClass klass) throws Throwable {
        List<File> javaFiles;
        FrameworkMethod method = this.getParametersMethod(klass);
        if (method.getReturnType().isArray()) {
            String[] dirs = (String[])method.invokeExplosively(null, new Object[0]);
            javaFiles = TestUtilities.findNestedJavaTestFiles(dirs);
        } else {
            javaFiles = (List<File>)method.invokeExplosively(null, new Object[0]);
        }
        ArrayList<Object[]> argumentLists = new ArrayList<Object[]>();
        for (File javaFile : javaFiles) {
            argumentLists.add(new Object[]{javaFile});
        }
        return argumentLists;
    }

    private FrameworkMethod getParametersMethod(TestClass testClass) {
        int modifiers;
        String methodName;
        List parameterMethods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        if (parameterMethods.size() != 1) {
            StringBuilder methods = new StringBuilder();
            if (parameterMethods.isEmpty()) {
                methods.append("[No methods specified]");
            } else {
                boolean first = true;
                for (FrameworkMethod method : parameterMethods) {
                    if (!first) {
                        methods.append(", ");
                    } else {
                        first = false;
                    }
                    methods.append(method.getName());
                }
            }
            throw new BugInCF(requiredFormsMessage, new Object[]{testClass.getName(), methods});
        }
        FrameworkMethod method = (FrameworkMethod)parameterMethods.get(0);
        Class returnType = method.getReturnType();
        switch (methodName = method.getName()) {
            case "getTestDirs": {
                if (!returnType.isArray() || returnType.getComponentType() == String.class) break;
                throw new RuntimeException("Component type of getTestDirs must be java.lang.String, found " + returnType.getComponentType().getCanonicalName());
            }
            case "getTestFiles": {
                if (returnType.getCanonicalName().equals(List.class.getCanonicalName())) break;
                throw new RuntimeException("getTestFiles must return a List<File>, found " + returnType);
            }
            default: {
                throw new BugInCF(requiredFormsMessage, new Object[]{testClass.getName(), method});
            }
        }
        if (!Modifier.isStatic(modifiers = method.getMethod().getModifiers()) || !Modifier.isPublic(modifiers)) {
            throw new RuntimeException("Parameter method (" + method.getName() + ") must be public and static");
        }
        return method;
    }

    private static class PerParameterSetTestRunner
    extends BlockJUnit4ClassRunner {
        private final Object[] parameters;

        PerParameterSetTestRunner(Class<?> type, Object[] parameters) throws InitializationError {
            super(type);
            this.parameters = parameters;
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.parameters);
        }

        String testCaseName() {
            File file = (File)this.parameters[0];
            String name = file.getPath().replace(".java", "").replace("tests" + System.getProperty("file.separator"), "");
            return name;
        }

        protected String getName() {
            return String.format("[%s]", this.testCaseName());
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s[%s]", method.getName(), this.testCaseName());
        }

        protected void validateZeroArgConstructor(List<Throwable> errors) {
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Name {
    }
}

