/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test.diagnostics;

import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethods;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.mustcall.qual.Owning;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.framework.test.diagnostics.TestDiagnostic;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticLine;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticUtils;

public class JavaDiagnosticReader
implements Iterator<TestDiagnosticLine>,
Closeable {
    private final StringToTestDiagnosticLine codec;
    private final String filename;
    @Owning
    private final LineNumberReader reader;
    private @Nullable String nextLine = null;
    private @GTENegativeOne int nextLineNumber = -1;

    public static List<TestDiagnostic> readJavaSourceFiles(Iterable<? extends Object> files) {
        ArrayList<TestDiagnostic> result = new ArrayList<TestDiagnostic>();
        for (Object object : files) {
            Throwable throwable;
            JavaDiagnosticReader reader;
            if (object instanceof JavaFileObject) {
                reader = new JavaDiagnosticReader((JavaFileObject)object, TestDiagnosticUtils::fromJavaSourceLine);
                throwable = null;
                try {
                    JavaDiagnosticReader.readDiagnostics(result, reader);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    JavaDiagnosticReader.$closeResource(throwable, reader);
                    continue;
                }
            }
            if (object instanceof File) {
                reader = new JavaDiagnosticReader((File)object, TestDiagnosticUtils::fromJavaSourceLine);
                throwable = null;
                try {
                    JavaDiagnosticReader.readDiagnostics(result, reader);
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    JavaDiagnosticReader.$closeResource(throwable, reader);
                    continue;
                }
            }
            throw new IllegalArgumentException(String.format("Elements of argument should be File or JavaFileObject, not %s: %s", object.getClass(), object));
        }
        return result;
    }

    public static List<TestDiagnostic> readDiagnosticFiles(Iterable<? extends File> files) {
        ArrayList<TestDiagnostic> result = new ArrayList<TestDiagnostic>();
        for (File file : files) {
            try (JavaDiagnosticReader reader = new JavaDiagnosticReader(file, (filename, line, lineNumber) -> TestDiagnosticUtils.fromDiagnosticFileLine(line));){
                JavaDiagnosticReader.readDiagnostics(result, reader);
            }
        }
        return result;
    }

    private static void readDiagnostics(List<TestDiagnostic> list, JavaDiagnosticReader reader) {
        JavaDiagnosticReader.diagnosticLinesToDiagnostics(list, JavaDiagnosticReader.readDiagnosticLines(reader));
    }

    private static List<TestDiagnosticLine> readDiagnosticLines(JavaDiagnosticReader reader) {
        ArrayList<TestDiagnosticLine> diagnosticLines = new ArrayList<TestDiagnosticLine>();
        while (reader.hasNext()) {
            TestDiagnosticLine line = reader.next();
            if (!line.hasDiagnostics()) continue;
            diagnosticLines.add(line);
        }
        return diagnosticLines;
    }

    private static void diagnosticLinesToDiagnostics(List<TestDiagnostic> list, List<TestDiagnosticLine> lines) {
        for (TestDiagnosticLine line : lines) {
            list.addAll(line.getDiagnostics());
        }
    }

    private JavaDiagnosticReader(File toRead, StringToTestDiagnosticLine codec) {
        this.codec = codec;
        this.filename = toRead.getName();
        try {
            this.reader = new LineNumberReader(new FileReader(toRead));
            this.advance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JavaDiagnosticReader(JavaFileObject toReadFileObject, StringToTestDiagnosticLine codec) {
        this.codec = codec;
        this.filename = new File(toReadFileObject.getName()).getName();
        try {
            this.reader = new LineNumberReader(toReadFileObject.openReader(true));
            this.advance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements using JavaDiagnosticFileReader.");
    }

    @Override
    public TestDiagnosticLine next() {
        if (this.nextLine == null) {
            throw new NoSuchElementException();
        }
        String currentLine = this.nextLine;
        int currentLineNumber = this.nextLineNumber;
        try {
            this.advance();
            currentLine = TestDiagnosticUtils.handleEndOfLineJavaDiagnostic(currentLine);
            if (TestDiagnosticUtils.isJavaDiagnosticLineStart(currentLine)) {
                while (TestDiagnosticUtils.isJavaDiagnosticLineContinuation(this.nextLine)) {
                    currentLine = currentLine.trim() + " " + TestDiagnosticUtils.continuationPart(this.nextLine);
                    currentLineNumber = this.nextLineNumber;
                    this.advance();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.codec.createTestDiagnosticLine(this.filename, currentLine, currentLineNumber);
    }

    @RequiresNonNull(value={"reader"})
    protected void advance(@UnknownInitialization JavaDiagnosticReader this) throws IOException {
        this.nextLine = this.reader.readLine();
        this.nextLineNumber = this.reader.getLineNumber();
        if (this.nextLine == null) {
            this.reader.close();
        }
    }

    @Override
    @EnsuresCalledMethods(value={"reader"}, methods={"close"})
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static interface StringToTestDiagnosticLine {
        public TestDiagnosticLine createTestDiagnosticLine(String var1, String var2, long var3);
    }
}

