/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.framework.test.CompilationResult;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.test.TestUtilities;
import org.checkerframework.framework.test.diagnostics.TestDiagnostic;
import org.checkerframework.framework.test.diagnostics.TestDiagnosticUtils;
import org.plumelib.util.StringsPlume;

public class TypecheckResult {
    private final TestConfiguration configuration;
    private final CompilationResult compilationResult;
    private final List<TestDiagnostic> expectedDiagnostics;
    private final List<TestDiagnostic> missingDiagnostics;
    private final List<TestDiagnostic> unexpectedDiagnostics;

    protected TypecheckResult(TestConfiguration configuration, CompilationResult compilationResult, List<TestDiagnostic> expectedDiagnostics, List<TestDiagnostic> missingDiagnostics, List<TestDiagnostic> unexpectedDiagnostics) {
        this.configuration = configuration;
        this.compilationResult = compilationResult;
        this.expectedDiagnostics = expectedDiagnostics;
        this.missingDiagnostics = missingDiagnostics;
        this.unexpectedDiagnostics = unexpectedDiagnostics;
    }

    public TestConfiguration getConfiguration() {
        return this.configuration;
    }

    public CompilationResult getCompilationResult() {
        return this.compilationResult;
    }

    public List<Diagnostic<? extends JavaFileObject>> getActualDiagnostics() {
        return this.compilationResult.getDiagnostics();
    }

    public List<TestDiagnostic> getExpectedDiagnostics() {
        return this.expectedDiagnostics;
    }

    public boolean didTestFail() {
        return !this.unexpectedDiagnostics.isEmpty() || !this.missingDiagnostics.isEmpty();
    }

    public List<TestDiagnostic> getMissingDiagnostics() {
        return this.missingDiagnostics;
    }

    public List<TestDiagnostic> getUnexpectedDiagnostics() {
        return this.unexpectedDiagnostics;
    }

    public List<String> getErrorHeaders() {
        ArrayList<String> errorHeaders = new ArrayList<String>();
        if (this.didTestFail()) {
            if (this.compilationResult.compiledWithoutError() && !this.expectedDiagnostics.isEmpty()) {
                errorHeaders.add("The test run was expected to issue errors/warnings, but it did not.");
            } else if (!this.compilationResult.compiledWithoutError() && this.expectedDiagnostics.isEmpty()) {
                errorHeaders.add("The test run was not expected to issue errors/warnings, but it did.");
            }
            if (!this.unexpectedDiagnostics.isEmpty() || !this.missingDiagnostics.isEmpty()) {
                int numExpected = this.expectedDiagnostics.size();
                int numFound = numExpected - this.missingDiagnostics.size();
                errorHeaders.add(numFound + " out of " + StringsPlume.nplural((int)numExpected, (String)"expected diagnostic") + " " + (numFound == 1 ? "was" : "were") + " found.");
            }
        }
        return errorHeaders;
    }

    public String summarize() {
        if (!this.didTestFail()) {
            return "";
        }
        StringJoiner summaryBuilder = new StringJoiner(System.lineSeparator());
        summaryBuilder.add(StringsPlume.joinLines(this.getErrorHeaders()));
        if (!this.unexpectedDiagnostics.isEmpty()) {
            int numUnexpected = this.unexpectedDiagnostics.size();
            summaryBuilder.add(StringsPlume.nplural((int)numUnexpected, (String)"unexpected diagnostic") + " " + (numUnexpected == 1 ? "was" : "were") + " found:");
            for (TestDiagnostic unexpected : this.unexpectedDiagnostics) {
                summaryBuilder.add(unexpected.toString());
            }
        }
        if (!this.missingDiagnostics.isEmpty()) {
            int numMissing = this.missingDiagnostics.size();
            summaryBuilder.add(StringsPlume.nplural((int)numMissing, (String)"expected diagnostic") + " " + (numMissing == 1 ? "was" : "were") + " not found:");
            for (TestDiagnostic missing : this.missingDiagnostics) {
                summaryBuilder.add(missing.toString());
            }
        }
        summaryBuilder.add("While type-checking " + TestUtilities.summarizeSourceFiles(this.configuration.getTestSourceFiles()));
        return summaryBuilder.toString();
    }

    public static TypecheckResult fromCompilationResults(TestConfiguration configuration, CompilationResult result, List<TestDiagnostic> expectedDiagnostics) {
        boolean usingAnomsgtxt = configuration.getOptions().containsKey("-Anomsgtext");
        Set<TestDiagnostic> actualDiagnostics = TestDiagnosticUtils.fromJavaxDiagnosticList(result.getDiagnostics(), usingAnomsgtxt);
        LinkedHashSet<TestDiagnostic> unexpectedDiagnostics = new LinkedHashSet<TestDiagnostic>();
        unexpectedDiagnostics.addAll(actualDiagnostics);
        unexpectedDiagnostics.removeAll(expectedDiagnostics);
        ArrayList<TestDiagnostic> missingDiagnostics = new ArrayList<TestDiagnostic>(expectedDiagnostics);
        missingDiagnostics.removeAll(actualDiagnostics);
        return new TypecheckResult(configuration, result, expectedDiagnostics, missingDiagnostics, new ArrayList<TestDiagnostic>(unexpectedDiagnostics));
    }
}

