/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test.diagnostics;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.test.diagnostics.DiagnosticKind;

public class TestDiagnostic {
    private final String filename;
    private final long lineNumber;
    private final DiagnosticKind kind;
    private final String message;
    private final boolean isFixable;
    private final boolean omitParentheses;

    public TestDiagnostic(String filename, long lineNumber, DiagnosticKind kind, String message, boolean isFixable, boolean omitParentheses) {
        this.filename = filename;
        this.lineNumber = lineNumber;
        this.kind = kind;
        this.message = message;
        this.isFixable = isFixable;
        this.omitParentheses = omitParentheses;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public DiagnosticKind getKind() {
        return this.kind;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isFixable() {
        return this.isFixable;
    }

    public boolean shouldOmitParentheses() {
        return this.omitParentheses;
    }

    public boolean equals(@Nullable Object otherObj) {
        if (otherObj == null || otherObj.getClass() != TestDiagnostic.class) {
            return false;
        }
        TestDiagnostic other = (TestDiagnostic)otherObj;
        return other.filename.equals(this.filename) && other.lineNumber == this.lineNumber && other.kind == this.kind && other.message.equals(this.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filename, this.lineNumber, this.kind, this.message});
    }

    public String toString() {
        if (this.kind == DiagnosticKind.Jspecify) {
            return this.filename + ":" + this.lineNumber + ": " + this.message;
        }
        if (this.omitParentheses) {
            return this.filename + ":" + this.lineNumber + ": " + this.kind.parseString + ": " + this.message;
        }
        return this.filename + ":" + this.lineNumber + ": " + this.kind.parseString + ": (" + this.message + ")";
    }
}

