/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.javacutil;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.shaded.javacutil.AnnotationFormatter;
import org.checkerframework.shaded.javacutil.AnnotationUtils;
import org.checkerframework.shaded.javacutil.BugInCF;
import org.checkerframework.shaded.org.plumelib.util.ArrayMap;

public class DefaultAnnotationFormatter
implements AnnotationFormatter {
    public static boolean isInvisibleQualified(AnnotationMirror anno) {
        TypeElement annoElement = (TypeElement)anno.getAnnotationType().asElement();
        for (AnnotationMirror annotationMirror : annoElement.getAnnotationMirrors()) {
            if (!AnnotationUtils.areSameByName(annotationMirror, "org.checkerframework.shaded.framework.qual.InvisibleQualifier")) continue;
            return true;
        }
        return false;
    }

    @Override
    @SideEffectFree
    public String formatAnnotationString(Collection<? extends AnnotationMirror> annos, boolean printInvisible) {
        StringBuilder sb = new StringBuilder();
        for (AnnotationMirror annotationMirror : annos) {
            if (annotationMirror == null) {
                throw new BugInCF("AnnotatedTypeMirror.formatAnnotationString: found null AnnotationMirror");
            }
            if (DefaultAnnotationFormatter.isInvisibleQualified(annotationMirror) && !printInvisible) continue;
            this.formatAnnotationMirror(annotationMirror, sb);
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    @SideEffectFree
    public String formatAnnotationMirror(AnnotationMirror anno) {
        StringBuilder sb = new StringBuilder();
        this.formatAnnotationMirror(anno, sb);
        return sb.toString();
    }

    protected void formatAnnotationMirror(AnnotationMirror am, StringBuilder sb) {
        sb.append("@");
        sb.append(am.getAnnotationType().asElement().getSimpleName());
        Map<ExecutableElement, AnnotationValue> args = this.removeDefaultValues(am.getElementValues());
        if (!args.isEmpty()) {
            Map.Entry<ExecutableElement, AnnotationValue> first;
            sb.append("(");
            boolean oneValue = false;
            if (args.size() == 1 && (first = args.entrySet().iterator().next()).getKey().getSimpleName().contentEquals("value")) {
                this.formatAnnotationMirrorArg(first.getValue(), sb);
                oneValue = true;
            }
            if (!oneValue) {
                boolean notfirst = false;
                for (Map.Entry<ExecutableElement, AnnotationValue> arg : args.entrySet()) {
                    if ("{}".equals(arg.getValue().toString())) continue;
                    if (notfirst) {
                        sb.append(", ");
                    }
                    notfirst = true;
                    sb.append(arg.getKey().getSimpleName() + "=");
                    this.formatAnnotationMirrorArg(arg.getValue(), sb);
                }
            }
            sb.append(")");
        }
    }

    private Map<ExecutableElement, AnnotationValue> removeDefaultValues(Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues) {
        ArrayMap<ExecutableElement, AnnotationValue> nonDefaults = new ArrayMap<ExecutableElement, AnnotationValue>(0);
        elementValues.forEach((element, value) -> {
            if (element.getDefaultValue() == null || !Objects.equals(value.getValue(), element.getDefaultValue().getValue())) {
                nonDefaults.put((ExecutableElement)element, (AnnotationValue)value);
            }
        });
        return nonDefaults;
    }

    protected void formatAnnotationMirrorArg(AnnotationValue av, StringBuilder sb) {
        Object val = av.getValue();
        if (List.class.isAssignableFrom(val.getClass())) {
            List vallist = (List)val;
            if (vallist.size() == 1) {
                this.formatAnnotationMirrorArg((AnnotationValue)vallist.get(0), sb);
            } else {
                sb.append('{');
                boolean notfirst = false;
                for (AnnotationValue nav : vallist) {
                    if (notfirst) {
                        sb.append(", ");
                    }
                    notfirst = true;
                    this.formatAnnotationMirrorArg(nav, sb);
                }
                sb.append('}');
            }
        } else if (VariableElement.class.isAssignableFrom(val.getClass())) {
            VariableElement ve = (VariableElement)val;
            sb.append(ve.getEnclosingElement().getSimpleName() + "." + ve.getSimpleName());
        } else {
            sb.append(av.toString());
        }
    }
}

