/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import com.sun.tools.javac.code.Symbol;
import java.util.Objects;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.shaded.dataflow.expression.ClassName;
import org.checkerframework.shaded.dataflow.expression.JavaExpression;
import org.checkerframework.shaded.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.shaded.dataflow.expression.SuperReference;
import org.checkerframework.shaded.dataflow.expression.ThisReference;
import org.checkerframework.shaded.javacutil.AnnotationProvider;
import org.checkerframework.shaded.javacutil.BugInCF;
import org.checkerframework.shaded.javacutil.ElementUtils;
import org.checkerframework.shaded.javacutil.TypesUtils;

public class FieldAccess
extends JavaExpression {
    protected final JavaExpression receiver;
    protected final VariableElement field;

    public JavaExpression getReceiver() {
        return this.receiver;
    }

    public VariableElement getField() {
        return this.field;
    }

    public FieldAccess(JavaExpression receiver, FieldAccessNode node) {
        this(receiver, node.getType(), node.getElement());
    }

    public FieldAccess(JavaExpression receiver, VariableElement fieldElement) {
        this(receiver, fieldElement.asType(), fieldElement);
    }

    public FieldAccess(JavaExpression receiver, TypeMirror type, VariableElement fieldElement) {
        super(type);
        this.receiver = receiver;
        this.field = fieldElement;
        String fieldName = fieldElement.toString();
        if (fieldName.equals("class") || fieldName.equals("this")) {
            BugInCF e = new BugInCF(String.format("bad field name \"%s\" in new FieldAccess(%s, %s, %s)%n", fieldName, receiver, type, fieldElement));
            e.printStackTrace(System.out);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public boolean isFinal() {
        return ElementUtils.isFinal(this.field);
    }

    public boolean isStatic() {
        return ElementUtils.isStatic(this.field);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof FieldAccess)) {
            return false;
        }
        FieldAccess fa = (FieldAccess)obj;
        if (!fa.getField().equals(this.getField())) {
            return false;
        }
        if (fa.getReceiver().equals(this.getReceiver())) {
            return true;
        }
        return !(!(fa.getReceiver() instanceof SuperReference) && !(fa.getReceiver() instanceof ThisReference) || !(this.getReceiver() instanceof SuperReference) && !(this.getReceiver() instanceof ThisReference));
    }

    public int hashCode() {
        return Objects.hash(this.getField(), this.getReceiver());
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof FieldAccess)) {
            return false;
        }
        FieldAccess other = (FieldAccess)je;
        return this.receiver.syntacticEquals(other.receiver) && this.field.equals(other.field);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other) || this.receiver.containsSyntacticEqualJavaExpression(other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        return super.containsModifiableAliasOf(store, other) || this.receiver.containsModifiableAliasOf(store, other);
    }

    public String toString() {
        String receiverString = this.receiver instanceof ClassName ? this.receiver.getType().toString() : this.receiver.toString();
        return this.receiver + "." + this.field;
    }

    @Override
    public String toStringDebug() {
        return String.format("FieldAccess(type=%s, receiver=%s, field=%s [%s] [%s] owner=%s)", this.type, this.receiver.toStringDebug(), this.field, this.field.getClass().getSimpleName(), System.identityHashCode(this.field), ((Symbol)((Object)this.field)).owner);
    }

    @Override
    public <T extends JavaExpression> @Nullable T containedOfClass(Class<T> clazz) {
        if (this.getClass() == clazz) {
            return (T)this;
        }
        return this.receiver.containedOfClass(clazz);
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return this.receiver.isDeterministic(provider);
    }

    @Override
    public boolean isAssignableByOtherCode() {
        return !this.isFinal() || this.getReceiver().isAssignableByOtherCode();
    }

    @Override
    public boolean isModifiableByOtherCode() {
        return this.isAssignableByOtherCode() || !TypesUtils.isImmutableTypeInJdk(this.getReceiver().type);
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitFieldAccess(this, p);
    }
}

