/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.builder;

import java.util.ArrayDeque;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.shaded.dataflow.cfg.builder.Label;
import org.checkerframework.shaded.dataflow.cfg.builder.TryFrame;
import org.checkerframework.shaded.org.plumelib.util.ArraySet;

class TryStack {
    protected final Label exitLabel;
    protected final ArrayDeque<TryFrame> frames;

    public TryStack(Label exitLabel) {
        this.exitLabel = exitLabel;
        this.frames = new ArrayDeque();
    }

    public void pushFrame(TryFrame frame) {
        this.frames.addFirst(frame);
    }

    public void popFrame() {
        this.frames.removeFirst();
    }

    public Set<Label> possibleLabels(TypeMirror thrown) {
        ArraySet<Label> labels = new ArraySet<Label>(1);
        for (TryFrame frame : this.frames) {
            if (!frame.possibleLabels(thrown, labels)) continue;
            return labels;
        }
        labels.add(this.exitLabel);
        return labels;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(System.lineSeparator());
        sj.add("TryStack: exitLabel: " + this.exitLabel);
        if (this.frames.isEmpty()) {
            sj.add("No TryFrames.");
        }
        for (TryFrame tf : this.frames) {
            sj.add(tf.toString());
        }
        return sj.toString();
    }
}

