/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.shaded.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.org.plumelib.util.StringsPlume;
import org.checkerframework.shaded.org.plumelib.util.UniqueId;

public abstract class UnderlyingAST
implements UniqueId {
    protected final Kind kind;
    private static final AtomicLong nextUid = new AtomicLong(0L);
    private final transient long uid = nextUid.getAndIncrement();

    @Override
    public long getUid(@UnknownInitialization UnderlyingAST this) {
        return this.uid;
    }

    protected UnderlyingAST(Kind kind) {
        this.kind = kind;
    }

    public abstract Tree getCode();

    public Kind getKind() {
        return this.kind;
    }

    public static enum Kind {
        METHOD,
        LAMBDA,
        ARBITRARY_CODE;

    }

    public static class CFGStatement
    extends UnderlyingAST {
        protected final Tree code;
        protected final ClassTree classTree;

        public CFGStatement(Tree code, ClassTree classTree) {
            super(Kind.ARBITRARY_CODE);
            this.code = code;
            this.classTree = classTree;
        }

        @Override
        public Tree getCode() {
            return this.code;
        }

        public ClassTree getClassTree() {
            return this.classTree;
        }

        public String getSimpleClassName() {
            return this.classTree.getSimpleName().toString();
        }

        public String toString() {
            return StringsPlume.joinLines("CFGStatement(", this.code, ")");
        }
    }

    public static class CFGLambda
    extends UnderlyingAST {
        private final LambdaExpressionTree lambda;
        private final ClassTree classTree;
        private final @Nullable MethodTree enclosingMethod;

        public CFGLambda(LambdaExpressionTree lambda, ClassTree classTree, @Nullable MethodTree enclosingMethod) {
            super(Kind.LAMBDA);
            this.lambda = lambda;
            this.enclosingMethod = enclosingMethod;
            this.classTree = classTree;
        }

        @Override
        public Tree getCode() {
            return this.lambda.getBody();
        }

        public LambdaExpressionTree getLambdaTree() {
            return this.lambda;
        }

        public ClassTree getClassTree() {
            return this.classTree;
        }

        public String getSimpleClassName() {
            return this.classTree.getSimpleName().toString();
        }

        @Deprecated
        public @Nullable MethodTree getMethod() {
            return this.enclosingMethod;
        }

        public @Nullable MethodTree getEnclosingMethod() {
            return this.enclosingMethod;
        }

        @Deprecated
        public @Nullable String getMethodName() {
            return this.enclosingMethod == null ? null : this.enclosingMethod.getName().toString();
        }

        public @Nullable String getEnclosingMethodName() {
            return this.enclosingMethod == null ? null : this.enclosingMethod.getName().toString();
        }

        public String toString() {
            return StringsPlume.joinLines("CFGLambda(", this.lambda, ")");
        }
    }

    public static class CFGMethod
    extends UnderlyingAST {
        protected final MethodTree method;
        protected final ClassTree classTree;

        public CFGMethod(MethodTree method, ClassTree classTree) {
            super(Kind.METHOD);
            this.method = method;
            this.classTree = classTree;
        }

        @Override
        public Tree getCode() {
            return this.method.getBody();
        }

        public MethodTree getMethod() {
            return this.method;
        }

        public String getMethodName() {
            return this.method.getName().toString();
        }

        public ClassTree getClassTree() {
            return this.classTree;
        }

        public String getSimpleClassName() {
            return this.classTree.getSimpleName().toString();
        }

        public String toString() {
            return StringsPlume.joinLines("CFGMethod(", this.method, ")");
        }
    }
}

