/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.com.google.common.hash;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.checkerframework.shaded.checker.index.qual.LTLengthOf;
import org.checkerframework.shaded.checker.index.qual.LessThanUnknown;
import org.checkerframework.shaded.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.shaded.checker.index.qual.NonNegative;
import org.checkerframework.shaded.checker.index.qual.SameLenUnknown;
import org.checkerframework.shaded.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.shaded.checker.initialization.qual.Initialized;
import org.checkerframework.shaded.checker.nullness.qual.NonNull;
import org.checkerframework.shaded.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.shaded.checker.signedness.qual.Signed;
import org.checkerframework.shaded.checker.signedness.qual.Unsigned;
import org.checkerframework.shaded.com.google.common.base.Preconditions;
import org.checkerframework.shaded.com.google.common.hash.AbstractHasher;
import org.checkerframework.shaded.com.google.common.hash.ElementTypesAreNonnullByDefault;
import org.checkerframework.shaded.com.google.common.hash.Hasher;
import org.checkerframework.shaded.com.google.common.hash.Java8Compatibility;
import org.checkerframework.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.shaded.common.value.qual.IntRange;
import org.checkerframework.shaded.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
abstract class AbstractByteHasher
extends AbstractHasher {
    private final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ByteBuffer scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    AbstractByteHasher() {
    }

    protected abstract void update(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte var1);

    protected void update(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] b) {
        this.update(b, 0, b.length);
    }

    protected void update(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] b, @NonNegative @LTLengthOf(value={"#1"}, offset={"#3 - 1"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UnknownKeyFor @NonNull @Initialized @Signed int off, @NonNegative @LTLengthOf(value={"#1"}, offset={"#2 - 1"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UnknownKeyFor @NonNull @Initialized @Signed int len) {
        for (int i = off; i < off + len; ++i) {
            this.update(b[i]);
        }
    }

    protected void update(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ByteBuffer b) {
        if (b.hasArray()) {
            this.update(b.array(), b.arrayOffset() + b.position(), b.remaining());
            Java8Compatibility.position(b, b.limit());
        } else {
            for (int remaining = b.remaining(); remaining > 0; --remaining) {
                this.update(b.get());
            }
        }
    }

    @CanIgnoreReturnValue
    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Hasher update(@IntRange(from=0L, to=8L) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int bytes) {
        try {
            this.update(this.scratch.array(), 0, bytes);
        }
        finally {
            Java8Compatibility.clear(this.scratch);
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Hasher putByte(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte b) {
        this.update(b);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Hasher putBytes(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] bytes) {
        Preconditions.checkNotNull(bytes);
        this.update(bytes);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Hasher putBytes(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] bytes, @NonNegative @LTLengthOf(value={"#1"}, offset={"#3 - 1"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UnknownKeyFor @NonNull @Initialized @Signed int off, @NonNegative @LTLengthOf(value={"#1"}, offset={"#2 - 1"}) @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UnknownKeyFor @NonNull @Initialized @Signed int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        this.update(bytes, off, len);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Hasher putBytes(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ByteBuffer bytes) {
        this.update(bytes);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Hasher putShort(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed short s) {
        this.scratch.putShort(s);
        return this.update(2);
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Hasher putInt(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int i) {
        this.scratch.putInt(i);
        return this.update(4);
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Hasher putLong(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long l) {
        this.scratch.putLong(l);
        return this.update(8);
    }

    @Override
    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Hasher putChar(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Unsigned char c) {
        this.scratch.putChar(c);
        return this.update(2);
    }
}

