/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.visualize;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.analysis.AbstractValue;
import org.checkerframework.nullaway.dataflow.analysis.Analysis;
import org.checkerframework.nullaway.dataflow.analysis.Store;
import org.checkerframework.nullaway.dataflow.analysis.TransferFunction;
import org.checkerframework.nullaway.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.nullaway.dataflow.cfg.UnderlyingAST;
import org.checkerframework.nullaway.dataflow.cfg.block.Block;
import org.checkerframework.nullaway.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.nullaway.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.nullaway.dataflow.cfg.visualize.AbstractCFGVisualizer;
import org.checkerframework.nullaway.dataflow.expression.ArrayAccess;
import org.checkerframework.nullaway.dataflow.expression.ClassName;
import org.checkerframework.nullaway.dataflow.expression.FieldAccess;
import org.checkerframework.nullaway.dataflow.expression.LocalVariable;
import org.checkerframework.nullaway.dataflow.expression.MethodCall;
import org.checkerframework.nullaway.javacutil.BugInCF;
import org.checkerframework.nullaway.javacutil.TreeUtils;
import org.checkerframework.nullaway.javacutil.UserError;

public class DOTCFGVisualizer<V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>>
extends AbstractCFGVisualizer<V, S, T> {
    protected String outDir;
    protected @Nullable String checkerName;
    protected Map<String, String> generated;
    protected static final String leftJustifiedTerminator = "\\l";

    @Override
    public void init(Map<String, Object> args) {
        super.init(args);
        this.outDir = (String)args.get("outdir");
        if (this.outDir == null) {
            throw new BugInCF("outDir should never be null, provide it in args when calling DOTCFGVisualizer.init(args).");
        }
        this.checkerName = (String)args.get("checkerName");
        this.generated = new HashMap<String, String>();
    }

    @Override
    public String getSeparator() {
        return leftJustifiedTerminator;
    }

    @Override
    public Map<String, Object> visualize(ControlFlowGraph cfg, Block entry, @Nullable Analysis<V, S, T> analysis) {
        String dotGraph = this.visualizeGraph(cfg, entry, analysis);
        HashMap<String, Object> vis = new HashMap<String, Object>(2);
        vis.put("dotGraph", dotGraph);
        return vis;
    }

    @Override
    public Map<String, Object> visualizeWithAction(ControlFlowGraph cfg, Block entry, @Nullable Analysis<V, S, T> analysis) {
        Map<String, Object> vis = this.visualize(cfg, entry, analysis);
        String dotGraph = (String)vis.get("dotGraph");
        if (dotGraph == null) {
            throw new BugInCF("dotGraph key missing in visualize result!");
        }
        String dotFileName = this.dotOutputFileName(cfg.underlyingAST);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(dotFileName));){
            out.write(dotGraph);
        }
        catch (IOException e) {
            throw new UserError("Error creating dot file (is the path valid?): " + dotFileName, new Object[]{e});
        }
        vis.put("dotFileName", dotFileName);
        return vis;
    }

    @Override
    public String visualizeNodes(Set<Block> blocks, ControlFlowGraph cfg, @Nullable Analysis<V, S, T> analysis) {
        StringBuilder sbDotNodes = new StringBuilder();
        IdentityHashMap<Block, List<Integer>> processOrder = this.getProcessOrder(cfg);
        for (Block v : blocks) {
            String strBlock;
            sbDotNodes.append("    ").append(v.getUid()).append(" [");
            if (v.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                sbDotNodes.append("shape=polygon sides=8 ");
            } else if (v.getType() == Block.BlockType.SPECIAL_BLOCK) {
                sbDotNodes.append("shape=oval ");
            } else {
                sbDotNodes.append("shape=rectangle ");
            }
            sbDotNodes.append("label=\"");
            if (this.verbose) {
                sbDotNodes.append(this.getProcessOrderSimpleString(processOrder.get(v))).append(this.getSeparator());
            }
            if ((strBlock = this.visualizeBlock(v, analysis)).length() == 0) {
                if (v.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                    sbDotNodes.append("\"];");
                } else {
                    sbDotNodes.append("?? empty ??\"];");
                }
            } else {
                sbDotNodes.append(strBlock).append("\"];");
            }
            sbDotNodes.append(System.lineSeparator());
        }
        return sbDotNodes.toString();
    }

    @Override
    protected String visualizeEdge(Object sId, Object eId, String flowRule) {
        return "    " + this.format(sId) + " -> " + this.format(eId) + " [label=\"" + flowRule + "\"];";
    }

    @Override
    public String visualizeBlock(Block bb, @Nullable Analysis<V, S, T> analysis) {
        return super.visualizeBlockHelper(bb, analysis, this.getSeparator());
    }

    @Override
    public String visualizeSpecialBlock(SpecialBlock sbb) {
        return super.visualizeSpecialBlockHelper(sbb);
    }

    @Override
    public String visualizeConditionalBlock(ConditionalBlock cbb) {
        return "";
    }

    @Override
    public String visualizeBlockTransferInputBefore(Block bb, Analysis<V, S, T> analysis) {
        return super.visualizeBlockTransferInputHelper(AbstractCFGVisualizer.VisualizeWhere.BEFORE, bb, analysis, this.getSeparator());
    }

    @Override
    public String visualizeBlockTransferInputAfter(Block bb, Analysis<V, S, T> analysis) {
        return super.visualizeBlockTransferInputHelper(AbstractCFGVisualizer.VisualizeWhere.AFTER, bb, analysis, this.getSeparator());
    }

    protected String dotOutputFileName(UnderlyingAST ast) {
        StringBuilder srcLoc = new StringBuilder();
        StringBuilder outFile = new StringBuilder(this.outDir);
        outFile.append("/");
        if (ast.getKind() == UnderlyingAST.Kind.ARBITRARY_CODE) {
            UnderlyingAST.CFGStatement cfgStatement = (UnderlyingAST.CFGStatement)ast;
            String clsName = cfgStatement.getSimpleClassName();
            outFile.append(clsName);
            outFile.append("-initializer-");
            outFile.append(ast.getUid());
            srcLoc.append("<");
            srcLoc.append(clsName);
            srcLoc.append("::initializer::");
            srcLoc.append(((JCTree)cfgStatement.getCode()).pos);
            srcLoc.append(">");
        } else if (ast.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod cfgMethod = (UnderlyingAST.CFGMethod)ast;
            String clsName = cfgMethod.getSimpleClassName();
            String methodName = cfgMethod.getMethodName();
            StringJoiner params = new StringJoiner(",");
            for (VariableTree variableTree : cfgMethod.getMethod().getParameters()) {
                params.add(variableTree.getType().toString());
            }
            outFile.append(clsName);
            outFile.append("-");
            outFile.append(methodName);
            if (params.length() != 0) {
                outFile.append("-");
                outFile.append(params);
            }
            srcLoc.append("<");
            srcLoc.append(clsName);
            srcLoc.append("::");
            srcLoc.append(methodName);
            srcLoc.append("(");
            srcLoc.append(params);
            srcLoc.append(")::");
            srcLoc.append(((JCTree)((Object)cfgMethod.getMethod())).pos);
            srcLoc.append(">");
        } else if (ast.getKind() == UnderlyingAST.Kind.LAMBDA) {
            UnderlyingAST.CFGLambda cfgLambda = (UnderlyingAST.CFGLambda)ast;
            String clsName = cfgLambda.getSimpleClassName();
            String enclosingMethodName = cfgLambda.getEnclosingMethodName();
            long uid = TreeUtils.treeUids.get(cfgLambda.getCode());
            outFile.append(clsName);
            outFile.append("-");
            if (enclosingMethodName != null) {
                outFile.append(enclosingMethodName);
                outFile.append("-");
            }
            outFile.append(uid);
            srcLoc.append("<");
            srcLoc.append(clsName);
            if (enclosingMethodName != null) {
                srcLoc.append("::");
                srcLoc.append(enclosingMethodName);
                srcLoc.append("(");
                @NonNull MethodTree methodTree = cfgLambda.getEnclosingMethod();
                srcLoc.append(methodTree.getParameters());
                srcLoc.append(")");
            }
            srcLoc.append("::");
            srcLoc.append(((JCTree)cfgLambda.getCode()).pos);
            srcLoc.append(">");
        } else {
            throw new BugInCF("Unexpected AST kind: " + (Object)((Object)ast.getKind()) + " value: " + ast);
        }
        if (this.checkerName != null && !this.checkerName.isEmpty()) {
            outFile.append('-');
            outFile.append(this.checkerName);
        }
        outFile.append(".dot");
        String outFileName = outFile.toString().replace("<", "_").replace(">", "");
        this.generated.put(srcLoc.toString(), outFileName);
        return outFileName;
    }

    @Override
    protected String format(Object obj) {
        return DOTCFGVisualizer.escapeString(obj);
    }

    @Override
    public String visualizeStoreThisVal(V value) {
        return "  this > " + DOTCFGVisualizer.escapeString(value);
    }

    @Override
    public String visualizeStoreLocalVar(LocalVariable localVar, V value) {
        return "  " + localVar + " > " + DOTCFGVisualizer.escapeString(value);
    }

    @Override
    public String visualizeStoreFieldVal(FieldAccess fieldAccess, V value) {
        return "  " + fieldAccess + " > " + DOTCFGVisualizer.escapeString(value);
    }

    @Override
    public String visualizeStoreArrayVal(ArrayAccess arrayValue, V value) {
        return "  " + arrayValue + " > " + DOTCFGVisualizer.escapeString(value);
    }

    @Override
    public String visualizeStoreMethodVals(MethodCall methodCall, V value) {
        return "  " + DOTCFGVisualizer.escapeString(methodCall) + " > " + DOTCFGVisualizer.escapeString(value);
    }

    @Override
    public String visualizeStoreClassVals(ClassName className, V value) {
        return "  " + className + " > " + DOTCFGVisualizer.escapeString(value);
    }

    @Override
    public String visualizeStoreKeyVal(String keyName, Object value) {
        return "  " + keyName + " = " + value;
    }

    private static String escapeString(String str) {
        return str.replace("\"", "\\\"").replace("\r", "\\\\r").replace("\n", "\\\\n");
    }

    private static String escapeString(Object obj) {
        return DOTCFGVisualizer.escapeString(String.valueOf(obj));
    }

    @Override
    public void shutdown() {
        try (FileWriter fstream = new FileWriter(this.outDir + "/methods.txt", true);
             BufferedWriter out = new BufferedWriter(fstream);){
            for (Map.Entry<String, String> kv : this.generated.entrySet()) {
                out.write(kv.getKey());
                out.append("\t");
                out.write(kv.getValue());
                out.append(lineSeparator);
            }
        }
        catch (IOException e) {
            throw new UserError("Error creating methods.txt file in: " + this.outDir + "; ensure the path is valid", new Object[]{e});
        }
    }

    @Override
    protected String visualizeGraphHeader() {
        return "digraph {" + lineSeparator;
    }

    @Override
    protected String visualizeGraphFooter() {
        return "}";
    }
}

