/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.node;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.element.PackageElement;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.nullaway.javacutil.BugInCF;
import org.checkerframework.nullaway.javacutil.TreeUtils;

public class PackageNameNode
extends Node {
    protected final Tree tree;
    protected final PackageElement element;
    protected final @Nullable PackageNameNode parent;

    public PackageNameNode(IdentifierTree tree) {
        super(TreeUtils.typeOf(tree));
        this.tree = tree;
        assert (TreeUtils.isUseOfElement(tree)) : "@AssumeAssertion(nullness): tree kind";
        PackageElement element = (PackageElement)TreeUtils.elementFromUse(tree);
        if (element == null) {
            throw new BugInCF("null element for %s [%s]", tree, tree.getClass());
        }
        this.element = element;
        this.parent = null;
    }

    public PackageNameNode(MemberSelectTree tree, PackageNameNode parent) {
        super(TreeUtils.typeOf(tree));
        this.tree = tree;
        assert (TreeUtils.isUseOfElement(tree)) : "@AssumeAssertion(nullness): tree kind";
        PackageElement element = (PackageElement)TreeUtils.elementFromUse(tree);
        if (element == null) {
            throw new BugInCF("null element for %s [%s]", tree, tree.getClass());
        }
        this.element = element;
        this.parent = parent;
    }

    public PackageElement getElement() {
        return this.element;
    }

    public @Nullable PackageNameNode getParent() {
        return this.parent;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitPackageName(this, p);
    }

    public String toString() {
        return this.getElement().getSimpleName().toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof PackageNameNode)) {
            return false;
        }
        PackageNameNode other = (PackageNameNode)obj;
        return Objects.equals(this.getParent(), other.getParent()) && this.getElement().equals(other.getElement());
    }

    public int hashCode() {
        return Objects.hash(this.getElement(), this.getParent());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        if (this.parent == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.parent);
    }
}

