/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.builder;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.util.Types;
import org.checkerframework.nullaway.dataflow.cfg.UnderlyingAST;
import org.checkerframework.nullaway.dataflow.cfg.builder.CFGBuilder;
import org.checkerframework.nullaway.dataflow.cfg.builder.ConditionalJump;
import org.checkerframework.nullaway.dataflow.cfg.builder.ExtendedNode;
import org.checkerframework.nullaway.dataflow.cfg.builder.Label;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.node.ReturnNode;

public class PhaseOneResult {
    final UnderlyingAST underlyingAST;
    final IdentityHashMap<Tree, Set<Node>> treeToCfgNodes;
    final IdentityHashMap<Tree, Set<Node>> treeToConvertedCfgNodes;
    final IdentityHashMap<UnaryTree, BinaryTree> postfixTreeToCfgNodes;
    final List<ExtendedNode> nodeList;
    final Map<Label, Integer> bindings;
    final Set<Integer> leaders;
    final List<ReturnNode> returnNodes;
    final Label regularExitLabel;
    final Label exceptionalExitLabel;
    final List<ClassTree> declaredClasses;
    final List<LambdaExpressionTree> declaredLambdas;
    final Types types;

    public PhaseOneResult(UnderlyingAST underlyingAST, IdentityHashMap<Tree, Set<Node>> treeToCfgNodes, IdentityHashMap<Tree, Set<Node>> treeToConvertedCfgNodes, IdentityHashMap<UnaryTree, BinaryTree> postfixTreeToCfgNodes, List<ExtendedNode> nodeList, Map<Label, Integer> bindings, Set<Integer> leaders, List<ReturnNode> returnNodes, Label regularExitLabel, Label exceptionalExitLabel, List<ClassTree> declaredClasses, List<LambdaExpressionTree> declaredLambdas, Types types) {
        this.underlyingAST = underlyingAST;
        this.treeToCfgNodes = treeToCfgNodes;
        this.treeToConvertedCfgNodes = treeToConvertedCfgNodes;
        this.postfixTreeToCfgNodes = postfixTreeToCfgNodes;
        this.nodeList = nodeList;
        this.bindings = bindings;
        this.leaders = leaders;
        this.returnNodes = returnNodes;
        this.regularExitLabel = regularExitLabel;
        this.exceptionalExitLabel = exceptionalExitLabel;
        this.declaredClasses = declaredClasses;
        this.declaredLambdas = declaredLambdas;
        this.types = types;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(System.lineSeparator());
        for (ExtendedNode n : this.nodeList) {
            sj.add(this.nodeToString(n));
        }
        return sj.toString();
    }

    protected String nodeToString(ExtendedNode n) {
        if (n.getType() == ExtendedNode.ExtendedNodeType.CONDITIONAL_JUMP) {
            ConditionalJump t2 = (ConditionalJump)n;
            return "TwoTargetConditionalJump(" + this.resolveLabel(t2.getThenLabel()) + ", " + this.resolveLabel(t2.getElseLabel()) + ")";
        }
        if (n.getType() == ExtendedNode.ExtendedNodeType.UNCONDITIONAL_JUMP) {
            return "UnconditionalJump(" + this.resolveLabel(n.getLabel()) + ")";
        }
        return n.toString();
    }

    private String resolveLabel(Label label) {
        Integer index = this.bindings.get(label);
        if (index == null) {
            return "unbound label: " + label;
        }
        return this.nodeToString(this.nodeList.get(index));
    }

    private <K, V> String mapToString(Map<K, V> map) {
        if (map.isEmpty()) {
            return "{}";
        }
        StringJoiner result = new StringJoiner(String.format("%n    ", new Object[0]), String.format("{%n    ", new Object[0]), String.format("%n    }", new Object[0]));
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.add(entry.getKey() + " => " + entry.getValue());
        }
        return result.toString();
    }

    public String toStringDebug() {
        StringJoiner result = new StringJoiner(String.format("%n  ", new Object[0]), String.format("PhaseOneResult{%n  ", new Object[0]), String.format("%n  }", new Object[0]));
        result.add("treeToCfgNodes=" + this.mapToString(this.treeToCfgNodes));
        result.add("treeToConvertedCfgNodes=" + this.mapToString(this.treeToConvertedCfgNodes));
        result.add("postfixTreeToCfgNodes=" + this.mapToString(this.postfixTreeToCfgNodes));
        result.add("underlyingAST=" + this.underlyingAST);
        result.add("bindings=" + this.bindings);
        result.add("nodeList=" + CFGBuilder.extendedNodeCollectionToStringDebug(this.nodeList));
        result.add("leaders=" + this.leaders);
        result.add("returnNodes=" + Node.nodeCollectionToString(this.returnNodes));
        result.add("regularExitLabel=" + this.regularExitLabel);
        result.add("exceptionalExitLabel=" + this.exceptionalExitLabel);
        result.add("declaredClasses=" + this.declaredClasses);
        result.add("declaredLambdas=" + this.declaredLambdas);
        return result.toString();
    }
}

