/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.javacutil.trees;

import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;
import org.checkerframework.nullaway.javacutil.Pair;

public class TreeParser {
    private static final String DELIMS = ".[](),";
    private static final String SENTINEL = "";
    private final TreeMaker maker;
    private final Names names;

    public TreeParser(ProcessingEnvironment env) {
        Context context = ((JavacProcessingEnvironment)env).getContext();
        this.maker = TreeMaker.instance(context);
        this.names = Names.instance(context);
    }

    public ExpressionTree parseTree(String s2) {
        StringTokenizer tokenizer = new StringTokenizer(s2, DELIMS, true);
        String token = tokenizer.nextToken();
        try {
            ExpressionTree expressionTree = (ExpressionTree)this.parseExpression((StringTokenizer)tokenizer, (String)token).first;
            return expressionTree;
        }
        catch (Exception e) {
            throw new ParseError(e);
        }
        finally {
            tokenizer = null;
            token = null;
        }
    }

    private String nextToken(StringTokenizer tokenizer) {
        return tokenizer.hasMoreTokens() ? tokenizer.nextToken() : SENTINEL;
    }

    private JCTree.JCExpression fromToken(String token) {
        Number value;
        if ("true".equals(token)) {
            return this.maker.Literal(true);
        }
        if ("false".equals(token)) {
            return this.maker.Literal(false);
        }
        if (Character.isLetter(token.charAt(0))) {
            return this.maker.Ident(this.names.fromString(token));
        }
        try {
            value = Integer.valueOf(token);
        }
        catch (Exception e2) {
            try {
                value = Double.valueOf(token);
            }
            catch (Exception ef) {
                throw new Error("Can't parse as integer or double: " + token);
            }
        }
        return this.maker.Literal(value);
    }

    private Pair<JCTree.JCExpression, String> parseExpression(StringTokenizer tokenizer, String token) {
        JCTree.JCExpression tree = this.fromToken(token);
        while (tokenizer.hasMoreTokens()) {
            String delim;
            token = delim = this.nextToken(tokenizer);
            if (".".equals(delim)) {
                token = this.nextToken(tokenizer);
                tree = this.maker.Select(tree, this.names.fromString(token));
            } else if ("(".equals(delim)) {
                token = this.nextToken(tokenizer);
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                while (!")".equals(token)) {
                    Pair<JCTree.JCExpression, String> p = this.parseExpression(tokenizer, token);
                    JCTree.JCExpression arg = (JCTree.JCExpression)p.first;
                    token = (String)p.second;
                    args.append(arg);
                    if (!",".equals(token)) continue;
                    token = this.nextToken(tokenizer);
                }
                assert (")".equals(token)) : "Unexpected token: " + token;
                tree = this.maker.Apply(List.nil(), tree, args.toList());
            } else if ("[".equals(token)) {
                token = this.nextToken(tokenizer);
                Pair<JCTree.JCExpression, String> p = this.parseExpression(tokenizer, token);
                JCTree.JCExpression index = (JCTree.JCExpression)p.first;
                token = (String)p.second;
                assert ("]".equals(token)) : "Unexpected token: " + token;
                tree = this.maker.Indexed(tree, index);
            } else {
                return Pair.of(tree, token);
            }
            assert (tokenizer != null) : "@AssumeAssertion(nullness): side effects";
        }
        return Pair.of(tree, token);
    }

    private static class ParseError
    extends RuntimeException {
        private static final long serialVersionUID = 1887754619522101929L;

        ParseError(Throwable cause) {
            super(cause);
        }
    }
}

