/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.javacutil;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.nullaway.checker.interning.qual.PolyInterned;
import org.checkerframework.nullaway.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.nullaway.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.checker.signature.qual.FullyQualifiedName;
import org.checkerframework.nullaway.javacutil.BugInCF;
import org.checkerframework.nullaway.javacutil.ElementUtils;
import org.checkerframework.nullaway.javacutil.SystemUtil;
import org.checkerframework.nullaway.javacutil.TypeAnnotationUtils;
import org.checkerframework.nullaway.javacutil.TypesUtils;
import org.checkerframework.nullaway.javacutil.UserError;
import org.checkerframework.nullaway.org.plumelib.util.CollectionsPlume;
import org.checkerframework.nullaway.org.plumelib.util.UniqueIdMap;

public final class TreeUtils {
    public static final UniqueIdMap<Tree> treeUids = new UniqueIdMap();
    private static final long Flags_GENERATED_MEMBER = 0x1000000L;
    private static final long Flags_RECORD = 0x2000000000000000L;
    static final long Flags_COMPACT_RECORD_CONSTRUCTOR = 0x8000000000000L;
    private static @Nullable Method caseGetExpressions = null;
    private static @MonotonicNonNull Method caseGetBody = null;
    private static @MonotonicNonNull Method bindingPatternGetVariable = null;
    private static @MonotonicNonNull Method instanceOfGetPattern = null;
    private static @MonotonicNonNull Method switchExpressionGetExpression = null;
    private static @MonotonicNonNull Method switchExpressionGetCases = null;
    private static @MonotonicNonNull Method yieldGetValue = null;
    private static final Set<Tree.Kind> classTreeKinds;
    private static final Set<Tree.Kind> declarationTreeKinds;
    private static final Set<Tree.Kind> typeTreeKinds;

    private TreeUtils() {
        throw new AssertionError((Object)"Class TreeUtils cannot be instantiated.");
    }

    public static boolean isConstructor(MethodTree tree) {
        return tree.getName().contentEquals("<init>");
    }

    public static boolean isSuperConstructorCall(MethodInvocationTree tree) {
        return TreeUtils.isNamedMethodCall("super", tree);
    }

    public static boolean isThisConstructorCall(MethodInvocationTree tree) {
        return TreeUtils.isNamedMethodCall("this", tree);
    }

    private static boolean isNamedMethodCall(String name, MethodInvocationTree tree) {
        return TreeUtils.getMethodName(tree.getMethodSelect()).contentEquals(name);
    }

    public static boolean isSelfAccess(ExpressionTree tree) {
        ExpressionTree tr = TreeUtils.withoutParens(tree);
        if (tr.getKind() == Tree.Kind.ARRAY_ACCESS) {
            return false;
        }
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            tr = ((MethodInvocationTree)tree).getMethodSelect();
        }
        if ((tr = TreeUtils.withoutParens(tr)).getKind() == Tree.Kind.TYPE_CAST) {
            tr = ((TypeCastTree)tr).getExpression();
        }
        if ((tr = TreeUtils.withoutParens(tr)).getKind() == Tree.Kind.IDENTIFIER) {
            return true;
        }
        if (tr.getKind() == Tree.Kind.MEMBER_SELECT && (tr = ((MemberSelectTree)tr).getExpression()).getKind() == Tree.Kind.IDENTIFIER) {
            Name ident = ((IdentifierTree)tr).getName();
            return ident.contentEquals("this") || ident.contentEquals("super");
        }
        return false;
    }

    public static @PolyInterned ExpressionTree withoutParens(@PolyInterned ExpressionTree tree) {
        ExpressionTree t2 = tree;
        while (t2.getKind() == Tree.Kind.PARENTHESIZED) {
            t2 = ((ParenthesizedTree)t2).getExpression();
        }
        return t2;
    }

    public static @PolyInterned ExpressionTree withoutParensOrCasts(@PolyInterned ExpressionTree tree) {
        ExpressionTree t2 = TreeUtils.withoutParens(tree);
        while (t2.getKind() == Tree.Kind.TYPE_CAST) {
            t2 = TreeUtils.withoutParens(((TypeCastTree)t2).getExpression());
        }
        return t2;
    }

    @Pure
    public static @Nullable Element elementFromTree(Tree tree) {
        if (tree == null) {
            throw new BugInCF("TreeUtils.elementFromTree: tree is null");
        }
        if (!(tree instanceof JCTree)) {
            throw new BugInCF("TreeUtils.elementFromTree: tree is not a valid Javac tree but a " + tree.getClass());
        }
        if (TreeUtils.isExpressionTree(tree)) {
            tree = TreeUtils.withoutParensOrCasts((ExpressionTree)tree);
        }
        switch (tree.getKind()) {
            case METHOD_INVOCATION: {
                return TreeInfo.symbol(((JCTree.JCMethodInvocation)tree).getMethodSelect());
            }
            case ASSIGNMENT: {
                return TreeInfo.symbol((JCTree)((Object)((AssignmentTree)tree).getVariable()));
            }
            case ARRAY_ACCESS: {
                return TreeUtils.elementFromTree(((ArrayAccessTree)tree).getExpression());
            }
            case NEW_CLASS: {
                return ((JCTree.JCNewClass)tree).constructor;
            }
            case MEMBER_REFERENCE: {
                return ((JCTree.JCMemberReference)tree).sym;
            }
        }
        if (TreeUtils.isTypeDeclaration(tree) || tree.getKind() == Tree.Kind.VARIABLE || tree.getKind() == Tree.Kind.METHOD) {
            return TreeInfo.symbolFor((JCTree)tree);
        }
        return TreeInfo.symbol((JCTree)tree);
    }

    public static TypeElement elementFromDeclaration(ClassTree node) {
        TypeElement elt = (TypeElement)TreeUtils.elementFromTree(node);
        assert (elt != null) : "@AssumeAssertion(nullness): tree kind";
        return elt;
    }

    public static ExecutableElement elementFromDeclaration(MethodTree node) {
        ExecutableElement elt = (ExecutableElement)TreeUtils.elementFromTree(node);
        assert (elt != null) : "@AssumeAssertion(nullness): tree kind";
        return elt;
    }

    public static VariableElement elementFromDeclaration(VariableTree node) {
        VariableElement elt = (VariableElement)TreeUtils.elementFromTree(node);
        assert (elt != null) : "@AssumeAssertion(nullness): tree kind";
        return elt;
    }

    @Pure
    public static @Nullable Element elementFromUse(ExpressionTree node) {
        return TreeUtils.elementFromTree(node);
    }

    @Pure
    public static ExecutableElement elementFromUse(MethodInvocationTree node) {
        Element el = TreeUtils.elementFromTree(node);
        if (!(el instanceof ExecutableElement)) {
            throw new BugInCF("Method elements should be ExecutableElement. Found: %s", el);
        }
        return (ExecutableElement)el;
    }

    @Pure
    public static ExecutableElement elementFromUse(NewClassTree node) {
        Element el = TreeUtils.elementFromTree(node);
        if (!(el instanceof ExecutableElement)) {
            throw new BugInCF("Constructor elements should  be ExecutableElement. Found: %s", el);
        }
        return (ExecutableElement)el;
    }

    public static ExecutableElement getSuperConstructor(NewClassTree newClassTree) {
        if (newClassTree.getClassBody() == null) {
            return TreeUtils.constructor(newClassTree);
        }
        JCTree.JCNewClass jcNewClass = (JCTree.JCNewClass)newClassTree;
        JCTree.JCMethodDecl anonConstructor = (JCTree.JCMethodDecl)TreeInfo.declarationFor(jcNewClass.constructor, jcNewClass);
        assert (anonConstructor != null);
        assert (anonConstructor.body.stats.size() == 1);
        JCTree.JCExpressionStatement stmt = (JCTree.JCExpressionStatement)anonConstructor.body.stats.head;
        JCTree.JCMethodInvocation superInvok = (JCTree.JCMethodInvocation)stmt.expr;
        return (ExecutableElement)((Object)TreeInfo.symbol(superInvok.meth));
    }

    public static ExecutableElement constructor(NewClassTree tree) {
        return (ExecutableElement)((Object)((JCTree.JCNewClass)tree).constructor);
    }

    @EnsuresNonNullIf(result=true, expression={"elementFromUse(#1)"})
    @Pure
    public static boolean isUseOfElement(ExpressionTree node) {
        ExpressionTree realnode = TreeUtils.withoutParens(node);
        switch (realnode.getKind()) {
            case METHOD_INVOCATION: 
            case NEW_CLASS: 
            case IDENTIFIER: 
            case MEMBER_SELECT: {
                assert (TreeUtils.elementFromUse(node) != null) : "@AssumeAssertion(nullness): inspection";
                return true;
            }
        }
        return false;
    }

    public static boolean hasSyntheticArgument(NewClassTree tree) {
        if (tree.getClassBody() == null || tree.getEnclosingExpression() != null) {
            return false;
        }
        for (Tree tree2 : tree.getClassBody().getMembers()) {
            if (tree2.getKind() != Tree.Kind.METHOD || !TreeUtils.isConstructor((MethodTree)tree2)) continue;
            MethodTree methodTree = (MethodTree)tree2;
            StatementTree f = methodTree.getBody().getStatements().get(0);
            return TreeUtils.getReceiverTree(((ExpressionStatementTree)f).getExpression()) != null;
        }
        return false;
    }

    public static Name methodName(MethodInvocationTree node) {
        ExpressionTree expr = node.getMethodSelect();
        if (expr.getKind() == Tree.Kind.IDENTIFIER) {
            return ((IdentifierTree)expr).getName();
        }
        if (expr.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)expr).getIdentifier();
        }
        throw new BugInCF("TreeUtils.methodName: cannot be here: " + node);
    }

    public static boolean containsThisConstructorInvocation(MethodTree node) {
        if (!TreeUtils.isConstructor(node) || node.getBody().getStatements().isEmpty()) {
            return false;
        }
        StatementTree st = node.getBody().getStatements().get(0);
        if (!(st instanceof ExpressionStatementTree) || !(((ExpressionStatementTree)st).getExpression() instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree invocation = (MethodInvocationTree)((ExpressionStatementTree)st).getExpression();
        return "this".contentEquals(TreeUtils.methodName(invocation));
    }

    public static Tree firstStatement(Tree tree) {
        BlockTree block;
        Tree first = tree.getKind() == Tree.Kind.BLOCK ? ((block = (BlockTree)tree).getStatements().isEmpty() ? block : (Tree)block.getStatements().iterator().next()) : tree;
        return first;
    }

    public static boolean hasExplicitConstructor(ClassTree node) {
        TypeElement elem = TreeUtils.elementFromDeclaration(node);
        for (ExecutableElement constructorElt : ElementFilter.constructorsIn(elem.getEnclosedElements())) {
            if (TreeUtils.isSynthetic(constructorElt)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSynthetic(ExecutableElement ee) {
        Symbol.MethodSymbol ms = (Symbol.MethodSymbol)ee;
        long mod = ms.flags();
        return (mod & 0x1000001000L) != 0L;
    }

    public static boolean isSynthetic(MethodTree node) {
        ExecutableElement ee = TreeUtils.elementFromDeclaration(node);
        return TreeUtils.isSynthetic(ee);
    }

    public static boolean isDiamondTree(Tree tree) {
        switch (tree.getKind()) {
            case ANNOTATED_TYPE: {
                return TreeUtils.isDiamondTree(((AnnotatedTypeTree)tree).getUnderlyingType());
            }
            case PARAMETERIZED_TYPE: {
                return ((ParameterizedTypeTree)tree).getTypeArguments().isEmpty();
            }
            case NEW_CLASS: {
                return TreeUtils.isDiamondTree(((NewClassTree)tree).getIdentifier());
            }
        }
        return false;
    }

    public static boolean isStringConcatenation(Tree tree) {
        return tree.getKind() == Tree.Kind.PLUS && TypesUtils.isString(TreeUtils.typeOf(tree));
    }

    public static boolean isStringCompoundConcatenation(CompoundAssignmentTree tree) {
        return tree.getKind() == Tree.Kind.PLUS_ASSIGNMENT && TypesUtils.isString(TreeUtils.typeOf(tree));
    }

    public static boolean isCompileTimeString(ExpressionTree node) {
        ExpressionTree tree = TreeUtils.withoutParens(node);
        if (tree instanceof LiteralTree) {
            return true;
        }
        if (TreeUtils.isUseOfElement(tree)) {
            Element elt = TreeUtils.elementFromUse(tree);
            return ElementUtils.isCompileTimeConstant(elt);
        }
        if (TreeUtils.isStringConcatenation(tree)) {
            BinaryTree binOp = (BinaryTree)tree;
            return TreeUtils.isCompileTimeString(binOp.getLeftOperand()) && TreeUtils.isCompileTimeString(binOp.getRightOperand());
        }
        return false;
    }

    public static @Nullable ExpressionTree getReceiverTree(ExpressionTree expression) {
        ExpressionTree receiver;
        switch (expression.getKind()) {
            case METHOD_INVOCATION: {
                receiver = ((MethodInvocationTree)expression).getMethodSelect();
                if (receiver.getKind() == Tree.Kind.MEMBER_SELECT) {
                    receiver = ((MemberSelectTree)receiver).getExpression();
                    break;
                }
                return null;
            }
            case NEW_CLASS: {
                receiver = ((NewClassTree)expression).getEnclosingExpression();
                break;
            }
            case ARRAY_ACCESS: {
                receiver = ((ArrayAccessTree)expression).getExpression();
                break;
            }
            case MEMBER_SELECT: {
                receiver = ((MemberSelectTree)expression).getExpression();
                if (!(receiver instanceof PrimitiveTypeTree)) break;
                return null;
            }
            case IDENTIFIER: {
                return null;
            }
            default: {
                return null;
            }
        }
        if (receiver == null) {
            return null;
        }
        return TreeUtils.withoutParens(receiver);
    }

    public static Set<Tree.Kind> classTreeKinds() {
        return classTreeKinds;
    }

    public static Set<Tree.Kind> declarationTreeKinds() {
        return declarationTreeKinds;
    }

    public static boolean isClassTree(Tree tree) {
        return TreeUtils.classTreeKinds().contains((Object)tree.getKind());
    }

    public static Set<Tree.Kind> typeTreeKinds() {
        return typeTreeKinds;
    }

    public static boolean isTypeTree(Tree tree) {
        return TreeUtils.typeTreeKinds().contains((Object)tree.getKind());
    }

    public static boolean isMethodInvocation(Tree tree, ExecutableElement method, ProcessingEnvironment env) {
        if (!(tree instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree methInvok = (MethodInvocationTree)tree;
        ExecutableElement invoked = TreeUtils.elementFromUse(methInvok);
        if (invoked == null) {
            return false;
        }
        return ElementUtils.isMethod(invoked, method, env);
    }

    public static boolean isMethodInvocation(Tree methodTree, List<ExecutableElement> methods, ProcessingEnvironment processingEnv) {
        if (!(methodTree instanceof MethodInvocationTree)) {
            return false;
        }
        for (ExecutableElement Method2 : methods) {
            if (!TreeUtils.isMethodInvocation(methodTree, Method2, processingEnv)) continue;
            return true;
        }
        return false;
    }

    public static ExecutableElement getMethod(Class<?> type, String methodName, int params, ProcessingEnvironment env) {
        String typeName = type.getCanonicalName();
        if (typeName == null) {
            throw new BugInCF("class %s has no canonical name", type);
        }
        return TreeUtils.getMethod(typeName, methodName, params, env);
    }

    public static ExecutableElement getMethod(@FullyQualifiedName String typeName, String methodName, int params, ProcessingEnvironment env) {
        List<ExecutableElement> methods = TreeUtils.getMethods(typeName, methodName, params, env);
        if (methods.size() == 1) {
            return methods.get(0);
        }
        throw new BugInCF("TreeUtils.getMethod(%s, %s, %d): expected 1 match, found %d", typeName, methodName, params, methods.size());
    }

    public static @Nullable ExecutableElement getMethodOrNull(@FullyQualifiedName String typeName, String methodName, int params, ProcessingEnvironment env) {
        List<ExecutableElement> methods = TreeUtils.getMethods(typeName, methodName, params, env);
        if (methods.size() == 0) {
            return null;
        }
        if (methods.size() == 1) {
            return methods.get(0);
        }
        throw new BugInCF("TreeUtils.getMethod(%s, %s, %d): expected 0 or 1 match, found %d", typeName, methodName, params, methods.size());
    }

    public static List<ExecutableElement> getMethods(@FullyQualifiedName String typeName, String methodName, int params, ProcessingEnvironment env) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>(1);
        TypeElement typeElt = env.getElementUtils().getTypeElement(typeName);
        if (typeElt == null) {
            throw new UserError("Configuration problem! Could not load type: " + typeName);
        }
        for (ExecutableElement exec : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
            if (!exec.getSimpleName().contentEquals(methodName) || exec.getParameters().size() != params) continue;
            methods.add(exec);
        }
        return methods;
    }

    public static ExecutableElement getMethod(Class<?> type, String methodName, ProcessingEnvironment env, String ... paramTypes) {
        String typeName = type.getCanonicalName();
        if (typeName == null) {
            throw new BugInCF("TreeUtils.getMethod: class %s has no canonical name", type);
        }
        return TreeUtils.getMethod(typeName, methodName, env, paramTypes);
    }

    public static ExecutableElement getMethod(@FullyQualifiedName String typeName, String methodName, ProcessingEnvironment env, String ... paramTypes) {
        TypeElement typeElt = env.getElementUtils().getTypeElement(typeName);
        for (ExecutableElement exec : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
            if (!exec.getSimpleName().contentEquals(methodName) || exec.getParameters().size() != paramTypes.length) continue;
            boolean typesMatch = true;
            List<? extends VariableElement> params = exec.getParameters();
            for (int i = 0; i < paramTypes.length; ++i) {
                VariableElement ve = params.get(i);
                Type tm = TypeAnnotationUtils.unannotatedType(ve.asType());
                if (tm.toString().equals(paramTypes[i])) continue;
                typesMatch = false;
                break;
            }
            if (!typesMatch) continue;
            return exec;
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (ExecutableElement exec : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
            if (!exec.getSimpleName().contentEquals(methodName)) continue;
            candidates.add(TreeUtils.executableElementToString(exec));
        }
        if (candidates.isEmpty()) {
            for (ExecutableElement exec : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                candidates.add(TreeUtils.executableElementToString(exec));
            }
        }
        throw new BugInCF("TreeUtils.getMethod: found no match for %s.%s(%s); candidates: %s", typeName, methodName, Arrays.toString(paramTypes), candidates);
    }

    private static String executableElementToString(ExecutableElement exec) {
        StringJoiner result = new StringJoiner(", ", exec.getSimpleName() + "(", ")");
        for (VariableElement variableElement : exec.getParameters()) {
            result.add(TypeAnnotationUtils.unannotatedType(variableElement.asType()).toString());
        }
        return result.toString();
    }

    public static boolean isExplicitThisDereference(ExpressionTree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)tree).getName().contentEquals("this")) {
            return true;
        }
        if (tree.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        MemberSelectTree memSelTree = (MemberSelectTree)tree;
        return memSelTree.getIdentifier().contentEquals("this");
    }

    public static boolean isClassLiteral(Tree tree) {
        if (tree.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        return "class".equals(((MemberSelectTree)tree).getIdentifier().toString());
    }

    public static boolean isFieldAccess(Tree tree) {
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree memberSelect = (MemberSelectTree)tree;
            assert (TreeUtils.isUseOfElement(memberSelect)) : "@AssumeAssertion(nullness): tree kind";
            Element el = TreeUtils.elementFromUse(memberSelect);
            return el.getKind().isField();
        }
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            IdentifierTree ident = (IdentifierTree)tree;
            assert (TreeUtils.isUseOfElement(ident)) : "@AssumeAssertion(nullness): tree kind";
            Element el = TreeUtils.elementFromUse(ident);
            return el.getKind().isField() && !ident.getName().contentEquals("this") && !ident.getName().contentEquals("super");
        }
        return false;
    }

    public static String getFieldName(Tree tree) {
        assert (TreeUtils.isFieldAccess(tree));
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree mtree = (MemberSelectTree)tree;
            return mtree.getIdentifier().toString();
        }
        IdentifierTree itree = (IdentifierTree)tree;
        return itree.getName().toString();
    }

    public static boolean isMethodAccess(Tree tree) {
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree memberSelect = (MemberSelectTree)tree;
            assert (TreeUtils.isUseOfElement(memberSelect)) : "@AssumeAssertion(nullness): tree kind";
            Element el = TreeUtils.elementFromUse(memberSelect);
            return el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR;
        }
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            IdentifierTree ident = (IdentifierTree)tree;
            if (ident.getName().contentEquals("super") || ident.getName().contentEquals("this")) {
                return true;
            }
            assert (TreeUtils.isUseOfElement(ident)) : "@AssumeAssertion(nullness): tree kind";
            Element el = TreeUtils.elementFromUse(ident);
            return el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR;
        }
        return false;
    }

    public static String getMethodName(Tree tree) {
        assert (TreeUtils.isMethodAccess(tree));
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree mtree = (MemberSelectTree)tree;
            return mtree.getIdentifier().toString();
        }
        IdentifierTree itree = (IdentifierTree)tree;
        return itree.getName().toString();
    }

    public static boolean canHaveTypeAnnotation(Tree tree) {
        return ((JCTree)tree).type != null;
    }

    public static boolean isSpecificFieldAccess(Tree tree, VariableElement var) {
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memSel = (MemberSelectTree)tree;
            assert (TreeUtils.isUseOfElement(memSel)) : "@AssumeAssertion(nullness): tree kind";
            Element field = TreeUtils.elementFromUse(memSel);
            return field.equals(var);
        }
        if (tree instanceof IdentifierTree) {
            IdentifierTree idTree = (IdentifierTree)tree;
            assert (TreeUtils.isUseOfElement(idTree)) : "@AssumeAssertion(nullness): tree kind";
            Element field = TreeUtils.elementFromUse(idTree);
            return field.equals(var);
        }
        return false;
    }

    public static VariableElement getField(@FullyQualifiedName String typeName, String fieldName, ProcessingEnvironment env) {
        TypeElement mapElt = env.getElementUtils().getTypeElement(typeName);
        for (VariableElement var : ElementFilter.fieldsIn(mapElt.getEnclosedElements())) {
            if (!var.getSimpleName().contentEquals(fieldName)) continue;
            return var;
        }
        throw new BugInCF("TreeUtils.getField: shouldn't be here");
    }

    public static boolean isExpressionTree(Tree tree) {
        return tree instanceof ExpressionTree;
    }

    public static boolean isEnumSuper(MethodInvocationTree node) {
        ExecutableElement ex = TreeUtils.elementFromUse(node);
        assert (ex != null) : "@AssumeAssertion(nullness): tree kind";
        Name name = ElementUtils.getQualifiedClassName(ex);
        assert (name != null) : "@AssumeAssertion(nullness): assumption";
        boolean correctClass = "java.lang.Enum".contentEquals(name);
        boolean correctMethod = "<init>".contentEquals(ex.getSimpleName());
        return correctClass && correctMethod;
    }

    public static boolean isTypeDeclaration(Tree node) {
        return TreeUtils.isClassTree(node) || node.getKind() == Tree.Kind.TYPE_PARAMETER;
    }

    public static boolean isArrayLengthAccess(Tree tree) {
        ExpressionTree expressionTree;
        return tree.getKind() == Tree.Kind.MEMBER_SELECT && TreeUtils.isFieldAccess(tree) && TreeUtils.getFieldName(tree).equals("length") && TreeUtils.typeOf(expressionTree = ((MemberSelectTree)tree).getExpression()).getKind() == TypeKind.ARRAY;
    }

    public static boolean isAnonymousConstructor(MethodTree method) {
        @Nullable Element e = TreeUtils.elementFromTree(method);
        if (e == null || e.getKind() != ElementKind.CONSTRUCTOR) {
            return false;
        }
        TypeElement typeElement = (TypeElement)e.getEnclosingElement();
        return typeElement.getNestingKind() == NestingKind.ANONYMOUS;
    }

    public static boolean isCompactCanonicalRecordConstructor(MethodTree method) {
        @Nullable Element e = TreeUtils.elementFromTree(method);
        if (!(e instanceof Symbol)) {
            return false;
        }
        return (((Symbol)e).flags() & 0x2000000000000000L) != 0L;
    }

    public static boolean isAutoGeneratedRecordMember(Tree member) {
        Element e = TreeUtils.elementFromTree(member);
        if (!(e instanceof Symbol)) {
            return false;
        }
        return (((Symbol)e).flags() & 0x1001000000L) != 0L;
    }

    public static List<AnnotationMirror> annotationsFromTypeAnnotationTrees(List<? extends AnnotationTree> annoTrees) {
        return CollectionsPlume.mapList(TreeUtils::annotationFromAnnotationTree, annoTrees);
    }

    public static AnnotationMirror annotationFromAnnotationTree(AnnotationTree tree) {
        return ((JCTree.JCAnnotation)tree).attribute;
    }

    public static List<? extends AnnotationMirror> annotationsFromTree(AnnotatedTypeTree tree) {
        return TreeUtils.annotationsFromTypeAnnotationTrees(((JCTree.JCAnnotatedType)tree).annotations);
    }

    public static List<? extends AnnotationMirror> annotationsFromTree(TypeParameterTree tree) {
        return TreeUtils.annotationsFromTypeAnnotationTrees(((JCTree.JCTypeParameter)tree).annotations);
    }

    public static List<? extends AnnotationMirror> annotationsFromArrayCreation(NewArrayTree tree, int level) {
        assert (tree instanceof JCTree.JCNewArray);
        JCTree.JCNewArray newArray = (JCTree.JCNewArray)tree;
        if (level == -1) {
            return TreeUtils.annotationsFromTypeAnnotationTrees(newArray.annotations);
        }
        if (newArray.dimAnnotations.length() > 0 && level >= 0 && level < newArray.dimAnnotations.size()) {
            return TreeUtils.annotationsFromTypeAnnotationTrees((List<? extends AnnotationTree>)newArray.dimAnnotations.get(level));
        }
        return Collections.emptyList();
    }

    public static boolean isLocalVariable(Tree tree) {
        if (tree.getKind() == Tree.Kind.VARIABLE) {
            return TreeUtils.elementFromDeclaration((VariableTree)tree).getKind() == ElementKind.LOCAL_VARIABLE;
        }
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            ExpressionTree etree = (ExpressionTree)tree;
            assert (TreeUtils.isUseOfElement(etree)) : "@AssumeAssertion(nullness): tree kind";
            return TreeUtils.elementFromUse(etree).getKind() == ElementKind.LOCAL_VARIABLE;
        }
        return false;
    }

    public static TypeMirror typeOf(Tree tree) {
        return ((JCTree)tree).type;
    }

    public static Symbol findFunction(Tree tree, ProcessingEnvironment env) {
        Context ctx = ((JavacProcessingEnvironment)env).getContext();
        Types javacTypes = Types.instance(ctx);
        return javacTypes.findDescriptorSymbol(((Type)TreeUtils.typeOf(tree)).asElement());
    }

    public static boolean isImplicitlyTypedLambda(Tree tree) {
        return tree.getKind() == Tree.Kind.LAMBDA_EXPRESSION && ((JCTree.JCLambda)tree).paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT;
    }

    public static boolean isExprConstTrue(ExpressionTree node) {
        assert (node instanceof JCTree.JCExpression);
        if (((JCTree.JCExpression)node).type.isTrue()) {
            return true;
        }
        ExpressionTree tree = TreeUtils.withoutParens(node);
        if (tree instanceof JCTree.JCBinary) {
            JCTree.JCBinary binTree = (JCTree.JCBinary)tree;
            JCTree.JCExpression ltree = binTree.lhs;
            JCTree.JCExpression rtree = binTree.rhs;
            switch (binTree.getTag()) {
                case AND: {
                    return TreeUtils.isExprConstTrue(ltree) && TreeUtils.isExprConstTrue(rtree);
                }
                case OR: {
                    return TreeUtils.isExprConstTrue(ltree) || TreeUtils.isExprConstTrue(rtree);
                }
            }
        }
        return false;
    }

    public static String toStringOneLine(Tree tree) {
        return tree.toString().trim().replaceAll("\\s+", " ");
    }

    public static String toStringTruncated(Tree tree, int length) {
        if (length < 6) {
            throw new IllegalArgumentException("bad length " + length);
        }
        String result = TreeUtils.toStringOneLine(tree);
        if (result.length() > length) {
            result = "\"" + result.substring(0, length - 5) + "...\"";
        }
        return result;
    }

    public static String nameExpressionToString(ExpressionTree nameExpr) {
        SimpleTreeVisitor<String, Void> visitor = new SimpleTreeVisitor<String, Void>(){

            @Override
            public String visitIdentifier(IdentifierTree node, Void p) {
                return node.toString();
            }

            @Override
            public String visitMemberSelect(MemberSelectTree node, Void p) {
                return node.getExpression().accept(this, null) + "." + node.getIdentifier().toString();
            }
        };
        return nameExpr.accept(visitor, null);
    }

    public static boolean isWideningBinary(BinaryTree node) {
        switch (node.getKind()) {
            case LEFT_SHIFT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return true;
            }
            case MULTIPLY: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS: 
            case PLUS_ASSIGNMENT: 
            case MINUS: 
            case MINUS_ASSIGNMENT: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case AND: 
            case XOR: 
            case OR: {
                return true;
            }
        }
        return false;
    }

    public static List<? extends AnnotationTree> getExplicitAnnotationTrees(@Nullable List<? extends AnnotationTree> annoTrees, Tree typeTree) {
        block8: while (true) {
            switch (typeTree.getKind()) {
                case IDENTIFIER: 
                case PRIMITIVE_TYPE: {
                    if (annoTrees == null) {
                        return Collections.emptyList();
                    }
                    return annoTrees;
                }
                case ANNOTATED_TYPE: {
                    return ((AnnotatedTypeTree)typeTree).getAnnotations();
                }
                case ARRAY_TYPE: 
                case TYPE_PARAMETER: 
                case UNBOUNDED_WILDCARD: 
                case EXTENDS_WILDCARD: 
                case SUPER_WILDCARD: {
                    return Collections.emptyList();
                }
                case MEMBER_SELECT: {
                    if (annoTrees == null) {
                        return Collections.emptyList();
                    }
                    typeTree = ((MemberSelectTree)typeTree).getExpression();
                    continue block8;
                }
                case PARAMETERIZED_TYPE: {
                    typeTree = ((ParameterizedTypeTree)typeTree).getType();
                    continue block8;
                }
                case UNION_TYPE: {
                    ArrayList<? extends AnnotationTree> result = new ArrayList<AnnotationTree>();
                    for (Tree tree : ((UnionTypeTree)typeTree).getTypeAlternatives()) {
                        result.addAll(TreeUtils.getExplicitAnnotationTrees(null, tree));
                    }
                    return result;
                }
            }
            break;
        }
        throw new BugInCF("what typeTree? %s %s %s", new Object[]{typeTree.getKind(), typeTree.getClass(), typeTree});
    }

    public static LiteralTree getDefaultValueTree(TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        switch (typeMirror.getKind()) {
            case BYTE: {
                return TreeUtils.createLiteral(TypeTag.BYTE, (byte)0, typeMirror, processingEnv);
            }
            case CHAR: {
                return TreeUtils.createLiteral(TypeTag.CHAR, Character.valueOf('\u0000'), typeMirror, processingEnv);
            }
            case SHORT: {
                return TreeUtils.createLiteral(TypeTag.SHORT, (short)0, typeMirror, processingEnv);
            }
            case LONG: {
                return TreeUtils.createLiteral(TypeTag.LONG, 0L, typeMirror, processingEnv);
            }
            case FLOAT: {
                return TreeUtils.createLiteral(TypeTag.FLOAT, Float.valueOf(0.0f), typeMirror, processingEnv);
            }
            case INT: {
                return TreeUtils.createLiteral(TypeTag.INT, 0, typeMirror, processingEnv);
            }
            case DOUBLE: {
                return TreeUtils.createLiteral(TypeTag.DOUBLE, 0.0, typeMirror, processingEnv);
            }
            case BOOLEAN: {
                return TreeUtils.createLiteral(TypeTag.BOOLEAN, false, typeMirror, processingEnv);
            }
        }
        return TreeUtils.createLiteral(TypeTag.BOT, null, processingEnv.getTypeUtils().getNullType(), processingEnv);
    }

    public static LiteralTree createLiteral(TypeTag typeTag, @Nullable Object value, TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        Context context = ((JavacProcessingEnvironment)processingEnv).getContext();
        TreeMaker maker = TreeMaker.instance(context);
        JCTree.JCLiteral result = maker.Literal(typeTag, value);
        result.type = (Type)typeMirror;
        return result;
    }

    public static boolean isNullExpression(Tree t2) {
        block5: while (true) {
            switch (t2.getKind()) {
                case PARENTHESIZED: {
                    t2 = ((ParenthesizedTree)t2).getExpression();
                    continue block5;
                }
                case TYPE_CAST: {
                    t2 = ((TypeCastTree)t2).getExpression();
                    continue block5;
                }
                case NULL_LITERAL: {
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public static boolean sameTree(ExpressionTree expr1, ExpressionTree expr2) {
        expr1 = TreeUtils.withoutParens(expr1);
        expr2 = TreeUtils.withoutParens(expr2);
        return expr1.getKind() == expr2.getKind() && expr1.toString().equals(expr2.toString());
    }

    public static List<? extends ExpressionTree> caseTreeGetExpressions(CaseTree caseTree) {
        if (SystemUtil.jreVersion >= 12) {
            try {
                @NonNull List result = (List)caseGetExpressions.invoke((Object)caseTree, new Object[0]);
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new BugInCF("cannot find and/or call method CaseTree.getExpressions()", e);
            }
        }
        ExpressionTree expression = caseTree.getExpression();
        if (expression == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(expression);
    }

    public static @Nullable Tree caseTreeGetBody(CaseTree caseTree) {
        if (caseGetBody == null) {
            throw new BugInCF("Don't call CaseTree.getBody on JDK <12");
        }
        try {
            return (Tree)caseGetBody.invoke((Object)caseTree, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new BugInCF("Problem calling CaseTree.getBody", e);
        }
    }

    public static VariableTree bindingPatternTreeGetVariable(Tree bindingPatternTree) {
        if (bindingPatternGetVariable == null) {
            throw new BugInCF("Don't call BindingPatternTree.getVariable on JDK <12.");
        }
        try {
            VariableTree variableTree = (VariableTree)bindingPatternGetVariable.invoke((Object)bindingPatternTree, new Object[0]);
            if (variableTree != null) {
                return variableTree;
            }
            throw new BugInCF("TreeUtils.bindingPatternTreeGetVariable: variable is null for tree: %s", bindingPatternTree);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BugInCF("TreeUtils.bindingPatternTreeGetVariable: reflection failed for tree: %s", bindingPatternTree, e);
        }
    }

    public static @Nullable Tree instanceOfGetPattern(InstanceOfTree instanceOfTree) {
        if (instanceOfGetPattern == null) {
            return null;
        }
        try {
            return (Tree)instanceOfGetPattern.invoke((Object)instanceOfTree, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BugInCF("TreeUtils.instanceOfGetPattern: reflection failed for tree: %s", instanceOfTree, e);
        }
    }

    public static ExpressionTree switchExpressionTreeGetExpression(Tree switchExpressionTree) {
        if (switchExpressionGetExpression == null) {
            throw new BugInCF("Don't call SwitchExpressionTree.getExpression on JDK <12");
        }
        try {
            ExpressionTree expressionTree = (ExpressionTree)switchExpressionGetExpression.invoke((Object)switchExpressionTree, new Object[0]);
            if (expressionTree != null) {
                return expressionTree;
            }
            throw new BugInCF("TreeUtils.switchExpressionTreeGetExpression: expression is null for tree: %s", switchExpressionTree);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BugInCF("TreeUtils.switchExpressionTreeGetExpression: reflection failed for tree: %s", switchExpressionTree, e);
        }
    }

    public static List<? extends CaseTree> switchExpressionTreeGetCases(Tree switchExpressionTree) {
        if (switchExpressionGetCases == null) {
            throw new BugInCF("Don't call SwitchExpressionTree.getCases on JDK <12");
        }
        try {
            List cases = (List)switchExpressionGetCases.invoke((Object)switchExpressionTree, new Object[0]);
            if (cases != null) {
                return cases;
            }
            throw new BugInCF("TreeUtils.switchExpressionTreeGetCases: cases is null for tree: %s", switchExpressionTree);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BugInCF("TreeUtils.switchExpressionTreeGetCases: reflection failed for tree: %s", switchExpressionTree, e);
        }
    }

    public static ExpressionTree yieldTreeGetValue(Tree yieldTree) {
        if (yieldGetValue == null) {
            throw new BugInCF("Don't call YieldTree.getValue on JDK <12");
        }
        try {
            ExpressionTree expressionTree = (ExpressionTree)yieldGetValue.invoke((Object)yieldTree, new Object[0]);
            if (expressionTree != null) {
                return expressionTree;
            }
            throw new BugInCF("TreeUtils.yieldTreeGetValue: expression is null for tree: %s", yieldTree);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BugInCF("TreeUtils.yieldTreeGetValue: reflection failed for tree: %s", yieldTree, e);
        }
    }

    public static boolean isVarArgs(Tree tree) {
        switch (tree.getKind()) {
            case METHOD_INVOCATION: {
                return TreeUtils.isVarArgs((MethodInvocationTree)tree);
            }
            case NEW_CLASS: {
                return TreeUtils.isVarArgs((NewClassTree)tree);
            }
        }
        throw new BugInCF("Unexpected kind of tree: " + tree);
    }

    public static boolean isVarArgs(MethodInvocationTree invok) {
        return TreeUtils.isVarArgs(TreeUtils.elementFromUse(invok), invok.getArguments());
    }

    public static boolean isVarArgs(NewClassTree newClassTree) {
        return TreeUtils.isVarArgs(TreeUtils.elementFromUse(newClassTree), newClassTree.getArguments());
    }

    private static boolean isVarArgs(ExecutableElement method, List<? extends ExpressionTree> args) {
        if (!method.isVarArgs()) {
            return false;
        }
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() != args.size()) {
            return true;
        }
        TypeMirror lastArgType = TreeUtils.typeOf(args.get(args.size() - 1));
        if (lastArgType.getKind() == TypeKind.NULL) {
            return false;
        }
        if (lastArgType.getKind() != TypeKind.ARRAY) {
            return true;
        }
        TypeMirror varargsParamType = parameters.get(parameters.size() - 1).asType();
        return TypesUtils.getArrayDepth(varargsParamType) != TypesUtils.getArrayDepth(lastArgType);
    }

    public static Tree.Kind getKindRecordAsClass(Tree tree) {
        Tree.Kind kind = tree.getKind();
        if (kind.name().equals("RECORD")) {
            kind = Tree.Kind.CLASS;
        }
        return kind;
    }

    static {
        if (SystemUtil.jreVersion >= 12) {
            try {
                caseGetExpressions = CaseTree.class.getDeclaredMethod("getExpressions", new Class[0]);
                caseGetBody = CaseTree.class.getDeclaredMethod("getBody", new Class[0]);
                Class<?> bindingPatternClass = Class.forName("com.sun.source.tree.BindingPatternTree");
                bindingPatternGetVariable = bindingPatternClass.getMethod("getVariable", new Class[0]);
                instanceOfGetPattern = InstanceOfTree.class.getMethod("getPattern", new Class[0]);
                Class<?> switchExpressionClass = Class.forName("com.sun.source.tree.SwitchExpressionTree");
                switchExpressionGetExpression = switchExpressionClass.getMethod("getExpression", new Class[0]);
                switchExpressionGetCases = switchExpressionClass.getMethod("getCases", new Class[0]);
                Class<?> yieldTreeClass = Class.forName("com.sun.source.tree.YieldTree");
                yieldGetValue = yieldTreeClass.getMethod("getValue", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new BugInCF("JDK 12+ reflection problem", e);
            }
        }
        classTreeKinds = EnumSet.noneOf(Tree.Kind.class);
        for (Tree.Kind kind : Tree.Kind.values()) {
            if (kind.asInterface() != ClassTree.class) continue;
            classTreeKinds.add(kind);
        }
        declarationTreeKinds = EnumSet.noneOf(Tree.Kind.class);
        declarationTreeKinds.addAll(classTreeKinds);
        declarationTreeKinds.add(Tree.Kind.METHOD);
        declarationTreeKinds.add(Tree.Kind.VARIABLE);
        typeTreeKinds = EnumSet.of(Tree.Kind.PRIMITIVE_TYPE, new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE, Tree.Kind.TYPE_PARAMETER, Tree.Kind.ARRAY_TYPE, Tree.Kind.UNBOUNDED_WILDCARD, Tree.Kind.EXTENDS_WILDCARD, Tree.Kind.SUPER_WILDCARD, Tree.Kind.ANNOTATED_TYPE});
    }
}

