/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.block;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.analysis.Store;
import org.checkerframework.nullaway.dataflow.cfg.block.Block;
import org.checkerframework.nullaway.dataflow.cfg.block.BlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.javacutil.BugInCF;

public class ConditionalBlockImpl
extends BlockImpl
implements ConditionalBlock {
    protected @Nullable BlockImpl thenSuccessor;
    protected @Nullable BlockImpl elseSuccessor;
    protected Store.FlowRule thenFlowRule = Store.FlowRule.THEN_TO_BOTH;
    protected Store.FlowRule elseFlowRule = Store.FlowRule.ELSE_TO_BOTH;

    public ConditionalBlockImpl() {
        super(Block.BlockType.CONDITIONAL_BLOCK);
    }

    public void setThenSuccessor(BlockImpl b) {
        this.thenSuccessor = b;
        b.addPredecessor(this);
    }

    public void setElseSuccessor(BlockImpl b) {
        this.elseSuccessor = b;
        b.addPredecessor(this);
    }

    @Override
    public Block getThenSuccessor() {
        if (this.thenSuccessor == null) {
            throw new BugInCF("Requested thenSuccessor for conditional block before initialization");
        }
        return this.thenSuccessor;
    }

    @Override
    public Block getElseSuccessor() {
        if (this.elseSuccessor == null) {
            throw new BugInCF("Requested elseSuccessor for conditional block before initialization");
        }
        return this.elseSuccessor;
    }

    @Override
    public Set<Block> getSuccessors() {
        LinkedHashSet<Block> result = new LinkedHashSet<Block>(2);
        result.add(this.getThenSuccessor());
        result.add(this.getElseSuccessor());
        return result;
    }

    @Override
    public Store.FlowRule getThenFlowRule() {
        return this.thenFlowRule;
    }

    @Override
    public Store.FlowRule getElseFlowRule() {
        return this.elseFlowRule;
    }

    @Override
    public void setThenFlowRule(Store.FlowRule rule) {
        this.thenFlowRule = rule;
    }

    @Override
    public void setElseFlowRule(Store.FlowRule rule) {
        this.elseFlowRule = rule;
    }

    @Override
    public List<Node> getNodes() {
        return Collections.emptyList();
    }

    @Override
    public @Nullable Node getLastNode() {
        return null;
    }

    public String toString() {
        return "ConditionalBlock()";
    }
}

