/*
 * Copyright (c) 1997, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.javadoc.internal.doclets.toolkit;

import org.checkerframework.dataflow.qual.Pure;
import java.io.*;
import java.util.*;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import com.sun.source.util.DocTreePath;
import com.sun.tools.javac.util.DefinedBy;
import com.sun.tools.javac.util.DefinedBy.Api;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.doclet.StandardDoclet;
import jdk.javadoc.doclet.Taglet;
import jdk.javadoc.internal.doclets.formats.html.HtmlDoclet;
import jdk.javadoc.internal.doclets.toolkit.builders.BuilderFactory;
import jdk.javadoc.internal.doclets.toolkit.taglets.TagletManager;
import jdk.javadoc.internal.doclets.toolkit.util.DocFile;
import jdk.javadoc.internal.doclets.toolkit.util.DocFileFactory;
import jdk.javadoc.internal.doclets.toolkit.util.DocFileIOException;
import jdk.javadoc.internal.doclets.toolkit.util.DocletConstants;
import jdk.javadoc.internal.doclets.toolkit.util.Extern;
import jdk.javadoc.internal.doclets.toolkit.util.Group;
import jdk.javadoc.internal.doclets.toolkit.util.MetaKeywords;
import jdk.javadoc.internal.doclets.toolkit.util.SimpleDocletException;
import jdk.javadoc.internal.doclets.toolkit.util.TypeElementCatalog;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;
import jdk.javadoc.internal.doclets.toolkit.util.Utils.Pair;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberCache;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberTable;
import static javax.tools.Diagnostic.Kind.*;

public abstract class BaseConfiguration {

    public final Doclet doclet;

    protected BuilderFactory builderFactory;

    public TagletManager tagletManager;

    public String builderXMLPath;

    public static final String DEFAULT_BUILDER_XML;

    public String tagletpath;

    public boolean serialwarn;

    public int sourcetab;

    public String tabSpaces;

    public boolean linksource;

    public boolean nosince;

    public boolean copydocfilesubdirs;

    public boolean backwardCompatibility;

    public boolean keywords;

    public final MetaKeywords metakeywords;

    protected Set<String> excludedDocFileDirs;

    protected Set<String> excludedQualifiers;

    public DocletEnvironment docEnv;

    public Utils utils;

    public WorkArounds workArounds;

    public String destDirName;

    public String docFileDestDirName;

    public String docencoding;

    public boolean nocomment;

    public String encoding;

    public boolean showauthor;

    public boolean javafx;

    public boolean showversion;

    public String sourcepath;

    public boolean showModules;

    public boolean nodeprecated;

    public TypeElementCatalog typeElementCatalog;

    public boolean notimestamp;

    public final Group group;

    public final Extern extern;

    public Reporter reporter;

    public Locale locale;

    public boolean quiet;

    public boolean summarizeOverriddenMethods;

    public boolean dumpOnError;

    public abstract Messages getMessages();

    public abstract Resources getResources();

    public abstract String getDocletVersion();

    public abstract boolean finishOptionSettings();

    public CommentUtils cmtUtils;

    public SortedSet<PackageElement> packages;

    public OverviewElement overviewElement;

    public DocFileFactory docFileFactory;

    public SortedMap<ModuleElement, Set<PackageElement>> modulePackages;

    public SortedSet<ModuleElement> modules;

    protected static final String sharedResourceBundleName;

    public boolean disableJavaFxStrictChecks;

    public boolean showTaglets;

    public PropertyUtils propertyUtils;

    public BaseConfiguration(Doclet doclet) {
    }

    protected void initConfiguration(DocletEnvironment docEnv);

    public BuilderFactory getBuilderFactory();

    public Reporter getReporter();

    public Set<ModuleElement> getSpecifiedModuleElements();

    public Set<PackageElement> getSpecifiedPackageElements();

    public Set<TypeElement> getSpecifiedTypeElements();

    public Set<ModuleElement> getIncludedModuleElements();

    public Set<PackageElement> getIncludedPackageElements();

    public Set<TypeElement> getIncludedTypeElements();

    public Set<Doclet.Option> getSupportedOptions();

    protected boolean finishOptionSettings0() throws DocletException;

    public boolean setOptions() throws DocletException;

    public static String addTrailingFileSep(String path);

    public boolean generalValidOptions();

    public boolean shouldExcludeDocFileDir(String docfilesubdir);

    public boolean shouldExcludeQualifier(String qualifier);

    public String getClassName(TypeElement te);

    public abstract String getText(String key);

    public abstract String getText(String key, String... args);

    public abstract Content getContent(String key);

    public abstract Content getContent(String key, Object o);

    public abstract Content getContent(String key, Object o1, Object o2);

    public abstract Content getContent(String key, Object o0, Object o1, Object o2);

    @Pure
    public boolean isGeneratedDoc(TypeElement te);

    public abstract WriterFactory getWriterFactory();

    public InputStream getBuilderXML() throws DocFileIOException;

    public abstract Locale getLocale();

    public abstract JavaFileObject getOverviewPath();

    public abstract JavaFileManager getFileManager();

    public abstract boolean showMessage(DocTreePath path, String key);

    public abstract boolean showMessage(Element e, String key);

    public static abstract class Option implements Doclet.Option, Comparable<Option> {

        protected Option(Resources resources, String name, int argCount) {
        }

        protected Option(Resources resources, String keyBase, String name, int argCount) {
        }

        protected Option(Resources resources, String name) {
        }

        @Override
        public String getDescription();

        @Override
        public Option.Kind getKind();

        @Override
        public List<String> getNames();

        @Override
        public String getParameters();

        @Override
        public String toString();

        @Override
        public int getArgumentCount();

        public boolean matches(String option);

        @Override
        public int compareTo(Option that);
    }

    public abstract class XOption extends Option {

        public XOption(Resources resources, String prefix, String name, int argCount) {
        }

        public XOption(Resources resources, String name, int argCount) {
        }

        public XOption(Resources resources, String name) {
        }

        @Override
        public Option.Kind getKind();
    }

    public abstract class Hidden extends Option {

        public Hidden(Resources resources, String name, int argCount) {
        }

        public Hidden(Resources resources, String name) {
        }

        @Override
        public Option.Kind getKind();
    }

    static private class Splitter {
    }

    @Pure
    public boolean isAllowScriptInComments();

    public synchronized VisibleMemberTable getVisibleMemberTable(TypeElement te);
}
