/*
 * Copyright (c) 2000, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.lang;

import org.checkerframework.checker.interning.qual.UsesObjectEquals;
import org.checkerframework.framework.qual.AnnotatedFor;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import jdk.internal.HotSpotIntrinsicCandidate;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import static java.lang.String.LATIN1;
import static java.lang.String.UTF16;
import static java.lang.String.COMPACT_STRINGS;
import static java.lang.Character.isSurrogate;
import static java.lang.Character.highSurrogate;
import static java.lang.Character.lowSurrogate;
import static java.lang.Character.isSupplementaryCodePoint;
import static java.lang.StringUTF16.putChar;

@AnnotatedFor({ "index", "interning" })
@UsesObjectEquals
class StringCoding {

    static class Result {

        Result with();

        Result with(char[] val, int off, int len);

        Result with(byte[] val, byte coder);
    }

    @HotSpotIntrinsicCandidate
    public static boolean hasNegatives(byte[] ba, int off, int len);

    static class StringDecoder {

        protected final Result result;

        String charsetName();

        final String requestedCharsetName();

        Result decode(byte[] ba, int off, int len);
    }

    static Result decode(String charsetName, byte[] ba, int off, int len) throws UnsupportedEncodingException;

    static Result decode(Charset cs, byte[] ba, int off, int len);

    static Result decode(byte[] ba, int off, int len);

    private static class StringEncoder {

        String charsetName();

        final String requestedCharsetName();

        byte[] encode(byte coder, byte[] val);
    }

    static byte[] encode(String charsetName, byte coder, byte[] val) throws UnsupportedEncodingException;

    static byte[] encode(Charset cs, byte coder, byte[] val);

    static byte[] encode(byte coder, byte[] val);

    static String newStringUTF8NoRepl(byte[] src, int off, int len);

    static byte[] getBytesUTF8NoRepl(String s);

    static String newStringNoRepl(byte[] src, Charset cs) throws CharacterCodingException;

    static String newStringNoRepl1(byte[] src, Charset cs);

    static byte[] getBytesNoRepl(String s, Charset cs) throws CharacterCodingException;

    static byte[] getBytesNoRepl1(String s, Charset cs);
}
