/*
 * Copyright (c) 1997, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.tools.javadoc.main;

import org.checkerframework.dataflow.qual.Pure;
import java.lang.reflect.Modifier;
import java.text.CollationKey;
import com.sun.javadoc.*;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol.*;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;

@Deprecated()
@SuppressWarnings("removal")
public abstract class ExecutableMemberDocImpl extends MemberDocImpl implements ExecutableMemberDoc {

    protected final MethodSymbol sym;

    public ExecutableMemberDocImpl(DocEnv env, MethodSymbol sym, TreePath treePath) {
    }

    public ExecutableMemberDocImpl(DocEnv env, MethodSymbol sym) {
    }

    protected long getFlags();

    protected ClassSymbol getContainingClass();

    @Pure
    public boolean isNative();

    @Pure
    public boolean isSynchronized();

    @Pure
    public boolean isVarArgs();

    @Pure
    public boolean isSynthetic();

    @Pure
    public boolean isIncluded();

    public ThrowsTag[] throwsTags();

    public ParamTag[] paramTags();

    public ParamTag[] typeParamTags();

    public ClassDoc[] thrownExceptions();

    public com.sun.javadoc.Type[] thrownExceptionTypes();

    public Parameter[] parameters();

    public com.sun.javadoc.Type receiverType();

    public TypeVariable[] typeParameters();

    public String signature();

    public String flatSignature();

    protected String typeParametersString();

    @Override
    CollationKey generateKey();

    @Override
    public SourcePosition position();
}
