/*
 * Copyright (c) 2012, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.graalvm.compiler.core.common.type;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import static org.graalvm.compiler.core.common.calc.FloatConvert.D2F;
import static org.graalvm.compiler.core.common.calc.FloatConvert.D2I;
import static org.graalvm.compiler.core.common.calc.FloatConvert.D2L;
import static org.graalvm.compiler.core.common.calc.FloatConvert.F2D;
import static org.graalvm.compiler.core.common.calc.FloatConvert.F2I;
import static org.graalvm.compiler.core.common.calc.FloatConvert.F2L;
import java.nio.ByteBuffer;
import java.util.function.DoubleBinaryOperator;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable.BinaryOp;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable.FloatConvertOp;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable.UnaryOp;
import org.graalvm.compiler.debug.GraalError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SerializableConstant;

public class FloatStamp extends PrimitiveStamp {

    protected FloatStamp(int bits) {
    }

    public FloatStamp(int bits, double lowerBound, double upperBound, boolean nonNaN) {
    }

    @Override
    public Stamp unrestricted();

    @Override
    public Stamp empty();

    @Override
    public Stamp constant(Constant c, MetaAccessProvider meta);

    @Override
    public SerializableConstant deserialize(ByteBuffer buffer);

    @Override
    public boolean hasValues();

    @Override
    public JavaKind getStackKind();

    @Override
    public LIRKind getLIRKind(LIRKindTool tool);

    @Override
    public ResolvedJavaType javaType(MetaAccessProvider metaAccess);

    public double lowerBound();

    public double upperBound();

    public boolean isNonNaN();

    public boolean isNaN();

    @Override
    public boolean isUnrestricted();

    public boolean contains(double value);

    @Override
    public String toString();

    @Override
    public Stamp meet(Stamp otherStamp);

    @Override
    public Stamp join(Stamp otherStamp);

    @Override
    public int hashCode();

    @Override
    public boolean isCompatible(Stamp stamp);

    @Override
    public boolean isCompatible(Constant constant);

    @Override
    @Pure
    @EnsuresNonNullIf(expression = "#1", result = true)
    public boolean equals(@Nullable Object obj);

    @Override
    public JavaConstant asConstant();

    public static final ArithmeticOpTable OPS;
}
