/*
 * Copyright (c) 2011, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.graalvm.compiler.virtual.phases.ea;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Arrays;
import java.util.List;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.virtual.EscapeObjectState;
import org.graalvm.compiler.nodes.virtual.LockState;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.virtual.nodes.MaterializedObjectState;
import org.graalvm.compiler.virtual.nodes.VirtualObjectState;
import jdk.vm.ci.meta.JavaConstant;

public class ObjectState {

    public static final CounterKey CREATE_ESCAPED_OBJECT_STATE;

    public static final CounterKey GET_ESCAPED_OBJECT_STATE;

    public ObjectState(ValueNode[] entries, List<MonitorIdNode> locks, boolean ensureVirtualized) {
    }

    public ObjectState(ValueNode[] entries, LockState locks, boolean ensureVirtualized) {
    }

    public ObjectState(ValueNode materializedValue, LockState locks, boolean ensureVirtualized) {
    }

    public ObjectState cloneState();

    public static boolean checkIllegalValues(ValueNode[] values);

    public static boolean checkIllegalValue(ValueNode[] values, int v);

    public EscapeObjectState createEscapeObjectState(DebugContext debug, VirtualObjectNode virtual);

    public boolean isVirtual();

    public ValueNode[] getEntries();

    public ValueNode getEntry(int index);

    public ValueNode getMaterializedValue();

    public void setEntry(int index, ValueNode value);

    public void escape(ValueNode materialized);

    public void updateMaterializedValue(ValueNode value);

    public void addLock(MonitorIdNode monitorId);

    public MonitorIdNode removeLock();

    public LockState getLocks();

    public boolean hasLocks();

    public boolean locksEqual(ObjectState other);

    public void setEnsureVirtualized(boolean ensureVirtualized);

    public boolean getEnsureVirtualized();

    @Override
    public String toString();

    @Override
    public int hashCode();

    @Override
    @Pure
    @EnsuresNonNullIf(expression = "#1", result = true)
    public boolean equals(@Nullable Object obj);

    public ObjectState share();
}
