/*
 * Copyright (c) 1998, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.javadoc;

import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.AnnotatedFor;
import java.text.BreakIterator;
import java.util.Locale;

@AnnotatedFor({ "lock" })
@Deprecated()
@SuppressWarnings("removal")
public interface Doc extends Comparable<Object> {

    String commentText();

    Tag[] tags();

    Tag[] tags(String tagname);

    SeeTag[] seeTags();

    Tag[] inlineTags();

    Tag[] firstSentenceTags();

    String getRawCommentText();

    void setRawCommentText(String rawDocumentation);

    String name();

    @Pure
    int compareTo(Object obj);

    @Pure
    boolean isField();

    @Pure
    boolean isEnumConstant();

    @Pure
    boolean isConstructor();

    @Pure
    boolean isMethod();

    @Pure
    boolean isAnnotationTypeElement();

    @Pure
    boolean isInterface();

    @Pure
    boolean isException();

    @Pure
    boolean isError();

    @Pure
    boolean isEnum();

    @Pure
    boolean isAnnotationType();

    @Pure
    boolean isOrdinaryClass();

    @Pure
    boolean isClass();

    @Pure
    boolean isIncluded();

    @Nullable
    SourcePosition position();
}
