/*
 * Copyright (c) 2009, 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.graalvm.compiler.code;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import static java.util.Collections.emptyList;
import static java.util.Collections.unmodifiableList;
import static jdk.vm.ci.meta.MetaUtil.identityHashCodeString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.internal.vm.compiler.collections.EconomicSet;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.graph.NodeSourcePosition;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.ExceptionHandler;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.code.site.Mark;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.code.site.Site;
import jdk.vm.ci.meta.Assumptions.Assumption;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class CompilationResult {

    public abstract static class CodeAnnotation {

        public final int position;

        public CodeAnnotation(int position) {
        }

        @Override
        public final int hashCode();

        @Override
        public String toString();

        @Override
        public abstract boolean equals(Object obj);
    }

    public static final class CodeComment extends CodeAnnotation {

        public final String value;

        public CodeComment(int position, String comment) {
        }

        @Override
        public boolean equals(Object obj);

        @Override
        public String toString();
    }

    public static final class JumpTable extends CodeAnnotation {

        public final int low;

        public final int high;

        public final int entrySize;

        public JumpTable(int position, int low, int high, int entrySize) {
        }

        @Override
        public boolean equals(Object obj);

        @Override
        public String toString();
    }

    public CompilationResult(CompilationIdentifier compilationId) {
    }

    public CompilationResult(CompilationIdentifier compilationId, String name) {
    }

    public CompilationResult(CompilationIdentifier compilationId, boolean isImmutablePIC) {
    }

    public CompilationResult(CompilationIdentifier compilationId, String name, boolean isImmutablePIC) {
    }

    public CompilationResult(String name) {
    }

    @Override
    public int hashCode();

    @Override
    public String toString();

    @Override
    @Pure
    @EnsuresNonNullIf(expression = "#1", result = true)
    public boolean equals(@Nullable Object obj);

    public int getEntryBCI();

    public void setEntryBCI(int entryBCI);

    public void setAssumptions(Assumption[] assumptions);

    public Assumption[] getAssumptions();

    public void setMethods(ResolvedJavaMethod rootMethod, Collection<ResolvedJavaMethod> inlinedMethods);

    public ResolvedJavaMethod[] getMethods();

    public void setFields(EconomicSet<ResolvedJavaField> accessedFields);

    public ResolvedJavaField[] getFields();

    public void setBytecodeSize(int bytecodeSize);

    public int getBytecodeSize();

    public DataSection getDataSection();

    public int getTotalFrameSize();

    public void setTotalFrameSize(int size);

    public int getMaxInterpreterFrameSize();

    public void setMaxInterpreterFrameSize(int maxInterpreterFrameSize);

    public boolean isImmutablePIC();

    public void setTargetCode(byte[] code, int size);

    public void recordDataPatch(int codePos, Reference ref);

    public void recordDataPatchWithNote(int codePos, Reference ref, Object note);

    public void recordCall(int codePos, int size, InvokeTarget target, DebugInfo debugInfo, boolean direct);

    public void recordExceptionHandler(int codePos, int handlerPos);

    public void recordInfopoint(int codePos, DebugInfo debugInfo, InfopointReason reason);

    public void addInfopoint(Infopoint infopoint);

    public void recordSourceMapping(int startOffset, int endOffset, NodeSourcePosition sourcePosition);

    public Mark recordMark(int codePos, Object markId);

    public StackSlot getCustomStackArea();

    public void setCustomStackAreaOffset(StackSlot slot);

    public byte[] getTargetCode();

    public int getTargetCodeSize();

    public List<CodeAnnotation> getAnnotations();

    public void addAnnotation(CodeAnnotation annotation);

    public List<Infopoint> getInfopoints();

    public List<DataPatch> getDataPatches();

    public List<ExceptionHandler> getExceptionHandlers();

    public List<Mark> getMarks();

    public List<SourceMapping> getSourceMappings();

    public String getName();

    public CompilationIdentifier getCompilationId();

    public void setHasUnsafeAccess(boolean hasUnsafeAccess);

    public boolean hasUnsafeAccess();

    public void resetForEmittingCode();

    public void close();
}
