/*
 * Copyright (c) 2000, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.tools.javadoc.main;

import org.checkerframework.checker.signature.qual.ClassGetName;
import java.lang.reflect.Modifier;
import java.util.*;
import javax.tools.JavaFileManager;
import com.sun.javadoc.*;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.tools.doclint.DocLint;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.*;
import com.sun.tools.javac.code.Symbol.*;
import com.sun.tools.javac.code.Symbol.ClassSymbol;
import com.sun.tools.javac.code.Symbol.CompletionFailure;
import com.sun.tools.javac.code.Symbol.MethodSymbol;
import com.sun.tools.javac.code.Symbol.PackageSymbol;
import com.sun.tools.javac.code.Symbol.VarSymbol;
import com.sun.tools.javac.code.Type.ClassType;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.JCTree.JCClassDecl;
import com.sun.tools.javac.tree.JCTree.JCCompilationUnit;
import com.sun.tools.javac.tree.JCTree.JCPackageDecl;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;

@Deprecated()
@SuppressWarnings("removal")
public class DocEnv {

    protected static final Context.Key<DocEnv> docEnvKey;

    public static DocEnv instance(Context context);

    protected ModifierFilter showAccess;

    protected boolean legacyDoclet;

    protected Source source;

    protected DocEnv(Context context) {
    }

    public void setSilent(boolean silent);

    public ClassDocImpl lookupClass(@ClassGetName String name);

    public ClassDocImpl loadClass(String name);

    public PackageDocImpl lookupPackage(String name);

    ClassSymbol getClassSymbol(String name);

    public void setLocale(String localeName);

    public boolean shouldDocument(VarSymbol sym);

    public boolean shouldDocument(MethodSymbol sym);

    public boolean shouldDocument(ClassSymbol sym);

    protected boolean isVisible(ClassSymbol sym);

    public void printError(String msg);

    public void error(DocImpl doc, String key);

    public void error(SourcePosition pos, String key);

    public void printError(SourcePosition pos, String msg);

    public void error(DocImpl doc, String key, String a1);

    public void error(DocImpl doc, String key, String a1, String a2);

    public void error(DocImpl doc, String key, String a1, String a2, String a3);

    public void printWarning(String msg);

    public void warning(DocImpl doc, String key);

    public void printWarning(SourcePosition pos, String msg);

    public void warning(DocImpl doc, String key, String a1);

    public void warning(DocImpl doc, String key, String a1, String a2);

    public void warning(DocImpl doc, String key, String a1, String a2, String a3);

    public void warning(DocImpl doc, String key, String a1, String a2, String a3, String a4);

    public void printNotice(String msg);

    public void notice(String key);

    public void printNotice(SourcePosition pos, String msg);

    public void notice(String key, String a1);

    public void notice(String key, String a1, String a2);

    public void notice(String key, String a1, String a2, String a3);

    public void exit();

    protected Map<PackageSymbol, PackageDocImpl> packageMap;

    public PackageDocImpl getPackageDoc(PackageSymbol pack);

    void makePackageDoc(PackageSymbol pack, TreePath treePath);

    protected Map<ClassSymbol, ClassDocImpl> classMap;

    public ClassDocImpl getClassDoc(ClassSymbol clazz);

    protected void makeClassDoc(ClassSymbol clazz, TreePath treePath);

    protected static boolean isAnnotationType(ClassSymbol clazz);

    protected static boolean isAnnotationType(JCClassDecl tree);

    protected Map<VarSymbol, FieldDocImpl> fieldMap;

    public FieldDocImpl getFieldDoc(VarSymbol var);

    protected void makeFieldDoc(VarSymbol var, TreePath treePath);

    protected Map<MethodSymbol, ExecutableMemberDocImpl> methodMap;

    protected void makeMethodDoc(MethodSymbol meth, TreePath treePath);

    public MethodDocImpl getMethodDoc(MethodSymbol meth);

    protected void makeConstructorDoc(MethodSymbol meth, TreePath treePath);

    public ConstructorDocImpl getConstructorDoc(MethodSymbol meth);

    protected void makeAnnotationTypeElementDoc(MethodSymbol meth, TreePath treePath);

    public AnnotationTypeElementDocImpl getAnnotationTypeElementDoc(MethodSymbol meth);

    ParameterizedTypeImpl getParameterizedType(ClassType t);

    TreePath getTreePath(JCCompilationUnit tree);

    TreePath getTreePath(JCCompilationUnit toplevel, JCPackageDecl tree);

    TreePath getTreePath(JCCompilationUnit toplevel, JCClassDecl tree);

    TreePath getTreePath(JCCompilationUnit toplevel, JCClassDecl cdecl, JCTree tree);

    public void setEncoding(String encoding);

    public String getEncoding();

    static int translateModifiers(long flags);

    void initDoclint(Collection<String> opts, Collection<String> customTagNames, String htmlVersion);

    JavaScriptScanner initJavaScriptScanner(boolean allowScriptInComments);

    boolean showTagMessages();

    boolean shouldCheck(CompilationUnitTree unit);
}
