/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.io.classfile;

import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.org.objectweb.asmx.AnnotationVisitor;
import org.checkerframework.org.objectweb.asmx.ClassReader;
import org.checkerframework.org.objectweb.asmx.FieldVisitor;
import org.checkerframework.org.objectweb.asmx.Label;
import org.checkerframework.org.objectweb.asmx.MethodVisitor;
import org.checkerframework.org.objectweb.asmx.Type;
import org.checkerframework.org.objectweb.asmx.TypeAnnotationVisitor;
import org.checkerframework.org.objectweb.asmx.commons.EmptyVisitor;
import scenelib.annotations.Annotation;
import scenelib.annotations.AnnotationBuilder;
import scenelib.annotations.AnnotationFactory;
import scenelib.annotations.Annotations;
import scenelib.annotations.ArrayBuilder;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.BoundLocation;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.el.LocalLocation;
import scenelib.annotations.el.RelativeLocation;
import scenelib.annotations.el.TypeIndexLocation;
import scenelib.annotations.field.AnnotationAFT;
import scenelib.annotations.field.AnnotationFieldType;
import scenelib.annotations.field.ArrayAFT;
import scenelib.annotations.field.BasicAFT;
import scenelib.annotations.field.ClassTokenAFT;
import scenelib.annotations.field.EnumAFT;
import scenelib.annotations.field.ScalarAFT;

public class ClassAnnotationSceneReader
extends EmptyVisitor {
    private static final boolean trace = false;
    private static final boolean strict = false;
    private final boolean ignoreBridgeMethods;
    private final AScene scene;
    private AClass aClass;
    private final ClassReader classReader;
    private final Map<String, AnnotationDef> annotationDefinitions = ClassAnnotationSceneReader.initialiseAnnotationDefinitions();
    String dummyDesc = "dummy";

    private static Map<String, AnnotationDef> initialiseAnnotationDefinitions() {
        HashMap<String, AnnotationDef> result = new HashMap<String, AnnotationDef>();
        for (AnnotationDef ad : Annotations.standardDefs) {
            result.put(ad.name, ad);
        }
        return result;
    }

    public ClassAnnotationSceneReader(ClassReader classReader, AScene scene, boolean ignoreBridgeMethods) {
        this.classReader = classReader;
        this.scene = scene;
        this.ignoreBridgeMethods = ignoreBridgeMethods;
    }

    @Override
    public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        this.aClass = this.scene.classes.getVivify(name.replace('/', '.'));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return this.visitTypeAnnotation(descriptor, visible, false);
    }

    @Override
    public TypeAnnotationVisitor visitTypeAnnotation(String descriptor, boolean visible, boolean inCode) {
        return new AnnotationSceneReader(descriptor, visible, this.aClass);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        AField aField = this.aClass.fields.getVivify(name);
        return new FieldAnnotationSceneReader(name, descriptor, signature, value, aField);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.ignoreBridgeMethods && (access & 0x40) != 0) {
            return null;
        }
        AMethod aMethod = this.aClass.methods.getVivify(name + descriptor);
        return new MethodAnnotationSceneReader(name, descriptor, signature, aMethod);
    }

    private static @ClassGetName String classDescToName(String descriptor) {
        return descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
    }

    public static void printClasspath() {
        System.out.println("Classpath:");
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            System.out.println("  " + tokenizer.nextToken());
        }
    }

    private class MethodAnnotationSceneReader
    extends EmptyVisitor
    implements MethodVisitor {
        private final AElement aMethod;

        public MethodAnnotationSceneReader(String name, String descriptor, String signature, AElement aMethod) {
            this.aMethod = aMethod;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            return this.visitTypeAnnotation(descriptor, visible, false);
        }

        @Override
        public TypeAnnotationVisitor visitTypeAnnotation(String descriptor, boolean visible, boolean inCode) {
            return new AnnotationSceneReader(descriptor, visible, this.aMethod);
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            return new AnnotationSceneReader(descriptor, visible, ((AMethod)this.aMethod).parameters.getVivify(parameter));
        }

        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        }
    }

    private class FieldAnnotationSceneReader
    extends EmptyVisitor
    implements FieldVisitor {
        private final AElement aField;

        public FieldAnnotationSceneReader(String name, String descriptor, String signature, Object value, AElement aField) {
            this.aField = aField;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            return new AnnotationSceneReader(descriptor, visible, this.aField);
        }

        @Override
        public TypeAnnotationVisitor visitTypeAnnotation(String descriptor, boolean visible, boolean inCode) {
            return new AnnotationSceneReader(descriptor, visible, this.aField.type);
        }
    }

    private class ArrayAnnotationSceneReader
    extends AnnotationSceneReader {
        private final AnnotationSceneReader parent;
        private ArrayBuilder arrayBuilder;
        private final String arrayName;

        public ArrayAnnotationSceneReader(AnnotationSceneReader parent, String fieldName, AnnotationFieldType eltType) {
            super(ClassAnnotationSceneReader.this.dummyDesc, parent.visible, parent.aElement);
            this.parent = parent;
            this.arrayName = fieldName;
            this.arrayBuilder = null;
        }

        private void prepareForElement(ScalarAFT elementType) {
            assert (elementType != null);
            if (this.arrayBuilder == null) {
                this.arrayBuilder = this.parent.annotationBuilder.beginArrayField(this.arrayName, new ArrayAFT(elementType));
            }
        }

        @Override
        public void visit(String name, Object value) {
            ScalarAFT aft;
            if (value.getClass().equals(Type.class)) {
                aft = ClassTokenAFT.ctaft;
                try {
                    value = Class.forName(((Type)((Object)value)).getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not load Class for Type: " + value, e);
                }
            } else {
                Class<?> vc = value.getClass();
                aft = BasicAFT.forType(vc);
            }
            assert (aft != null);
            this.prepareForElement(aft);
            assert (this.arrayBuilder != null);
            this.arrayBuilder.appendElement(value);
        }

        @Override
        public void visitEnum(String name, String descriptor, String value) {
            this.prepareForElement(new EnumAFT(ClassAnnotationSceneReader.classDescToName(descriptor)));
            assert (this.arrayBuilder != null);
            this.arrayBuilder.appendElement(value);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            throw new AssertionError((Object)"Multidimensional array in annotation!");
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            return new NestedAnnotationSceneReader(this, name, descriptor);
        }

        @Override
        public void visitEnd() {
            if (this.arrayBuilder != null) {
                this.arrayBuilder.finish();
            } else {
                this.parent.annotationBuilder.addEmptyArrayField(this.arrayName);
            }
        }

        @Override
        void supplySubannotation(String fieldName, Annotation annotation) {
            this.prepareForElement(new AnnotationAFT(annotation.def()));
            assert (this.arrayBuilder != null);
            this.arrayBuilder.appendElement(annotation);
        }
    }

    private class NestedAnnotationSceneReader
    extends AnnotationSceneReader {
        private final AnnotationSceneReader parent;
        private final String name;

        public NestedAnnotationSceneReader(AnnotationSceneReader parent, String name, String descriptor) {
            super(descriptor, parent.visible, parent.aElement);
            this.parent = parent;
            this.name = name;
        }

        @Override
        public void visitEnd() {
            Annotation a = super.makeAnnotation();
            this.parent.supplySubannotation(this.name, a);
        }
    }

    private class AnnotationSceneReader
    implements TypeAnnotationVisitor {
        protected AElement aElement;
        protected boolean visible;
        private AnnotationBuilder annotationBuilder;
        private final List<Integer> xTargetTypeArgs;
        private final List<Integer> xIndexArgs;
        private final List<Integer> xLengthArgs;
        private final List<TypeAnnotationPosition.TypePathEntry> xLocationsArgs;
        private final List<Integer> xLocationLengthArgs;
        private final List<Integer> xOffsetArgs;
        private final List<Integer> xStartPcArgs;
        private final List<Integer> xParamIndexArgs;
        private final List<Integer> xBoundIndexArgs;
        private final List<Integer> xExceptionIndexArgs;
        private final List<Integer> xTypeIndexArgs;

        private AnnotationDef getAnnotationDef(String jvmlClassName) {
            Class<?> annoClass;
            String annoTypeName = ClassAnnotationSceneReader.classDescToName(jvmlClassName);
            try {
                annoClass = Class.forName(annoTypeName);
            }
            catch (ClassNotFoundException e) {
                if (annoTypeName.contains("+")) {
                    return Annotations.createValueAnnotationDef(annoTypeName, Annotations.noAnnotations, BasicAFT.forType(Integer.TYPE));
                }
                System.out.printf("Could not find class: %s%n", e.getMessage());
                ClassAnnotationSceneReader.printClasspath();
                throw new Error(e);
            }
            AnnotationDef ad = AnnotationDef.fromClass(annoClass, ClassAnnotationSceneReader.this.annotationDefinitions);
            return ad;
        }

        public AnnotationSceneReader(String descriptor, boolean visible, AElement aElement) {
            this.visible = visible;
            this.aElement = aElement;
            if (descriptor != ClassAnnotationSceneReader.this.dummyDesc) {
                AnnotationDef ad = this.getAnnotationDef(descriptor);
                AnnotationBuilder ab = AnnotationFactory.saf.beginAnnotation(ad);
                if (ab == null) {
                    throw new IllegalArgumentException("bad description: " + descriptor);
                }
                this.annotationBuilder = ab;
            }
            this.xTargetTypeArgs = new ArrayList<Integer>(1);
            this.xIndexArgs = new ArrayList<Integer>(1);
            this.xLengthArgs = new ArrayList<Integer>(1);
            this.xLocationLengthArgs = new ArrayList<Integer>(1);
            this.xOffsetArgs = new ArrayList<Integer>(1);
            this.xStartPcArgs = new ArrayList<Integer>(1);
            this.xLocationsArgs = new ArrayList<TypeAnnotationPosition.TypePathEntry>();
            this.xParamIndexArgs = new ArrayList<Integer>(1);
            this.xBoundIndexArgs = new ArrayList<Integer>(1);
            this.xExceptionIndexArgs = new ArrayList<Integer>(1);
            this.xTypeIndexArgs = new ArrayList<Integer>(1);
        }

        @Override
        public void visit(String name, Object value) {
            Class<Object> c = value.getClass();
            if (c.equals(Boolean.class)) {
                c = Boolean.TYPE;
            } else if (c.equals(Byte.class)) {
                c = Byte.TYPE;
            } else if (c.equals(Character.class)) {
                c = Character.TYPE;
            } else if (c.equals(Short.class)) {
                c = Short.TYPE;
            } else if (c.equals(Integer.class)) {
                c = Integer.TYPE;
            } else if (c.equals(Long.class)) {
                c = Long.TYPE;
            } else if (c.equals(Float.class)) {
                c = Float.TYPE;
            } else if (c.equals(Double.class)) {
                c = Double.TYPE;
            } else {
                if (c.equals(Type.class)) {
                    try {
                        this.annotationBuilder.addScalarField(name, ClassTokenAFT.ctaft, Class.forName(((Type)value).getClassName()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Could not load Class for Type: " + value, e);
                    }
                    return;
                }
                if (!c.equals(String.class)) {
                    c = c.getComponentType();
                    ArrayBuilder arrayBuilder = this.annotationBuilder.beginArrayField(name, new ArrayAFT(BasicAFT.forType(c)));
                    for (Object o : this.asList(value)) {
                        arrayBuilder.appendElement(o);
                    }
                    arrayBuilder.finish();
                    return;
                }
            }
            this.annotationBuilder.addScalarField(name, BasicAFT.forType(c), value);
        }

        private List<Object> asList(Object hiddenArray) {
            ArrayList<Object> objects = new ArrayList<Object>();
            Class<?> c = hiddenArray.getClass().getComponentType();
            if (c.equals(Boolean.TYPE)) {
                for (boolean o : (boolean[])hiddenArray) {
                    objects.add(o);
                }
            } else if (c.equals(Byte.TYPE)) {
                for (byte o : (byte[])hiddenArray) {
                    objects.add(o);
                }
            } else if (c.equals(Character.TYPE)) {
                for (char o : (char[])hiddenArray) {
                    objects.add(Character.valueOf(o));
                }
            } else if (c.equals(Short.TYPE)) {
                for (short o : (short[])hiddenArray) {
                    objects.add(o);
                }
            } else if (c.equals(Integer.TYPE)) {
                for (int o : (int[])hiddenArray) {
                    objects.add(o);
                }
            } else if (c.equals(Long.TYPE)) {
                for (long o : (long[])hiddenArray) {
                    objects.add(o);
                }
            } else if (c.equals(Float.TYPE)) {
                for (float o : (float[])hiddenArray) {
                    objects.add(Float.valueOf(o));
                }
            } else if (c.equals(Double.TYPE)) {
                for (double o : (double[])hiddenArray) {
                    objects.add(o);
                }
            } else {
                throw new RuntimeException("Array has unknown type: " + hiddenArray);
            }
            return objects;
        }

        @Override
        public void visitEnum(String name, String descriptor, String value) {
            this.annotationBuilder.addScalarField(name, new EnumAFT(descriptor), value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            return new NestedAnnotationSceneReader(this, name, descriptor);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            ArrayAFT aaft = (ArrayAFT)this.annotationBuilder.fieldTypes().get(name);
            ScalarAFT aft = aaft.elementType;
            return new ArrayAnnotationSceneReader(this, name, aft);
        }

        @Override
        public void visitXTargetType(int target_type) {
            this.xTargetTypeArgs.add(target_type);
        }

        @Override
        public void visitXIndex(int index) {
            this.xIndexArgs.add(index);
        }

        @Override
        public void visitXLength(int length) {
            this.xLengthArgs.add(length);
        }

        @Override
        public void visitXLocation(TypeAnnotationPosition.TypePathEntry location) {
            this.xLocationsArgs.add(location);
        }

        @Override
        public void visitXLocationLength(int location_length) {
            this.xLocationLengthArgs.add(location_length);
        }

        @Override
        public void visitXOffset(int offset) {
            this.xOffsetArgs.add(offset);
        }

        @Override
        public void visitXNumEntries(int num_entries) {
        }

        @Override
        public void visitXStartPc(int start_pc) {
            this.xStartPcArgs.add(start_pc);
        }

        @Override
        public void visitXParamIndex(int param_index) {
            this.xParamIndexArgs.add(param_index);
        }

        @Override
        public void visitXBoundIndex(int bound_index) {
            this.xBoundIndexArgs.add(bound_index);
        }

        @Override
        public void visitXTypeIndex(int type_index) {
            this.xTypeIndexArgs.add(type_index);
        }

        @Override
        public void visitXExceptionIndex(int exception_index) {
            this.xExceptionIndexArgs.add(exception_index);
        }

        @Override
        public void visitXNameAndArgsSize() {
        }

        @Override
        public void visitEnd() {
            block25: {
                block24: {
                    if (this.xTargetTypeArgs.size() < 1) break block24;
                    TargetType target = TargetType.fromTargetTypeValue(this.xTargetTypeArgs.get(0));
                    switch (target) {
                        case FIELD: {
                            this.handleField(this.aElement);
                            break;
                        }
                        case LOCAL_VARIABLE: 
                        case RESOURCE_VARIABLE: {
                            this.handleMethodLocalVariable((AMethod)this.aElement);
                            break;
                        }
                        case NEW: {
                            if (this.aElement instanceof AMethod) {
                                this.handleMethodObjectCreation((AMethod)this.aElement);
                                break;
                            }
                            break block25;
                        }
                        case METHOD_FORMAL_PARAMETER: {
                            this.handleMethodParameterType((AMethod)this.aElement);
                            break;
                        }
                        case METHOD_RECEIVER: {
                            this.handleMethodReceiver((AMethod)this.aElement);
                            break;
                        }
                        case CAST: {
                            if (this.aElement instanceof AMethod) {
                                this.handleMethodTypecast((AMethod)this.aElement);
                                break;
                            }
                            break block25;
                        }
                        case METHOD_RETURN: {
                            this.handleMethodReturnType((AMethod)this.aElement);
                            break;
                        }
                        case INSTANCEOF: {
                            if (this.aElement instanceof AMethod) {
                                this.handleMethodInstanceOf((AMethod)this.aElement);
                                break;
                            }
                            break block25;
                        }
                        case CLASS_TYPE_PARAMETER_BOUND: {
                            this.handleClassTypeParameterBound((AClass)this.aElement);
                            break;
                        }
                        case METHOD_TYPE_PARAMETER_BOUND: {
                            this.handleMethodTypeParameterBound((AMethod)this.aElement);
                            break;
                        }
                        case CLASS_EXTENDS: {
                            this.handleClassExtends((AClass)this.aElement);
                            break;
                        }
                        case THROWS: {
                            this.handleThrows((AMethod)this.aElement);
                            break;
                        }
                        case CONSTRUCTOR_REFERENCE: 
                        case METHOD_REFERENCE: {
                            this.handleMethodReference((AMethod)this.aElement);
                            break;
                        }
                        case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
                        case METHOD_REFERENCE_TYPE_ARGUMENT: {
                            this.handleReferenceTypeArgument((AMethod)this.aElement);
                            break;
                        }
                        case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                        case METHOD_INVOCATION_TYPE_ARGUMENT: {
                            this.handleCallTypeArgument((AMethod)this.aElement);
                            break;
                        }
                        case METHOD_TYPE_PARAMETER: {
                            this.handleMethodTypeParameter((AMethod)this.aElement);
                            break;
                        }
                        case CLASS_TYPE_PARAMETER: {
                            this.handleClassTypeParameter((AClass)this.aElement);
                            break;
                        }
                        default: {
                            Annotation a = this.makeAnnotation();
                            this.aElement.tlAnnotationsHere.add(a);
                            break;
                        }
                    }
                    break block25;
                }
                Annotation a = this.makeAnnotation();
                if (a.def.isTypeAnnotation() && this.aElement instanceof AMethod) {
                    AMethod m3 = (AMethod)this.aElement;
                    m3.returnType.tlAnnotationsHere.add(a);
                } else {
                    this.aElement.tlAnnotationsHere.add(a);
                }
            }
        }

        public Annotation makeAnnotation() {
            return this.annotationBuilder.finish();
        }

        private LocalLocation makeLocalLocation() {
            int index = this.xIndexArgs.get(0);
            int length = this.xLengthArgs.get(0);
            int start = this.xStartPcArgs.get(0);
            return new LocalLocation(index, start, length);
        }

        private InnerTypeLocation makeInnerTypeLocation() {
            return new InnerTypeLocation(this.xLocationsArgs);
        }

        private RelativeLocation makeOffset(boolean needTypeIndex) {
            int offset = this.xOffsetArgs.get(0);
            int typeIndex = needTypeIndex ? this.xTypeIndexArgs.get(0) : 0;
            return RelativeLocation.createOffset(offset, typeIndex);
        }

        private BoundLocation makeTypeParameterLocation() {
            if (!this.xParamIndexArgs.isEmpty()) {
                return new BoundLocation(this.xParamIndexArgs.get(0), -1);
            }
            return new BoundLocation(Integer.MAX_VALUE, -1);
        }

        private BoundLocation makeBoundLocation() {
            if (!this.xParamIndexArgs.isEmpty()) {
                return new BoundLocation(this.xParamIndexArgs.get(0), this.xBoundIndexArgs.get(0));
            }
            return new BoundLocation(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        private TypeIndexLocation makeTypeIndexLocation() {
            return new TypeIndexLocation(this.xTypeIndexArgs.get(0));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void handleField(AElement aElement) {
            if (this.xLocationsArgs.isEmpty()) {
                if (aElement instanceof AClass) return;
                if (!(aElement instanceof ATypeElement)) throw new RuntimeException("Unknown FIELD aElement: " + aElement);
                aElement.tlAnnotationsHere.add(this.makeAnnotation());
                return;
            } else {
                if (aElement instanceof AClass) return;
                if (!(aElement instanceof ATypeElement)) throw new RuntimeException("Unknown FIELD_COMPONENT: " + aElement);
                ATypeElement aTypeElement = (ATypeElement)aElement;
                aTypeElement.innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodReceiver(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                aMethod.receiver.type.tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aMethod.receiver.type.innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodLocalVariable(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                aMethod.body.locals.getVivify((LocalLocation)this.makeLocalLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aMethod.body.locals.getVivify((LocalLocation)this.makeLocalLocation()).type.innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodObjectCreation(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                ((ATypeElement)aMethod.body.news.getVivify(this.makeOffset((boolean)false))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.news.getVivify(this.makeOffset((boolean)false))).innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private int makeParamIndex() {
            return this.xParamIndexArgs.get(0);
        }

        private void handleMethodParameterType(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                aMethod.parameters.getVivify((Integer)Integer.valueOf((int)this.makeParamIndex())).type.tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aMethod.parameters.getVivify((Integer)Integer.valueOf((int)this.makeParamIndex())).type.innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodTypecast(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                ((ATypeElement)aMethod.body.typecasts.getVivify(this.makeOffset((boolean)true))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.typecasts.getVivify(this.makeOffset((boolean)true))).innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodReturnType(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                aMethod.returnType.tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aMethod.returnType.innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodInstanceOf(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                ((ATypeElement)aMethod.body.instanceofs.getVivify(this.makeOffset((boolean)false))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.typecasts.getVivify(this.makeOffset((boolean)false))).innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleClassTypeParameter(AClass aClass) {
            aClass.bounds.getVivify((BoundLocation)this.makeTypeParameterLocation()).tlAnnotationsHere.add(this.makeAnnotation());
        }

        private void handleClassTypeParameterBound(AClass aClass) {
            if (this.xLocationsArgs.isEmpty()) {
                aClass.bounds.getVivify((BoundLocation)this.makeBoundLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aClass.bounds.getVivify((BoundLocation)this.makeBoundLocation()).innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleMethodTypeParameter(AMethod aMethod) {
            aMethod.bounds.getVivify((BoundLocation)this.makeTypeParameterLocation()).tlAnnotationsHere.add(this.makeAnnotation());
        }

        private void handleMethodTypeParameterBound(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                aMethod.bounds.getVivify((BoundLocation)this.makeBoundLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aMethod.bounds.getVivify((BoundLocation)this.makeBoundLocation()).innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleClassExtends(AClass aClass) {
            if (this.xLocationsArgs.isEmpty()) {
                aClass.extendsImplements.getVivify((TypeIndexLocation)this.makeTypeIndexLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                aClass.extendsImplements.getVivify((TypeIndexLocation)this.makeTypeIndexLocation()).innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleThrows(AMethod aMethod) {
            aMethod.throwsException.getVivify((TypeIndexLocation)this.makeTypeIndexLocation()).tlAnnotationsHere.add(this.makeAnnotation());
        }

        private void handleNewTypeArgument(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                // empty if block
            }
        }

        private void handleMethodReference(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                ((ATypeElement)aMethod.body.refs.getVivify(this.makeOffset((boolean)false))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.refs.getVivify(this.makeOffset((boolean)false))).innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleReferenceTypeArgument(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                ((ATypeElement)aMethod.body.refs.getVivify(this.makeOffset((boolean)true))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.refs.getVivify(this.makeOffset((boolean)true))).innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        private void handleCallTypeArgument(AMethod aMethod) {
            if (this.xLocationsArgs.isEmpty()) {
                ((ATypeElement)aMethod.body.calls.getVivify(this.makeOffset((boolean)true))).tlAnnotationsHere.add(this.makeAnnotation());
            } else {
                ((ATypeElement)aMethod.body.calls.getVivify(this.makeOffset((boolean)true))).innerTypes.getVivify((InnerTypeLocation)this.makeInnerTypeLocation()).tlAnnotationsHere.add(this.makeAnnotation());
            }
        }

        void supplySubannotation(String fieldName, Annotation annotation) {
            this.annotationBuilder.addScalarField(fieldName, new AnnotationAFT(annotation.def()), annotation);
        }

        public String toString() {
            return String.format("(AnnotationSceneReader: %s %s %s)", this.aElement, this.visible, this.annotationBuilder);
        }
    }
}

