/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.element.ElementAnnotationUtil;
import org.checkerframework.framework.util.element.TargetedElementAnnotationApplier;
import org.checkerframework.javacutil.BugInCF;

public class VariableApplier
extends TargetedElementAnnotationApplier {
    private static final ElementKind[] acceptedKinds = new ElementKind[]{ElementKind.LOCAL_VARIABLE, ElementKind.RESOURCE_VARIABLE, ElementKind.EXCEPTION_PARAMETER};
    private final Symbol.VarSymbol varSymbol;

    public static void apply(AnnotatedTypeMirror type, Element element) {
        new VariableApplier(type, element).extractAndApply();
    }

    public static boolean accepts(AnnotatedTypeMirror typeMirror, Element element) {
        return ElementAnnotationUtil.contains((Object)element.getKind(), (Object[])acceptedKinds) || element.getKind().isField();
    }

    VariableApplier(AnnotatedTypeMirror type, Element element) {
        super(type, element);
        this.varSymbol = (Symbol.VarSymbol)element;
        if (type.getKind() == TypeKind.UNION && element.getKind() != ElementKind.EXCEPTION_PARAMETER) {
            throw new BugInCF("Union types only allowed for exception parameters. Type: " + type + " for element: " + element);
        }
    }

    @Override
    protected TargetType[] annotatedTargets() {
        return new TargetType[]{TargetType.LOCAL_VARIABLE, TargetType.RESOURCE_VARIABLE, TargetType.EXCEPTION_PARAMETER, TargetType.FIELD};
    }

    @Override
    protected TargetType[] validTargets() {
        return new TargetType[]{TargetType.NEW, TargetType.CAST, TargetType.INSTANCEOF, TargetType.METHOD_INVOCATION_TYPE_ARGUMENT, TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, TargetType.METHOD_REFERENCE, TargetType.CONSTRUCTOR_REFERENCE, TargetType.METHOD_REFERENCE_TYPE_ARGUMENT, TargetType.CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT};
    }

    @Override
    protected Iterable<Attribute.TypeCompound> getRawTypeAttributes() {
        return this.varSymbol.getRawTypeAttributes();
    }

    @Override
    protected boolean isAccepted() {
        return VariableApplier.accepts(this.type, this.element);
    }

    @Override
    protected void handleTargeted(List<Attribute.TypeCompound> targeted) {
        ElementAnnotationUtil.annotateViaTypeAnnoPosition(this.type, targeted);
    }

    @Override
    public void extractAndApply() {
        ElementAnnotationUtil.addAnnotationsFromElement(this.type, this.varSymbol.getAnnotationMirrors());
        super.extractAndApply();
    }
}

