/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.framework.util.CheckerMain;
import org.checkerframework.javacutil.PluginUtil;

public class CheckerDevelMain
extends CheckerMain {
    private static final String PROP_PREFIX = "CheckerDevelMain";
    private static final String BINARY_PROP = "CheckerDevelMain.binary";
    private static final String CP_PROP = "CheckerDevelMain.cp";
    private static final String PP_PROP = "CheckerDevelMain.pp";
    private static final String COMPILE_BCP_PROP = "CheckerDevelMain.compile.bcp";
    private static final String RUNTIME_CP_PROP = "CheckerDevelMain.runtime.cp";
    private static final String VERBOSE_PROP = "CheckerDevelMain.verbose";

    public static void main(String[] args) {
        String cp = System.getProperty(CP_PROP);
        String pp = System.getProperty(PP_PROP);
        String runtimeCp = System.getProperty(RUNTIME_CP_PROP);
        String compileBcp = System.getProperty(COMPILE_BCP_PROP);
        String binDir = System.getProperty(BINARY_PROP);
        boolean verbose = PluginUtil.getBooleanSystemProperty(VERBOSE_PROP);
        if (verbose) {
            System.out.print("CheckerDevelMain:\nPrepended to classpath:     " + cp + "Prepended to processor classpath:     " + pp + "\nPrepended to compile bootclasspath: " + compileBcp + "\nPrepended to runtime classpath: " + runtimeCp + "\nBinary Dir:                 " + binDir + "\n");
        }
        assert (binDir != null) : "CheckerDevelMain.binary must specify a binary directory in which checker.jar, etc... are usually built";
        assert (cp != null) : "CheckerDevelMain.cp must specify a path entry to prepend to the CLASSPATH";
        assert (pp != null) : "CheckerDevelMain.pp must specify a path entry to prepend to the processor path";
        assert (runtimeCp != null) : "CheckerDevelMain.runtime.cp must specify a path entry to prepend to the Java classpath when running Javac";
        assert (compileBcp != null) : "CheckerDevelMain.compile.bcp must specify a path entry to prepend to the compiler bootclasspath";
        File checkersLoc = new File(binDir, "checker.jar");
        ArrayList<String> argsPlusEa = new ArrayList<String>(args.length + 1);
        argsPlusEa.addAll(Arrays.asList(args));
        argsPlusEa.add("-J-ea");
        CheckerDevelMain program = new CheckerDevelMain(checkersLoc, argsPlusEa);
        int exitStatus = program.invokeCompiler();
        System.exit(exitStatus);
    }

    public CheckerDevelMain(File searchPath, List<String> args) {
        super(searchPath, args);
    }

    @Override
    public void assertValidState() {
    }

    @Override
    protected List<String> createRuntimeClasspath(List<String> argsList) {
        return CheckerDevelMain.prependPathOpts(RUNTIME_CP_PROP, new ArrayList<String>(), new String[0]);
    }

    @Override
    protected List<String> createCompilationBootclasspath(List<String> argsList) {
        return CheckerDevelMain.prependPathOpts(COMPILE_BCP_PROP, super.createCompilationBootclasspath(argsList), new String[0]);
    }

    @Override
    protected List<String> createCpOpts(List<String> argsList) {
        return CheckerDevelMain.prependPathOpts(CP_PROP, super.createCpOpts(argsList), new String[0]);
    }

    @Override
    protected List<String> createPpOpts(List<String> argsList) {
        return CheckerDevelMain.prependPathOpts(PP_PROP, super.createPpOpts(argsList), new String[0]);
    }

    private static List<String> prependPathOpts(String pathProp, List<String> pathOpts, String ... otherPaths) {
        String cp = System.getProperty(pathProp);
        ArrayList<String> newPathOpts = new ArrayList<String>();
        if (!cp.trim().isEmpty()) {
            newPathOpts.addAll(Arrays.asList(cp.split(File.pathSeparator)));
        }
        newPathOpts.addAll(Arrays.asList(otherPaths));
        newPathOpts.addAll(pathOpts);
        return newPathOpts;
    }
}

