/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.treeannotator;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;

public class ListTreeAnnotator
extends TreeAnnotator {
    protected final List<TreeAnnotator> annotators;

    public ListTreeAnnotator(TreeAnnotator ... annotators) {
        this(Arrays.asList(annotators));
    }

    public ListTreeAnnotator(List<TreeAnnotator> annotators) {
        super(null);
        ArrayList<TreeAnnotator> annotatorList = new ArrayList<TreeAnnotator>();
        for (TreeAnnotator annotator : annotators) {
            if (annotator instanceof ListTreeAnnotator) {
                annotatorList.addAll(((ListTreeAnnotator)annotator).annotators);
                continue;
            }
            annotatorList.add(annotator);
        }
        this.annotators = Collections.unmodifiableList(annotatorList);
    }

    @Override
    public Void defaultAction(Tree node, AnnotatedTypeMirror type) {
        for (TreeAnnotator annotator : this.annotators) {
            annotator.visit(node, type);
        }
        return null;
    }

    public String toString() {
        return "ListTreeAnnotator(" + this.annotators + ")";
    }
}

