/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.util;

import java.util.ArrayList;
import org.checkerframework.dataflow.util.AbstractMostlySingleton;
import org.checkerframework.javacutil.BugInCF;

public final class IdentityMostlySingleton<T>
extends AbstractMostlySingleton<T> {
    public IdentityMostlySingleton() {
        this.state = AbstractMostlySingleton.State.EMPTY;
    }

    public IdentityMostlySingleton(T value) {
        this.state = AbstractMostlySingleton.State.SINGLETON;
        this.value = value;
    }

    @Override
    public boolean add(T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingleton.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                this.state = AbstractMostlySingleton.State.ANY;
                this.set = new ArrayList();
                this.set.add(this.value);
                this.value = null;
            }
            case ANY: {
                return this.set.add(e);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }

    @Override
    public boolean contains(Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                return o == this.value;
            }
            case ANY: {
                return this.set.contains(o);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }
}

