/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.reflection;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.reflection.MethodValAnnotatedTypeFactory;
import org.checkerframework.common.reflection.ReflectionResolver;
import org.checkerframework.common.reflection.qual.Invoke;
import org.checkerframework.common.reflection.qual.MethodVal;
import org.checkerframework.common.reflection.qual.NewInstance;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.TreeUtils;

public class DefaultReflectionResolver
implements ReflectionResolver {
    public static final String MSG_PREFEX_REFLECTION = "[Reflection] ";
    private final BaseTypeChecker checker;
    private final AnnotationProvider provider;
    private final ProcessingEnvironment processingEnv;
    private final Trees trees;
    private final boolean debug;

    public DefaultReflectionResolver(BaseTypeChecker checker, MethodValAnnotatedTypeFactory methodValProvider, boolean debug) {
        this.checker = checker;
        this.provider = methodValProvider;
        this.processingEnv = checker.getProcessingEnvironment();
        this.trees = Trees.instance(this.processingEnv);
        this.debug = debug;
    }

    @Override
    public boolean isReflectiveMethodInvocation(MethodInvocationTree tree) {
        return this.provider.getDeclAnnotation(TreeUtils.elementFromTree(tree), Invoke.class) != null || this.provider.getDeclAnnotation(TreeUtils.elementFromTree(tree), NewInstance.class) != null;
    }

    @Override
    public AnnotatedTypeFactory.ParameterizedExecutableType resolveReflectiveCall(AnnotatedTypeFactory factory, MethodInvocationTree tree, AnnotatedTypeFactory.ParameterizedExecutableType origResult) {
        assert (this.isReflectiveMethodInvocation(tree));
        if (this.provider.getDeclAnnotation(TreeUtils.elementFromTree(tree), NewInstance.class) != null) {
            return this.resolveConstructorCall(factory, tree, origResult);
        }
        return this.resolveMethodCall(factory, tree, origResult);
    }

    private AnnotatedTypeFactory.ParameterizedExecutableType resolveMethodCall(AnnotatedTypeFactory factory, MethodInvocationTree tree, AnnotatedTypeFactory.ParameterizedExecutableType origResult) {
        this.debugReflection("Try to resolve reflective method call: " + tree);
        java.util.List<MethodInvocationTree> possibleMethods = this.resolveReflectiveMethod(tree, factory);
        if (possibleMethods.isEmpty()) {
            return origResult;
        }
        Set<? extends AnnotationMirror> returnLub = null;
        Set<? extends AnnotationMirror> receiverGlb = null;
        Set<? extends AnnotationMirror> paramsGlb = null;
        for (MethodInvocationTree resolvedTree : possibleMethods) {
            this.debugReflection("Resolved method invocation: " + resolvedTree);
            if (!this.checkMethodAgruments(resolvedTree)) {
                this.debugReflection("Spoofed tree's arguments did not match declaration" + resolvedTree);
                continue;
            }
            AnnotatedTypeFactory.ParameterizedExecutableType resolvedResult = factory.methodFromUse(resolvedTree);
            returnLub = this.lub(returnLub, resolvedResult.executableType.getReturnType().getAnnotations(), factory);
            receiverGlb = resolvedResult.executableType.getReceiverType() == null ? this.glb(receiverGlb, factory.getQualifierHierarchy().getTopAnnotations(), factory) : this.glb(receiverGlb, resolvedResult.executableType.getReceiverType().getAnnotations(), factory);
            for (AnnotatedTypeMirror mirror : resolvedResult.executableType.getParameterTypes()) {
                paramsGlb = this.glb(paramsGlb, mirror.getAnnotations(), factory);
            }
        }
        if (returnLub == null) {
            return origResult;
        }
        origResult.executableType.getReturnType().clearAnnotations();
        origResult.executableType.getReturnType().addAnnotations(returnLub);
        origResult.executableType.getParameterTypes().get(0).clearAnnotations();
        origResult.executableType.getParameterTypes().get(0).addAnnotations(receiverGlb);
        if (paramsGlb != null) {
            AnnotatedTypeMirror.AnnotatedArrayType origArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)origResult.executableType.getParameterTypes().get(1);
            origArrayType.getComponentType().clearAnnotations();
            origArrayType.getComponentType().addAnnotations(paramsGlb);
        }
        this.debugReflection("Resolved annotations: " + origResult.executableType);
        return origResult;
    }

    private boolean checkMethodAgruments(MethodInvocationTree resolvedTree) {
        ExecutableElement methodDecl = TreeUtils.elementFromUse(resolvedTree);
        return this.checkAgruments(methodDecl.getParameters(), resolvedTree.getArguments());
    }

    private boolean checkNewClassArguments(NewClassTree resolvedTree) {
        ExecutableElement methodDecl = TreeUtils.elementFromUse(resolvedTree);
        return this.checkAgruments(methodDecl.getParameters(), resolvedTree.getArguments());
    }

    private boolean checkAgruments(java.util.List<? extends VariableElement> parameters, java.util.List<? extends ExpressionTree> arguments) {
        if (parameters.size() != arguments.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement param = parameters.get(i);
            ExpressionTree arg = arguments.get(i);
            TypeMirror argType = TreeUtils.typeOf(arg);
            TypeMirror paramType = param.asType();
            if (argType.getKind() != TypeKind.ARRAY || paramType.getKind() == argType.getKind()) continue;
            return false;
        }
        return true;
    }

    private AnnotatedTypeFactory.ParameterizedExecutableType resolveConstructorCall(AnnotatedTypeFactory factory, MethodInvocationTree tree, AnnotatedTypeFactory.ParameterizedExecutableType origResult) {
        this.debugReflection("Try to resolve reflective constructor call: " + tree);
        java.util.List<JCTree.JCNewClass> possibleConstructors = this.resolveReflectiveConstructor(tree, factory);
        if (possibleConstructors.isEmpty()) {
            return origResult;
        }
        Set<? extends AnnotationMirror> returnLub = null;
        Set<? extends AnnotationMirror> paramsGlb = null;
        for (JCTree.JCNewClass resolvedTree : possibleConstructors) {
            this.debugReflection("Resolved constructor invocation: " + resolvedTree);
            if (!this.checkNewClassArguments(resolvedTree)) {
                this.debugReflection("Spoofed tree's arguments did not match declaration" + resolvedTree);
                continue;
            }
            AnnotatedTypeFactory.ParameterizedExecutableType resolvedResult = factory.constructorFromUse(resolvedTree);
            returnLub = this.lub(returnLub, resolvedResult.executableType.getReturnType().getAnnotations(), factory);
            for (AnnotatedTypeMirror mirror : resolvedResult.executableType.getParameterTypes()) {
                paramsGlb = this.glb(paramsGlb, mirror.getAnnotations(), factory);
            }
        }
        if (returnLub == null) {
            return origResult;
        }
        origResult.executableType.getReturnType().clearAnnotations();
        origResult.executableType.getReturnType().addAnnotations(returnLub);
        if (paramsGlb != null) {
            AnnotatedTypeMirror.AnnotatedArrayType origArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)origResult.executableType.getParameterTypes().get(0);
            origArrayType.getComponentType().clearAnnotations();
            origArrayType.getComponentType().addAnnotations(paramsGlb);
        }
        this.debugReflection("Resolved annotations: " + origResult.executableType);
        return origResult;
    }

    private java.util.List<MethodInvocationTree> resolveReflectiveMethod(MethodInvocationTree tree, AnnotatedTypeFactory reflectionFactory) {
        assert (this.isReflectiveMethodInvocation(tree));
        JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)tree;
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        TreeMaker make = TreeMaker.instance(context);
        TreePath path = reflectionFactory.getPath(tree);
        JavacScope scope = (JavacScope)this.trees.getScope(path);
        Env<AttrContext> env = scope.getEnv();
        ArrayList<MethodInvocationTree> methods = new ArrayList<MethodInvocationTree>();
        boolean unknown = this.isUnknownMethod(tree);
        AnnotationMirror estimate = this.getMethodVal(tree);
        if (estimate == null) {
            this.debugReflection("MethodVal is unknown for: " + tree);
            this.debugReflection("UnknownMethod annotation: " + unknown);
            return methods;
        }
        this.debugReflection("MethodVal type system annotations: " + estimate);
        java.util.List<String> listClassNames = AnnotationUtils.getElementValueArray(estimate, "className", String.class, true);
        java.util.List<String> listMethodNames = AnnotationUtils.getElementValueArray(estimate, "methodName", String.class, true);
        java.util.List<Integer> listParamLenghts = AnnotationUtils.getElementValueArray(estimate, "params", Integer.class, true);
        assert (listClassNames.size() == listMethodNames.size() && listClassNames.size() == listParamLenghts.size());
        for (int i = 0; i < listClassNames.size(); ++i) {
            String className = listClassNames.get(i);
            String methodName = listMethodNames.get(i);
            int paramLength = listParamLenghts.get(i);
            JCTree.JCExpression receiver = (JCTree.JCExpression)methodInvocation.args.head;
            List<JCTree.JCExpression> args = methodInvocation.args.tail;
            for (Symbol symbol : this.getMethodSymbolsfor(className, methodName, paramLength, env)) {
                if (!this.processingEnv.getTypeUtils().isSubtype(receiver.type, symbol.owner.type)) continue;
                if ((symbol.flags() & 1L) > 0L) {
                    this.debugReflection("Resolved public method: " + symbol.owner + "." + symbol);
                } else {
                    this.debugReflection("Resolved non-public method: " + symbol.owner + "." + symbol);
                }
                JCTree.JCExpression method = make.Select(receiver, symbol);
                args = this.getCorrectedArgs(symbol, args);
                JCTree.JCMethodInvocation syntTree = paramLength > 0 ? make.App(method, args) : make.App(method);
                methods.add(syntTree);
            }
        }
        return methods;
    }

    private List<JCTree.JCExpression> getCorrectedArgs(Symbol symbol, List<JCTree.JCExpression> args) {
        if (symbol.getKind() == ElementKind.METHOD) {
            Symbol.MethodSymbol method = (Symbol.MethodSymbol)symbol;
            int diff = ((List)method.getParameters()).size() - args.size();
            if (diff > 0) {
                int origArgSize = args.size();
                for (int i = 0; i < diff; ++i) {
                    args = args.append(args.get(i % origArgSize));
                }
            } else if (diff < 0) {
                List<JCTree.JCExpression> tmp = List.nil();
                for (int i = 0; i < ((List)method.getParameters()).size(); ++i) {
                    tmp = tmp.append(args.get(i));
                }
                args = tmp;
            }
        }
        return args;
    }

    private java.util.List<JCTree.JCNewClass> resolveReflectiveConstructor(MethodInvocationTree tree, AnnotatedTypeFactory reflectionFactory) {
        assert (this.isReflectiveMethodInvocation(tree));
        JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)tree;
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        TreeMaker make = TreeMaker.instance(context);
        TreePath path = reflectionFactory.getPath(tree);
        JavacScope scope = (JavacScope)this.trees.getScope(path);
        Env<AttrContext> env = scope.getEnv();
        ArrayList<JCTree.JCNewClass> constructors = new ArrayList<JCTree.JCNewClass>();
        AnnotationMirror estimate = this.getMethodVal(tree);
        if (estimate == null) {
            this.debugReflection("MethodVal is unknown for: " + tree);
            this.debugReflection("UnknownMethod annotation: " + this.isUnknownMethod(tree));
            return constructors;
        }
        this.debugReflection("MethodVal type system annotations: " + estimate);
        java.util.List<String> listClassNames = AnnotationUtils.getElementValueArray(estimate, "className", String.class, true);
        java.util.List<Integer> listParamLenghts = AnnotationUtils.getElementValueArray(estimate, "params", Integer.class, true);
        assert (listClassNames.size() == listParamLenghts.size());
        for (int i = 0; i < listClassNames.size(); ++i) {
            String className = listClassNames.get(i);
            int paramLength = listParamLenghts.get(i);
            for (Symbol symbol : this.getConstructorSymbolsfor(className, paramLength, env)) {
                this.debugReflection("Resolved constructor: " + symbol.owner + "." + symbol);
                JCTree.JCNewClass syntTree = (JCTree.JCNewClass)make.Create(symbol, methodInvocation.args);
                constructors.add(syntTree);
            }
        }
        return constructors;
    }

    private AnnotationMirror getMethodVal(MethodInvocationTree tree) {
        return this.provider.getAnnotationMirror(TreeUtils.getReceiverTree(tree), MethodVal.class);
    }

    private boolean isUnknownMethod(MethodInvocationTree tree) {
        return this.provider.getAnnotationMirror(TreeUtils.getReceiverTree(tree), UnknownMethod.class) != null;
    }

    private java.util.List<Symbol> getMethodSymbolsfor(String className, String methodName, int paramLength, Env<AttrContext> env) {
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        Resolve resolve = Resolve.instance(context);
        Names names = Names.instance(context);
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        Symbol sym = this.getSymbol(className, env, names, resolve);
        if (!sym.exists()) {
            this.debugReflection("Unable to resolve class: " + className);
            return Collections.emptyList();
        }
        Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)sym;
        while (classSym != null) {
            Type t;
            for (Symbol s2 : classSym.getEnclosedElements()) {
                if (s2.getKind() != ElementKind.METHOD || !names.fromString(methodName).equals(s2.name) || ((List)((Symbol.MethodSymbol)s2).getParameters()).size() != paramLength) continue;
                result.add(s2);
            }
            if (!result.isEmpty() || !(t = classSym.getSuperclass()).hasTag(TypeTag.CLASS) || t.isErroneous()) break;
            classSym = (Symbol.ClassSymbol)t.tsym;
        }
        if (result.isEmpty()) {
            this.debugReflection("Unable to resolve method: " + className + "@" + methodName);
        }
        return result;
    }

    private java.util.List<Symbol> getConstructorSymbolsfor(String className, int paramLength, Env<AttrContext> env) {
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        Resolve resolve = Resolve.instance(context);
        Names names = Names.instance(context);
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        Symbol symClass = this.getSymbol(className, env, names, resolve);
        if (!symClass.exists()) {
            this.debugReflection("Unable to resolve class: " + className);
            return Collections.emptyList();
        }
        ElementFilter.constructorsIn(symClass.getEnclosedElements());
        for (Symbol s2 : symClass.getEnclosedElements()) {
            if (s2.getKind() != ElementKind.CONSTRUCTOR || ((List)((Symbol.MethodSymbol)s2).getParameters()).size() != paramLength) continue;
            result.add(s2);
        }
        if (result.isEmpty()) {
            this.debugReflection("Unable to resolve constructor!");
        }
        return result;
    }

    private Symbol getSymbol(String className, Env<AttrContext> env, Names names, Resolve resolve) {
        Method loadClass;
        try {
            loadClass = Resolve.class.getDeclaredMethod("loadClass", Env.class, Name.class);
            loadClass.setAccessible(true);
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new BugInCF("Error in obtaining reflective method.", e);
        }
        try {
            Symbol symbol = (Symbol)loadClass.invoke((Object)resolve, env, names.fromString(className));
            return symbol;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new BugInCF("Error in invoking reflective method.", e);
        }
    }

    private Set<? extends AnnotationMirror> lub(Set<? extends AnnotationMirror> set1, Set<? extends AnnotationMirror> set2, AnnotatedTypeFactory factory) {
        if (set1 == null || set1.isEmpty()) {
            return set2;
        }
        return factory.getQualifierHierarchy().leastUpperBounds(set1, set2);
    }

    private Set<? extends AnnotationMirror> glb(Set<? extends AnnotationMirror> set1, Set<? extends AnnotationMirror> set2, AnnotatedTypeFactory factory) {
        if (set1 == null || set1.isEmpty()) {
            return set2;
        }
        return factory.getQualifierHierarchy().greatestLowerBounds(set1, set2);
    }

    private void debugReflection(String msg) {
        if (this.debug) {
            this.checker.message(Diagnostic.Kind.NOTE, MSG_PREFEX_REFLECTION + msg, new Object[0]);
        }
    }
}

