/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.Subsequence;
import org.checkerframework.checker.index.qual.HasSubsequence;
import org.checkerframework.checker.index.qual.LTLengthOf;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.upperbound.UBQualifier;
import org.checkerframework.checker.index.upperbound.UpperBoundAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public class UpperBoundVisitor
extends BaseTypeVisitor<UpperBoundAnnotatedTypeFactory> {
    private static final @CompilerMessageKey String UPPER_BOUND = "array.access.unsafe.high";
    private static final @CompilerMessageKey String UPPER_BOUND_CONST = "array.access.unsafe.high.constant";
    private static final @CompilerMessageKey String UPPER_BOUND_RANGE = "array.access.unsafe.high.range";
    private static final @CompilerMessageKey String TO_NOT_LTEL = "to.not.ltel";
    private static final @CompilerMessageKey String NOT_FINAL = "not.final";
    private static final @CompilerMessageKey String HSS = "which.subsequence";

    public UpperBoundVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree tree, Void type) {
        ExpressionTree indexTree = tree.getIndex();
        ExpressionTree arrTree = tree.getExpression();
        this.visitAccess(indexTree, arrTree);
        return super.visitArrayAccess(tree, type);
    }

    @Override
    public Void visitAnnotation(AnnotationTree node, Void p) {
        AnnotationMirror anno = TreeUtils.annotationFromAnnotationTree(node);
        if (AnnotationUtils.areSameByClass(anno, LTLengthOf.class)) {
            List<? extends ExpressionTree> args = node.getArguments();
            if (args.size() == 2) {
                List<String> sequences = AnnotationUtils.getElementValueArray(anno, "value", String.class, true);
                List<String> offsets = AnnotationUtils.getElementValueArray(anno, "offset", String.class, true);
                if (sequences.size() != offsets.size() && !offsets.isEmpty()) {
                    this.checker.report(Result.failure("different.length.sequences.offsets", sequences.size(), offsets.size()), node);
                    return null;
                }
            }
        } else if (AnnotationUtils.areSameByClass(anno, HasSubsequence.class)) {
            String seq = AnnotationUtils.getElementValue(anno, "subsequence", String.class, true);
            String from = AnnotationUtils.getElementValue(anno, "from", String.class, true);
            String to = AnnotationUtils.getElementValue(anno, "to", String.class, true);
            ClassTree enclosingClass = TreeUtils.enclosingClass(this.getCurrentPath());
            FlowExpressionParseUtil.FlowExpressionContext context = FlowExpressionParseUtil.FlowExpressionContext.buildContextForClassDeclaration(enclosingClass, this.checker);
            this.checkEffectivelyFinalAndParsable(seq, context, node);
            this.checkEffectivelyFinalAndParsable(from, context, node);
            this.checkEffectivelyFinalAndParsable(to, context, node);
        }
        return super.visitAnnotation(node, p);
    }

    private void checkEffectivelyFinalAndParsable(String s2, FlowExpressionParseUtil.FlowExpressionContext context, Tree error) {
        FlowExpressions.Receiver rec;
        try {
            rec = FlowExpressionParseUtil.parse(s2, context, this.getCurrentPath(), false);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
            this.checker.report(e.getResult(), error);
            return;
        }
        Element element = null;
        if (rec instanceof FlowExpressions.LocalVariable) {
            element = ((FlowExpressions.LocalVariable)rec).getElement();
        } else if (rec instanceof FlowExpressions.FieldAccess) {
            element = ((FlowExpressions.FieldAccess)rec).getField();
        } else if (rec instanceof FlowExpressions.ThisReference || rec instanceof FlowExpressions.ValueLiteral) {
            return;
        }
        if (element == null || !ElementUtils.isEffectivelyFinal(element)) {
            this.checker.report(Result.failure(NOT_FINAL, rec), error);
        }
    }

    private void visitAccess(ExpressionTree indexTree, ExpressionTree arrTree) {
        String arrName = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, arrTree).toString();
        UBQualifier.LessThanLengthOf lhsQual = (UBQualifier.LessThanLengthOf)UBQualifier.createUBQualifier(arrName, "0");
        if (this.relaxedCommonAssignmentCheck(lhsQual, indexTree) || this.checkMinLen(indexTree, arrTree)) {
            return;
        }
        AnnotatedTypeMirror indexType = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(indexTree);
        UBQualifier qualifier = UBQualifier.createUBQualifier(indexType, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
        ValueAnnotatedTypeFactory valueFactory = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory();
        Long valMax = IndexUtil.getMaxValue(indexTree, valueFactory);
        if (IndexUtil.getExactValue(indexTree, valueFactory) != null) {
            this.checker.report(Result.failure(UPPER_BOUND_CONST, valMax, valueFactory.getAnnotatedType(arrTree).toString(), valMax + 1L, valMax + 1L), indexTree);
        } else if (valMax != null && qualifier.isUnknown()) {
            this.checker.report(Result.failure(UPPER_BOUND_RANGE, valueFactory.getAnnotatedType(indexTree).toString(), valueFactory.getAnnotatedType(arrTree).toString(), arrName, arrName, valMax + 1L), indexTree);
        } else {
            this.checker.report(Result.failure(UPPER_BOUND, indexType.toString(), arrName, arrName, arrName), indexTree);
        }
    }

    @Override
    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueTree, @CompilerMessageKey String errorKey) {
        Subsequence subSeq = Subsequence.getSubsequenceFromTree(varTree, this.atypeFactory);
        if (subSeq != null) {
            AnnotationMirror anm;
            try {
                anm = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotationMirrorFromJavaExpressionString(subSeq.to, varTree, this.getCurrentPath());
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                anm = null;
            }
            boolean ltelCheckFailed = true;
            if (anm != null) {
                UBQualifier qual = UBQualifier.createUBQualifier(anm);
                boolean bl = ltelCheckFailed = !qual.isLessThanOrEqualTo(subSeq.array);
            }
            if (ltelCheckFailed) {
                this.checker.report(Result.failure(TO_NOT_LTEL, subSeq.to, subSeq.array, anm == null ? "@UpperBoundUnknown" : anm, subSeq.array, subSeq.array, subSeq.array), valueTree);
            } else {
                this.checker.report(Result.warning(HSS, subSeq.array, subSeq.from, subSeq.from, subSeq.to, subSeq.to, subSeq.array, subSeq.array), valueTree);
            }
        }
        super.commonAssignmentCheck(varTree, valueTree, errorKey);
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, ExpressionTree valueTree, @CompilerMessageKey String errorKey) {
        AnnotatedTypeMirror valueType = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(valueTree);
        this.commonAssignmentCheckStartDiagnostic(varType, valueType, valueTree);
        if (!this.relaxedCommonAssignment(varType, valueTree)) {
            this.commonAssignmentCheckEndDiagnostic(true, "relaxedCommonAssignment didn't override, now must call super", varType, valueType, valueTree);
            super.commonAssignmentCheck(varType, valueTree, errorKey);
        } else if (this.checker.hasOption("showchecks")) {
            this.commonAssignmentCheckEndDiagnostic(true, "relaxedCommonAssignment", varType, valueType, valueTree);
        }
    }

    private boolean relaxedCommonAssignment(AnnotatedTypeMirror varType, ExpressionTree valueExp) {
        if (valueExp.getKind() == Tree.Kind.NEW_ARRAY && varType.getKind() == TypeKind.ARRAY) {
            List<? extends ExpressionTree> expressions = ((NewArrayTree)valueExp).getInitializers();
            if (expressions == null || expressions.isEmpty()) {
                return false;
            }
            AnnotatedTypeMirror componentType = ((AnnotatedTypeMirror.AnnotatedArrayType)varType).getComponentType();
            UBQualifier qualifier = UBQualifier.createUBQualifier(componentType, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
            if (!qualifier.isLessThanLengthQualifier()) {
                return false;
            }
            for (ExpressionTree expressionTree : expressions) {
                if (this.relaxedCommonAssignmentCheck((UBQualifier.LessThanLengthOf)qualifier, expressionTree)) continue;
                return false;
            }
            return true;
        }
        UBQualifier qualifier = UBQualifier.createUBQualifier(varType, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
        return qualifier.isLessThanLengthQualifier() && this.relaxedCommonAssignmentCheck((UBQualifier.LessThanLengthOf)qualifier, valueExp);
    }

    static Pair<FlowExpressions.Receiver, String> getReceiverAndOffsetFromJavaExpressionString(String s2, UpperBoundAnnotatedTypeFactory atypeFactory, TreePath currentPath) {
        Pair<String, String> p = AnnotatedTypeFactory.getExpressionAndOffset(s2);
        FlowExpressions.Receiver rec = UpperBoundVisitor.getReceiverFromJavaExpressionString((String)p.first, atypeFactory, currentPath);
        if (rec == null) {
            return null;
        }
        return Pair.of(rec, p.second);
    }

    static FlowExpressions.Receiver getReceiverFromJavaExpressionString(String s2, UpperBoundAnnotatedTypeFactory atypeFactory, TreePath currentPath) {
        FlowExpressions.Receiver rec;
        try {
            rec = atypeFactory.getReceiverFromJavaExpressionString(s2, currentPath);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
            rec = null;
        }
        return rec;
    }

    private String negateString(String s2, FlowExpressionParseUtil.FlowExpressionContext context) {
        return Subsequence.negateString(s2, this.getCurrentPath(), context);
    }

    private boolean checkMinLen(ExpressionTree indexTree, ExpressionTree arrTree) {
        int minLen = IndexUtil.getMinLen(arrTree, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory());
        Long valMax = IndexUtil.getMaxValue(indexTree, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory());
        return valMax != null && valMax < (long)minLen;
    }

    private boolean relaxedCommonAssignmentCheck(UBQualifier.LessThanLengthOf varLtlQual, ExpressionTree valueExp) {
        UBQualifier lessThanOrEqualQual;
        AnnotatedTypeMirror expType = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(valueExp);
        UBQualifier expQual = UBQualifier.createUBQualifier(expType, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
        UBQualifier lessThanQual = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).fromLessThan(valueExp, this.getCurrentPath());
        if (lessThanQual != null) {
            expQual = expQual.glb(lessThanQual);
        }
        if ((lessThanOrEqualQual = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).fromLessThanOrEqual(valueExp, this.getCurrentPath())) != null) {
            expQual = expQual.glb(lessThanOrEqualQual);
        }
        if (expQual.isSubtype(varLtlQual)) {
            return true;
        }
        UBQualifier newLHS = this.processSubsequenceForLHS(varLtlQual, expQual);
        if (newLHS.isUnknown()) {
            return true;
        }
        varLtlQual = (UBQualifier.LessThanLengthOf)newLHS;
        Long value = IndexUtil.getMaxValue(valueExp, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory());
        if (value == null && !expQual.isLessThanLengthQualifier()) {
            return false;
        }
        SameLenAnnotatedTypeFactory sameLenFactory = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getSameLenAnnotatedTypeFactory();
        ValueAnnotatedTypeFactory valueAnnotatedTypeFactory = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getValueAnnotatedTypeFactory();
        block0: for (String string : varLtlQual.getSequences()) {
            int minlen;
            List<String> sameLenSequences = sameLenFactory.getSameLensFromString(string, valueExp, this.getCurrentPath());
            if (this.testSameLen(expQual, varLtlQual, sameLenSequences, string) || this.testMinLen(value, minlen = valueAnnotatedTypeFactory.getMinLenFromString(string, valueExp, this.getCurrentPath()), string, varLtlQual)) continue;
            for (String sequence : sameLenSequences) {
                int minlenSL = valueAnnotatedTypeFactory.getMinLenFromString(sequence, valueExp, this.getCurrentPath());
                if (!this.testMinLen(value, minlenSL, string, varLtlQual)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private UBQualifier processSubsequenceForLHS(UBQualifier.LessThanLengthOf varLtlQual, UBQualifier expQual) {
        UBQualifier newLHS = varLtlQual;
        for (String string : varLtlQual.getSequences()) {
            String from;
            String a;
            if (!varLtlQual.hasSequenceWithOffset(string, 0)) continue;
            FlowExpressions.Receiver rec = UpperBoundVisitor.getReceiverFromJavaExpressionString(string, (UpperBoundAnnotatedTypeFactory)this.atypeFactory, this.getCurrentPath());
            FlowExpressionParseUtil.FlowExpressionContext context = Subsequence.getContextFromReceiver(rec, this.checker);
            Subsequence subSeq = Subsequence.getSubsequenceFromReceiver(rec, this.atypeFactory, this.getCurrentPath(), context);
            if (subSeq == null || !expQual.hasSequenceWithOffset(a = subSeq.array, this.negateString(from = subSeq.from, context))) continue;
            newLHS = newLHS.removeOffset(string, 0);
        }
        return newLHS;
    }

    private boolean testSameLen(UBQualifier expQual, UBQualifier.LessThanLengthOf varQual, List<String> sameLenArrays, String arrayName) {
        if (!expQual.isLessThanLengthQualifier()) {
            return false;
        }
        for (String sameLenArrayName : sameLenArrays) {
            if (!varQual.isValidReplacement(arrayName, sameLenArrayName, (UBQualifier.LessThanLengthOf)expQual)) continue;
            return true;
        }
        return false;
    }

    private boolean testMinLen(Long value, int minLen, String arrayName, UBQualifier.LessThanLengthOf varQual) {
        if (value == null) {
            return false;
        }
        return varQual.isValuePlusOffsetLessThanMinLen(arrayName, value, minLen);
    }
}

