/*
 * Decompiled with CFR 0.152.
 */
package annotator.specification;

import annotator.Main;
import annotator.find.AnnotationInsertion;
import annotator.find.CastInsertion;
import annotator.find.CloseParenthesisInsertion;
import annotator.find.ConstructorInsertion;
import annotator.find.Criteria;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.Insertion;
import annotator.find.IntersectionTypeLocationCriterion;
import annotator.find.NewInsertion;
import annotator.find.ReceiverInsertion;
import annotator.scanner.MethodOffsetClassVisitor;
import annotator.specification.CriterionList;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.com.google.common.collect.LinkedHashMultimap;
import org.checkerframework.com.google.common.collect.Multimap;
import org.checkerframework.org.objectweb.asmx.ClassReader;
import org.checkerframework.org.objectweb.asmx.ClassVisitor;
import org.checkerframework.org.plumelib.util.FileIOException;
import org.checkerframework.org.plumelib.util.Pair;
import scenelib.annotations.Annotation;
import scenelib.annotations.el.ABlock;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AExpression;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.ATypeElementWithType;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.BoundLocation;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.el.LocalLocation;
import scenelib.annotations.el.RelativeLocation;
import scenelib.annotations.el.TypeIndexLocation;
import scenelib.annotations.field.AnnotationFieldType;
import scenelib.annotations.io.ASTPath;
import scenelib.annotations.io.IndexFileParser;
import scenelib.annotations.util.coll.VivifyingMap;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public class IndexFileSpecification {
    private final Multimap<Insertion, Annotation> insertionSources = LinkedHashMultimap.create();
    private final List<Insertion> insertions = new ArrayList<Insertion>();
    private ConstructorInsertion constructorInsertion = null;
    private final AScene scene;
    private final String indexFileName;
    public static boolean noAsm = false;
    private static boolean debug = false;

    public IndexFileSpecification(String string) {
        this.indexFileName = string;
        this.scene = new AScene();
    }

    public List<Insertion> parse() throws FileIOException {
        try {
            Map<String, AnnotationDef> map = IndexFileParser.parseFile(this.indexFileName, this.scene);
            Set<String> set = map.keySet();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (String string : set) {
                String string2;
                int n = Math.max(string.lastIndexOf("."), string.lastIndexOf("$"));
                if (n < 0 || map.get(string2 = string.substring(n + 1)) != null) continue;
                linkedHashSet.add(string2);
            }
            Insertion.setAlwaysQualify(linkedHashSet);
        }
        catch (FileIOException fileIOException) {
            throw fileIOException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while parsing index file", exception);
        }
        if (debug) {
            System.out.printf("Scene parsed from %s:%n", this.indexFileName);
            System.out.println(this.scene.unparse());
        }
        this.parseScene();
        return this.insertions;
    }

    public Map<String, Set<String>> annotationImports() {
        return this.scene.imports;
    }

    public Multimap<Insertion, Annotation> insertionSources() {
        return this.insertionSources;
    }

    private void addInsertionSource(Insertion insertion, Annotation annotation) {
        this.insertionSources.put(insertion, annotation);
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public AScene getScene() {
        return this.scene;
    }

    private void parseScene() {
        IndexFileSpecification.debug("parseScene()");
        CriterionList criterionList = new CriterionList();
        VivifyingMap<String, AElement> vivifyingMap = this.scene.packages;
        for (Map.Entry object : vivifyingMap.entrySet()) {
            this.parsePackage(criterionList, (String)object.getKey(), (AElement)object.getValue());
        }
        VivifyingMap<String, AClass> vivifyingMap2 = this.scene.classes;
        for (Map.Entry entry : vivifyingMap2.entrySet()) {
            String string = (String)entry.getKey();
            AClass aClass = (AClass)entry.getValue();
            if (string.endsWith(".package-info")) {
                this.parsePackage(criterionList, string.substring(0, string.length() - 13), aClass);
                continue;
            }
            this.parseClass(criterionList, string, aClass);
        }
    }

    private void parsePackage(CriterionList criterionList, String string, AElement aElement) {
        CriterionList criterionList2 = criterionList.add(Criteria.packageDecl(string));
        this.parseElement(criterionList2, aElement);
    }

    private void parseClass(CriterionList criterionList, String string, AClass aClass) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        this.constructorInsertion = null;
        if (!noAsm) {
            IndexFileSpecification.debug("parseClass(" + string + ")");
            try {
                object7 = new ClassReader(string);
                object6 = new MethodOffsetClassVisitor((ClassReader)object7);
                ((ClassReader)object7).accept((ClassVisitor)object6, false);
                IndexFileSpecification.debug("Done reading " + string + ".class");
            }
            catch (IOException iOException) {
                System.out.println("Warning: IndexFileSpecification did not find classfile for: " + string);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("IndexFileSpecification had a problem reading class: " + string);
                throw runtimeException;
            }
            catch (Error error) {
                System.err.println("IndexFileSpecification had a problem reading class: " + string);
                throw error;
            }
        }
        object7 = criterionList;
        criterionList = criterionList.add(Criteria.inClass(string, true));
        object6 = ((CriterionList)object7).add(Criteria.is(Tree.Kind.CLASS, string));
        this.parseElement((CriterionList)object6, aClass);
        VivifyingMap<BoundLocation, ATypeElement> vivifyingMap = aClass.bounds;
        for (Map.Entry iterator : vivifyingMap.entrySet()) {
            Map.Entry entry = (BoundLocation)iterator.getKey();
            object5 = (ATypeElement)iterator.getValue();
            object4 = criterionList.add(Criteria.classBound(string, (BoundLocation)((Object)entry)));
            for (Map.Entry entry2 : ((ATypeElement)object5).innerTypes.entrySet()) {
                InnerTypeLocation innerTypeLocation = (InnerTypeLocation)entry2.getKey();
                object3 = (AElement)entry2.getValue();
                object2 = ((CriterionList)object4).add(Criteria.atLocation(innerTypeLocation));
                this.parseElement((CriterionList)object2, (AElement)object3);
            }
            object = ((CriterionList)object4).add(Criteria.atLocation());
            this.parseElement((CriterionList)object, (AElement)object5);
        }
        criterionList = criterionList.add(Criteria.inClass(string, false));
        VivifyingMap<TypeIndexLocation, ATypeElement> vivifyingMap2 = aClass.extendsImplements;
        for (Map.Entry entry : vivifyingMap2.entrySet()) {
            object5 = (TypeIndexLocation)entry.getKey();
            object4 = (ATypeElement)entry.getValue();
            object = criterionList.add(Criteria.atExtImplsLocation(string, (TypeIndexLocation)object5));
            for (Map.Entry entry3 : ((ATypeElement)object4).innerTypes.entrySet()) {
                object3 = (InnerTypeLocation)entry3.getKey();
                object2 = (AElement)entry3.getValue();
                CriterionList criterionList2 = ((CriterionList)object).add(Criteria.atLocation((InnerTypeLocation)object3));
                this.parseElement(criterionList2, (AElement)object2);
            }
            this.parseElement((CriterionList)object, (AElement)object4);
        }
        this.parseASTInsertions(criterionList, aClass.insertAnnotations, aClass.insertTypecasts);
        for (Map.Entry entry : aClass.fields.entrySet()) {
            this.parseField(criterionList, (String)entry.getKey(), (AField)entry.getValue());
        }
        for (Map.Entry entry : aClass.methods.entrySet()) {
            this.parseMethod(criterionList, string, (String)entry.getKey(), (AMethod)entry.getValue());
        }
        for (Map.Entry entry : aClass.staticInits.entrySet()) {
            this.parseStaticInit(criterionList, string, (Integer)entry.getKey(), (ABlock)entry.getValue());
        }
        for (Map.Entry entry : aClass.instanceInits.entrySet()) {
            this.parseInstanceInit(criterionList, string, (Integer)entry.getKey(), (ABlock)entry.getValue());
        }
        for (Map.Entry entry : aClass.fieldInits.entrySet()) {
            this.parseFieldInit(criterionList, string, (String)entry.getKey(), (AExpression)entry.getValue());
        }
        IndexFileSpecification.debug("parseClass(" + string + "):  done");
    }

    private void parseField(CriterionList criterionList, String string, AField aField) {
        this.parseElement(criterionList.add(Criteria.field(string, true)), aField);
        criterionList = criterionList.add(Criteria.field(string, false));
        this.parseInnerAndOuterElements(criterionList, aField.type);
        this.parseASTInsertions(criterionList, aField.insertAnnotations, aField.insertTypecasts);
    }

    private void parseStaticInit(CriterionList criterionList, String string, int n, ABlock aBlock) {
        criterionList = criterionList.add(Criteria.inStaticInit(n));
        this.parseBlock(criterionList, string, "static init number " + n + "()", aBlock);
    }

    private void parseInstanceInit(CriterionList criterionList, String string, int n, ABlock aBlock) {
        criterionList = criterionList.add(Criteria.inInstanceInit(n));
        this.parseBlock(criterionList, string, "instance init number " + n + "()", aBlock);
    }

    private void parseFieldInit(CriterionList criterionList, String string, String string2, AExpression aExpression) {
        criterionList = criterionList.add(Criteria.inFieldInit(string2));
        this.parseExpression(criterionList, string, "init for field " + string2 + "()", aExpression);
    }

    private List<Insertion> parseElement(CriterionList criterionList, AElement aElement) {
        return this.parseElement(criterionList, aElement, new ArrayList<Insertion>(), false);
    }

    private List<Insertion> parseElement(CriterionList criterionList, AElement aElement, boolean bl) {
        return this.parseElement(criterionList, aElement, new ArrayList<Insertion>(), bl);
    }

    private List<Insertion> parseElement(CriterionList criterionList, AElement aElement, List<Insertion> list) {
        return this.parseElement(criterionList, aElement, list, false);
    }

    private List<Insertion> parseElement(CriterionList criterionList, AElement aElement, List<Insertion> list, boolean bl) {
        ReceiverInsertion receiverInsertion = null;
        NewInsertion newInsertion = null;
        CastInsertion castInsertion = null;
        CloseParenthesisInsertion closeParenthesisInsertion = null;
        ArrayList<Insertion> arrayList = new ArrayList<Insertion>();
        Set<Pair<String, Annotation>> set = this.getElementAnnotations(aElement);
        if (set.isEmpty()) {
            Criteria criteria = criterionList.criteria();
            if (aElement instanceof ATypeElementWithType) {
                Pair<CastInsertion, CloseParenthesisInsertion> pair = this.createCastInsertion(((ATypeElementWithType)aElement).getType(), null, list, criteria);
                castInsertion = (CastInsertion)pair.a;
                closeParenthesisInsertion = (CloseParenthesisInsertion)pair.b;
            } else if (!list.isEmpty()) {
                if (IndexFileSpecification.isOnReceiver(criteria)) {
                    receiverInsertion = new ReceiverInsertion(new DeclaredType(), criteria, list);
                } else if (IndexFileSpecification.isOnNew(criteria)) {
                    newInsertion = new NewInsertion(new DeclaredType(), criteria, list);
                }
            }
        }
        for (Pair pair : set) {
            Object object;
            ArrayList<Insertion> arrayList2 = new ArrayList<Insertion>();
            String string = (String)pair.a;
            Annotation annotation = (Annotation)pair.b;
            Criteria criteria = criterionList.criteria();
            Boolean bl2 = !annotation.def.isTypeAnnotation() || criteria.isOnFieldDeclaration();
            if (this.noTypePath(criteria) && IndexFileSpecification.isOnReceiver(criteria)) {
                if (receiverInsertion == null) {
                    object = new DeclaredType();
                    ((Type)object).addAnnotation(string);
                    receiverInsertion = new ReceiverInsertion((DeclaredType)object, criteria, list);
                    arrayList2.add(receiverInsertion);
                } else {
                    receiverInsertion.getType().addAnnotation(string);
                }
                this.addInsertionSource(receiverInsertion, annotation);
            } else if (this.noTypePath(criteria) && IndexFileSpecification.isOnNew(criteria)) {
                if (newInsertion == null) {
                    object = new DeclaredType();
                    ((Type)object).addAnnotation(string);
                    newInsertion = new NewInsertion((Type)object, criteria, list);
                    arrayList2.add(newInsertion);
                } else {
                    newInsertion.getType().addAnnotation(string);
                }
                this.addInsertionSource(newInsertion, annotation);
            } else if (aElement instanceof ATypeElementWithType) {
                if (castInsertion == null) {
                    object = this.createCastInsertion(((ATypeElementWithType)aElement).getType(), string, list, criteria);
                    castInsertion = (CastInsertion)((Pair)object).a;
                    closeParenthesisInsertion = (CloseParenthesisInsertion)((Pair)object).b;
                    arrayList2.add(castInsertion);
                    arrayList2.add(closeParenthesisInsertion);
                } else {
                    castInsertion.getType().addAnnotation(string);
                }
                this.addInsertionSource(castInsertion, annotation);
            } else {
                object = criteria.getCastRelativeLocation();
                if (object != null && ((RelativeLocation)object).type_index > 0) {
                    criteria.add(new IntersectionTypeLocationCriterion((RelativeLocation)object));
                }
                Insertion insertion = new AnnotationInsertion(string, criteria, bl2);
                IndexFileSpecification.debug("parsed: " + insertion);
                if (!bl) {
                    arrayList2.add(insertion);
                }
                arrayList.add(insertion);
                this.addInsertionSource(insertion, annotation);
            }
            this.insertions.addAll(arrayList2);
            if (this.noTypePath(criteria) && IndexFileSpecification.isOnNullaryConstructor(criteria)) {
                if (this.constructorInsertion == null) {
                    object = new DeclaredType(criteria.getClassName());
                    this.constructorInsertion = new ConstructorInsertion((Type)object, criteria, new ArrayList<Insertion>());
                    this.insertions.add(this.constructorInsertion);
                } else if (Main.temporaryDebug) {
                    System.out.printf("Ignoring criteria=%s because constructorInsertion=%s%n", criteria, this.constructorInsertion);
                }
                for (Insertion insertion : arrayList2) {
                    if (insertion.getKind() == Insertion.Kind.RECEIVER) {
                        this.constructorInsertion.addReceiverInsertion((ReceiverInsertion)insertion);
                        continue;
                    }
                    if (criteria.isOnReturnType()) {
                        ((DeclaredType)this.constructorInsertion.getType()).addAnnotation(string);
                        continue;
                    }
                    if (bl2.booleanValue()) {
                        this.constructorInsertion.addDeclarationInsertion(insertion);
                        continue;
                    }
                    arrayList.add(insertion);
                }
            }
            arrayList2.clear();
        }
        if (receiverInsertion != null) {
            this.insertions.add(receiverInsertion);
        }
        if (newInsertion != null) {
            this.insertions.add(newInsertion);
        }
        if (castInsertion != null) {
            this.insertions.add(castInsertion);
            this.insertions.add(closeParenthesisInsertion);
        }
        if (this.constructorInsertion != null) {
            this.constructorInsertion.setInserted(false);
        }
        return arrayList;
    }

    private boolean noTypePath(Criteria criteria) {
        GenericArrayLocationCriterion genericArrayLocationCriterion = criteria.getGenericArrayLocation();
        return genericArrayLocationCriterion == null || genericArrayLocationCriterion.getLocation().isEmpty();
    }

    public static boolean isOnReceiver(Criteria criteria) {
        ASTPath aSTPath = criteria.getASTPath();
        if (aSTPath == null) {
            return criteria.isOnReceiver();
        }
        if (aSTPath.isEmpty()) {
            return false;
        }
        ASTPath.ASTEntry aSTEntry = aSTPath.getLast();
        return aSTEntry.childSelectorIs("parameter") && aSTEntry.getArgument() < 0;
    }

    public static boolean isOnNew(Criteria criteria) {
        ASTPath aSTPath = criteria.getASTPath();
        if (aSTPath == null || aSTPath.isEmpty()) {
            return criteria.isOnNew();
        }
        ASTPath.ASTEntry aSTEntry = aSTPath.getLast();
        Tree.Kind kind = aSTEntry.getTreeKind();
        return kind == Tree.Kind.NEW_ARRAY && aSTEntry.childSelectorIs("type") && aSTEntry.getArgument() == 0 || kind == Tree.Kind.NEW_CLASS && aSTEntry.childSelectorIs("identifier");
    }

    private static boolean isOnNullaryConstructor(Criteria criteria) {
        if (criteria.isOnMethod("<init>()V")) {
            ASTPath aSTPath = criteria.getASTPath();
            if (aSTPath == null || aSTPath.isEmpty()) {
                return !criteria.isOnNew();
            }
            ASTPath.ASTEntry aSTEntry = (ASTPath.ASTEntry)aSTPath.get(0);
            return aSTEntry.getTreeKind() == Tree.Kind.METHOD && (aSTEntry.childSelectorIs("type") || IndexFileSpecification.isOnReceiver(criteria));
        }
        return false;
    }

    private Pair<CastInsertion, CloseParenthesisInsertion> createCastInsertion(Type type, String string, List<Insertion> list, Criteria criteria) {
        if (string != null) {
            type.addAnnotation(string);
        }
        Insertion.decorateType(list, type, criteria.getASTPath());
        CastInsertion castInsertion = new CastInsertion(criteria, type);
        CloseParenthesisInsertion closeParenthesisInsertion = new CloseParenthesisInsertion(criteria, castInsertion.isSeparateLine());
        return new Pair<CastInsertion, CloseParenthesisInsertion>(castInsertion, closeParenthesisInsertion);
    }

    private void parseInnerAndOuterElements(CriterionList criterionList, ATypeElement aTypeElement) {
        this.parseInnerAndOuterElements(criterionList, aTypeElement, false);
    }

    private void parseInnerAndOuterElements(CriterionList criterionList, ATypeElement aTypeElement, boolean bl) {
        ArrayList<Insertion> arrayList = new ArrayList<Insertion>();
        for (Map.Entry entry : aTypeElement.innerTypes.entrySet()) {
            InnerTypeLocation innerTypeLocation = (InnerTypeLocation)entry.getKey();
            AElement aElement = (AElement)entry.getValue();
            CriterionList criterionList2 = criterionList.add(Criteria.atLocation(innerTypeLocation));
            arrayList.addAll(this.parseElement(criterionList2, aElement, bl));
        }
        Object object = criterionList;
        if (!bl) {
            object = criterionList.add(Criteria.atLocation());
        }
        this.parseElement((CriterionList)object, (AElement)aTypeElement, arrayList);
    }

    private Set<Pair<String, Annotation>> getElementAnnotations(AElement aElement) {
        LinkedHashSet<Pair<String, Annotation>> linkedHashSet = new LinkedHashSet<Pair<String, Annotation>>(aElement.tlAnnotationsHere.size());
        for (Annotation annotation : aElement.tlAnnotationsHere) {
            AnnotationDef annotationDef = annotation.def;
            String string = "@" + annotationDef.name;
            if (annotation.fieldValues.size() == 1 && annotation.fieldValues.containsKey("value")) {
                string = string + "(" + this.formatFieldValue(annotation, "value") + ")";
            } else if (annotation.fieldValues.size() > 0) {
                string = string + "(";
                boolean bl = true;
                for (String string2 : annotation.fieldValues.keySet()) {
                    if (!bl) {
                        string = string + ", ";
                    }
                    string = string + string2 + "=" + this.formatFieldValue(annotation, string2);
                    bl = false;
                }
                string = string + ")";
            }
            linkedHashSet.add(new Pair<String, Annotation>(string, annotation));
        }
        return linkedHashSet;
    }

    private String formatFieldValue(Annotation annotation, String string) {
        AnnotationFieldType annotationFieldType = annotation.def.fieldTypes.get(string);
        assert (annotationFieldType != null);
        return annotationFieldType.format(annotation.fieldValues.get(string));
    }

    private void parseMethod(CriterionList criterionList, String string, String string2, AMethod aMethod) {
        CriterionList criterionList2;
        AElement aElement;
        Object object;
        criterionList = criterionList.add(Criteria.inMethod(string2));
        this.parseElement(criterionList, aMethod);
        CriterionList criterionList3 = criterionList.add(Criteria.receiver(string2));
        this.parseInnerAndOuterElements(criterionList3, aMethod.receiver.type);
        CriterionList criterionList4 = criterionList.add(Criteria.returnType(string, string2));
        this.parseInnerAndOuterElements(criterionList4, aMethod.returnType);
        for (Map.Entry entry : aMethod.bounds.entrySet()) {
            object = (BoundLocation)entry.getKey();
            aElement = (ATypeElement)entry.getValue();
            criterionList2 = criterionList.add(Criteria.methodBound(string2, (BoundLocation)object));
            this.parseInnerAndOuterElements(criterionList2, (ATypeElement)aElement);
        }
        for (Map.Entry entry : aMethod.parameters.entrySet()) {
            object = (Integer)entry.getKey();
            aElement = (AField)entry.getValue();
            criterionList2 = criterionList.add(Criteria.param(string2, (Integer)object));
            this.parseInnerAndOuterElements(criterionList2, ((AField)aElement).type);
        }
        this.parseASTInsertions(criterionList, aMethod.insertAnnotations, aMethod.insertTypecasts);
        this.parseBlock(criterionList, string, string2, aMethod.body);
    }

    private void parseBlock(CriterionList criterionList, String string, String string2, ABlock aBlock) {
        for (Map.Entry entry : aBlock.locals.entrySet()) {
            LocalLocation localLocation = (LocalLocation)entry.getKey();
            AElement aElement = (AElement)entry.getValue();
            CriterionList criterionList2 = criterionList.add(Criteria.local(string2, localLocation));
            this.parseElement(criterionList2, aElement);
            this.parseInnerAndOuterElements(criterionList2, aElement.type);
        }
        this.parseExpression(criterionList, string, string2, aBlock);
    }

    private void parseExpression(CriterionList criterionList, String string, String string2, AExpression aExpression) {
        CriterionList criterionList2;
        AElement aElement;
        RelativeLocation relativeLocation;
        for (Map.Entry entry : aExpression.typecasts.entrySet()) {
            relativeLocation = (RelativeLocation)entry.getKey();
            aElement = (ATypeElement)entry.getValue();
            criterionList2 = criterionList.add(Criteria.cast(string2, relativeLocation));
            this.parseInnerAndOuterElements(criterionList2, (ATypeElement)aElement);
        }
        for (Map.Entry entry : aExpression.news.entrySet()) {
            relativeLocation = (RelativeLocation)entry.getKey();
            aElement = (ATypeElement)entry.getValue();
            criterionList2 = criterionList.add(Criteria.newObject(string2, relativeLocation));
            this.parseInnerAndOuterElements(criterionList2, (ATypeElement)aElement);
        }
        for (Map.Entry entry : aExpression.instanceofs.entrySet()) {
            relativeLocation = (RelativeLocation)entry.getKey();
            aElement = (ATypeElement)entry.getValue();
            criterionList2 = criterionList.add(Criteria.instanceOf(string2, relativeLocation));
            this.parseInnerAndOuterElements(criterionList2, (ATypeElement)aElement);
        }
        for (Map.Entry entry : aExpression.refs.entrySet()) {
            relativeLocation = (RelativeLocation)entry.getKey();
            aElement = (ATypeElement)entry.getValue();
            criterionList2 = criterionList.add(Criteria.memberReference(string2, relativeLocation));
            this.parseInnerAndOuterElements(criterionList2, (ATypeElement)aElement);
        }
        for (Map.Entry entry : aExpression.calls.entrySet()) {
            relativeLocation = (RelativeLocation)entry.getKey();
            aElement = (ATypeElement)entry.getValue();
            criterionList2 = criterionList.add(Criteria.methodCall(string2, relativeLocation));
            this.parseInnerAndOuterElements(criterionList2, (ATypeElement)aElement);
        }
        for (Map.Entry entry : aExpression.funs.entrySet()) {
            relativeLocation = (RelativeLocation)entry.getKey();
            aElement = (AMethod)entry.getValue();
            criterionList2 = criterionList.add(Criteria.lambda(string2, relativeLocation));
            this.parseLambdaExpression(string, string2, (AMethod)aElement, criterionList2);
        }
    }

    private void parseLambdaExpression(String string, String string2, AMethod aMethod, CriterionList criterionList) {
        for (Map.Entry entry : aMethod.parameters.entrySet()) {
            Integer n = (Integer)entry.getKey();
            AField aField = (AField)entry.getValue();
            CriterionList criterionList2 = criterionList.add(Criteria.param("(anonymous)", n));
            this.parseInnerAndOuterElements(criterionList2, aField.type);
            this.parseASTInsertions(criterionList2, aField.insertAnnotations, aField.insertTypecasts);
        }
        this.parseBlock(criterionList, string, string2, aMethod.body);
    }

    private void parseASTInsertions(CriterionList criterionList, VivifyingMap<ASTPath, ATypeElement> vivifyingMap, VivifyingMap<ASTPath, ATypeElementWithType> vivifyingMap2) {
        CriterionList criterionList2;
        ATypeElement aTypeElement;
        ASTPath aSTPath;
        for (Map.Entry entry : vivifyingMap.entrySet()) {
            aSTPath = (ASTPath)entry.getKey();
            aTypeElement = (ATypeElement)entry.getValue();
            criterionList2 = criterionList.add(Criteria.astPath(aSTPath));
            this.parseInnerAndOuterElements(criterionList2, aTypeElement, true);
        }
        for (Map.Entry entry : vivifyingMap2.entrySet()) {
            aSTPath = (ASTPath)entry.getKey();
            aTypeElement = (ATypeElementWithType)entry.getValue();
            criterionList2 = criterionList.add(Criteria.astPath(aSTPath));
            this.parseInnerAndOuterElements(criterionList2, aTypeElement, true);
        }
    }
}

