/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.List;

public class ParamCriterion
implements Criterion {
    private final String methodName;
    private final Integer paramPos;

    public ParamCriterion(String string, Integer n) {
        this.methodName = string.substring(0, string.indexOf(")") + 1);
        this.paramPos = n;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Tree tree = treePath.getLeaf();
        if (tree instanceof VariableTree) {
            List<? extends VariableTree> list;
            Tree tree2 = treePath.getParentPath().getLeaf();
            switch (tree2.getKind()) {
                case METHOD: {
                    list = ((MethodTree)tree2).getParameters();
                    break;
                }
                case LAMBDA_EXPRESSION: {
                    list = ((LambdaExpressionTree)tree2).getParameters();
                    break;
                }
                default: {
                    list = null;
                }
            }
            return list != null && list.size() > this.paramPos && list.get(this.paramPos).equals(tree);
        }
        return this.isSatisfiedBy(treePath.getParentPath());
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.PARAM;
    }

    public String toString() {
        return "ParamCriterion for method: " + this.methodName + " at position: " + this.paramPos;
    }
}

