/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.AnnotationInsertion;
import annotator.find.Criteria;
import annotator.find.Insertion;
import annotator.find.TypedInsertion;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public class NewInsertion
extends TypedInsertion {
    private static final Pattern qualifiers = Pattern.compile("(?:\\w++\\.)*+");
    protected boolean qualifyType;

    public NewInsertion(Type type, Criteria criteria, List<Insertion> list) {
        super(type, criteria, list);
        this.annotationsOnly = false;
        this.qualifyType = false;
    }

    @Override
    protected String getText(boolean bl, boolean bl2) {
        if (this.annotationsOnly || this.type.getKind() != Type.Kind.ARRAY) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            List<String> list = this.type.getAnnotations();
            if (list.isEmpty()) {
                return "";
            }
            for (String string2 : list) {
                stringBuilder.append(' ').append(string2);
            }
            AnnotationInsertion annotationInsertion = new AnnotationInsertion(stringBuilder.substring(1), this.getCriteria(), this.isSeparateLine());
            string2 = annotationInsertion.getText(bl, bl2);
            this.packageNames.addAll(annotationInsertion.getPackageNames());
            return string2;
        }
        DeclaredType declaredType = this.getBaseType();
        boolean bl3 = bl && declaredType.getName().isEmpty();
        String string = this.typeToString(this.type, bl3, bl2);
        if (!declaredType.getName().isEmpty()) {
            Matcher matcher = qualifiers.matcher(string);
            String string3 = "";
            if (matcher.find() && matcher.start() == 0) {
                string3 = string.substring(0, matcher.end());
                string = string.substring(matcher.end());
            }
            if (this.qualifyType) {
                for (DeclaredType declaredType2 = declaredType; declaredType2 != null; declaredType2 = declaredType2.getInnerType()) {
                    string = string + declaredType2.getName() + ".";
                }
            }
            string = string3 + string;
        }
        string = "new " + string;
        if (bl) {
            string = "/*>>> " + string + " */";
        }
        return string;
    }

    public void setQualifyType(boolean bl) {
        this.qualifyType = bl;
    }

    @Override
    protected boolean addLeadingSpace(boolean bl, int n, char c) {
        if ((c == '.' || c == '(') && this.getBaseType().getName().isEmpty()) {
            return false;
        }
        return super.addLeadingSpace(bl, n, c);
    }

    @Override
    protected boolean addTrailingSpace(boolean bl) {
        return true;
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.NEW;
    }
}

