/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.org.plumelib.signature.Signatures;

public class IsSigMethodCriterion
implements Criterion {
    private static final Map<CompilationUnitTree, Context> contextCache = new HashMap<CompilationUnitTree, Context>();
    private final String fullMethodName;
    private final String simpleMethodName;
    private final List<@BinaryName String> fullyQualifiedParams;
    private final @BinaryName String returnType;

    public IsSigMethodCriterion(String string) {
        this.fullMethodName = string.substring(0, string.indexOf(")") + 1);
        this.simpleMethodName = string.substring(0, string.indexOf("("));
        this.fullyQualifiedParams = new ArrayList<String>();
        try {
            this.parseParams(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
        }
        catch (Exception exception) {
            throw new RuntimeException("Caught exception while parsing method: " + string, exception);
        }
        String string2 = string.substring(string.indexOf(")") + 1);
        this.returnType = string2.equals("V") ? "void" : Signatures.fieldDescriptorToBinaryName(string2);
    }

    private void parseParams(String string) {
        while (string.length() != 0) {
            String string2 = this.readNext(string);
            string = string.substring(string2.length());
            this.fullyQualifiedParams.add(Signatures.fieldDescriptorToBinaryName(string2));
        }
    }

    private String readNext(String string) {
        String string2 = string.substring(0, 1);
        if (this.isPrimitiveLetter(string2)) {
            return string2;
        }
        if (string2.equals("[")) {
            return "[" + this.readNext(string.substring(1));
        }
        if (string2.equals("L")) {
            return "L" + string.substring(1, string.indexOf(";") + 1);
        }
        throw new RuntimeException("Unknown method params: " + this.fullMethodName + " with remainder: " + string);
    }

    private static Context initImports(TreePath treePath) {
        CompilationUnitTree compilationUnitTree = treePath.getCompilationUnit();
        Context context = contextCache.get(compilationUnitTree);
        if (context != null) {
            return context;
        }
        ExpressionTree expressionTree = compilationUnitTree.getPackageName();
        String string = expressionTree == null ? "" : expressionTree.toString();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ImportTree importTree : compilationUnitTree.getImports()) {
            String string2 = importTree.getQualifiedIdentifier().toString();
            arrayList.add(string2);
        }
        context = new Context(string, arrayList);
        contextCache.put(compilationUnitTree, context);
        return context;
    }

    private boolean matchTypeParam(String string, Tree tree, Map<String, String> map, Context context) {
        String string2 = tree.toString();
        boolean bl = this.matchSimpleType(string, string2, context);
        if (!bl && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                bl = this.matchSimpleType(string, string2 = string2.replaceAll("\\b" + entry.getKey() + "\\b", entry.getValue()), context);
                if (bl) continue;
                Criteria.dbug.debug("matchTypeParams() => false:%n", new Object[0]);
                Criteria.dbug.debug("  type = %s%n", tree);
                Criteria.dbug.debug("  simpleType = %s%n", string2);
                Criteria.dbug.debug("  goalType = %s%n", string);
            }
        }
        return bl;
    }

    private boolean matchTypeParams(List<? extends VariableTree> list, Map<String, String> map, Context context) {
        assert (list.size() == this.fullyQualifiedParams.size());
        for (int i = 0; i < list.size(); ++i) {
            VariableTree variableTree;
            Tree tree;
            String string = this.fullyQualifiedParams.get(i);
            if (this.matchTypeParam(string, tree = (variableTree = list.get(i)).getType(), map, context)) continue;
            Criteria.dbug.debug("matchTypeParam() => false:%n  i=%d vt = %s%n  fullType = %s%n", i, variableTree, string);
            return false;
        }
        return true;
    }

    private boolean matchSimpleType(String string, String string2, Context context) {
        Object object;
        int n;
        Criteria.dbug.debug("matchSimpleType(%s, %s, %s)%n", string, string2, context);
        while (string2.contains("<")) {
            n = string2.lastIndexOf("<");
            object = string2.substring(0, n);
            String string3 = string2.substring(string2.indexOf(">", n) + 1);
            string2 = (String)object + string3;
        }
        n = 0;
        if (n == 0) {
            object = context.packageName;
            if (((String)object).length() > 0) {
                object = (String)object + ".";
            }
            if (this.matchWithPrefix(string, string2, (String)object)) {
                n = 1;
            }
        }
        if (n == 0 && this.matchWithPrefix(string, string2, "java.lang.")) {
            n = 1;
        }
        if (n == 0 && this.matchWithPrefix(string, string2, "")) {
            n = 1;
        }
        if (n == 0) {
            for (String string3 : context.imports) {
                String string4 = null;
                if (string3.contains("*")) {
                    string4 = string3.substring(0, string3.indexOf("*"));
                } else {
                    String string5 = string3.substring(string3.lastIndexOf(".") + 1);
                    int n2 = string2.indexOf(91);
                    String string6 = string2;
                    if (n2 > -1) {
                        string6 = string2.substring(0, n2);
                    }
                    if (!string6.equals(string5) && !string6.startsWith(string5 + ".")) continue;
                    string4 = string3.substring(0, string3.lastIndexOf(".") + 1);
                }
                if (!this.matchWithPrefix(string, string2, string4)) continue;
                n = 1;
                break;
            }
        }
        return n != 0;
    }

    private boolean matchWithPrefix(String string, String string2, String string3) {
        return this.matchWithPrefixOneWay(string, string2, string3) || this.matchWithPrefixOneWay(string2, string, string3);
    }

    private boolean matchWithPrefixOneWay(String string, String string2, String string3) {
        String string4 = string2.replace("/", ".");
        String string5 = string.replace("$", ".");
        boolean bl = string5.equals(string3 + string4) || string.startsWith(string3) && (string.endsWith("$" + string4) || string5.endsWith("." + string4));
        Criteria.dbug.debug("matchWithPrefix(%s, %s, %s) => %b)%n", string5, string2, string3, bl);
        return bl;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        void var8_10;
        Object object;
        List<? extends Tree> list;
        if (treePath == null) {
            return false;
        }
        Context context = IsSigMethodCriterion.initImports(treePath);
        Tree tree2 = treePath.getLeaf();
        if (tree2.getKind() != Tree.Kind.METHOD) {
            Criteria.dbug.debug("IsSigMethodCriterion.isSatisfiedBy(%s) => false: not a METHOD tree%n", Main.leafString(treePath));
            return false;
        }
        MethodTree methodTree = (MethodTree)tree2;
        if (!this.simpleMethodName.equals(methodTree.getName().toString())) {
            Criteria.dbug.debug("IsSigMethodCriterion.isSatisfiedBy => false: Names don't match%n", new Object[0]);
            return false;
        }
        List<? extends VariableTree> list2 = methodTree.getParameters();
        if (this.fullyQualifiedParams.size() != list2.size()) {
            Criteria.dbug.debug("IsSigMethodCriterion.isSatisfiedBy => false: Number of parameters don't match%n", new Object[0]);
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (TypeParameterTree tree3 : methodTree.getTypeParameters()) {
            void var10_13;
            String string = tree3.getName().toString();
            String string2 = "Object";
            list = tree3.getBounds();
            if (list != null && list.size() >= 1) {
                object = list.get(0);
                if (object.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                    object = ((AnnotatedTypeTree)object).getUnderlyingType();
                }
                String string3 = object.toString();
            }
            hashMap.put(string, (String)var10_13);
        }
        Object object3 = treePath;
        ClassTree classTree = IsSigMethodCriterion.enclosingClass((TreePath)object3);
        while (var8_10 != null) {
            for (TypeParameterTree typeParameterTree : var8_10.getTypeParameters()) {
                list = typeParameterTree.getName().toString();
                object = "Object";
                List<? extends Tree> list3 = typeParameterTree.getBounds();
                if (list3 != null && list3.size() >= 1) {
                    Tree tree = list3.get(0);
                    if (tree.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                        tree = ((AnnotatedTypeTree)tree).getUnderlyingType();
                    }
                    object = tree.toString();
                }
                hashMap.put((String)((Object)list), (String)object);
            }
            object3 = ((TreePath)object3).getParentPath();
            ClassTree classTree2 = IsSigMethodCriterion.enclosingClass((TreePath)object3);
        }
        if (!this.matchTypeParams(list2, hashMap, context)) {
            Criteria.dbug.debug("IsSigMethodCriterion => false: Parameter types don't match%n", new Object[0]);
            return false;
        }
        if (methodTree.getReturnType() != null && !this.matchTypeParam(this.returnType, methodTree.getReturnType(), hashMap, context)) {
            Criteria.dbug.debug("IsSigMethodCriterion => false: Return types don't match%n", new Object[0]);
            return false;
        }
        Criteria.dbug.debug("IsSigMethodCriterion.isSatisfiedBy => true%n", new Object[0]);
        return true;
    }

    private static ClassTree enclosingClass(TreePath treePath) {
        EnumSet<Tree.Kind> enumSet = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE);
        for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
            Tree tree = treePath2.getLeaf();
            assert (tree != null);
            if (!enumSet.contains((Object)tree.getKind())) continue;
            return (ClassTree)tree;
        }
        return null;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.SIG_METHOD;
    }

    private boolean isPrimitiveLetter(String string) {
        return string.equals("Z") || string.equals("B") || string.equals("C") || string.equals("D") || string.equals("F") || string.equals("I") || string.equals("J") || string.equals("S");
    }

    public String toString() {
        return "IsSigMethodCriterion: " + this.fullMethodName;
    }

    private static class Context {
        public final String packageName;
        public final List<String> imports;

        public Context(String string, List<String> list) {
            this.packageName = string;
            this.imports = list;
        }
    }
}

