/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.scanner.CommonScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

public class InFieldInitCriterion
implements Criterion {
    public final String varName;
    public final Criterion varCriterion;

    public InFieldInitCriterion(String string) {
        this.varName = string;
        this.varCriterion = Criteria.is(Tree.Kind.VARIABLE, string);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        while (treePath != null) {
            if (CommonScanner.isFieldInit(treePath)) {
                return this.varCriterion.isSatisfiedBy(treePath);
            }
            treePath = treePath.getParentPath();
        }
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_FIELD_INIT;
    }

    public String toString() {
        return "In field initializer for field '" + this.varName + "'";
    }
}

