/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

final class EnclosedByCriterion
implements Criterion {
    private final Tree.Kind kind;

    EnclosedByCriterion(Tree.Kind kind) {
        this.kind = kind;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.ENCLOSED_BY;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        for (Tree tree : treePath) {
            if (tree.getKind() != this.kind) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "enclosed by '" + (Object)((Object)this.kind) + "'";
    }
}

