/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.scanner.CastScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.RelativeLocation;

public class CastCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public CastCriterion(String string, RelativeLocation relativeLocation) {
        this.methodName = string.substring(0, string.lastIndexOf(")") + 1);
        this.loc = relativeLocation;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Tree tree = treePath.getLeaf();
        if (tree.getKind() == Tree.Kind.TYPE_CAST) {
            int n;
            int n2 = CastScanner.indexOfCastTree(treePath, tree);
            boolean bl = this.loc.isBytecodeOffset() ? n2 == (n = CastScanner.getMethodCastIndex(this.methodName, this.loc.offset).intValue()) : n2 == this.loc.index;
            return bl;
        }
        boolean bl = this.isSatisfiedBy(treePath.getParentPath());
        return bl;
    }

    public RelativeLocation getLocation() {
        return this.loc;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.CAST;
    }

    public String toString() {
        return "CastCriterion: in method: " + this.methodName + " location: " + this.loc;
    }
}

