/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.io.classfile;

import org.checkerframework.org.objectweb.asmx.ClassAdapter;
import org.checkerframework.org.objectweb.asmx.ClassReader;
import org.checkerframework.org.objectweb.asmx.ClassVisitor;
import org.checkerframework.org.objectweb.asmx.Handle;
import org.checkerframework.org.objectweb.asmx.Label;
import org.checkerframework.org.objectweb.asmx.MethodAdapter;
import org.checkerframework.org.objectweb.asmx.MethodVisitor;
import scenelib.annotations.io.DebugWriter;
import scenelib.annotations.util.AbstractClassVisitor;

public class CodeOffsetAdapter
extends ClassAdapter {
    static final DebugWriter debug = new DebugWriter();
    final ClassReader cr;
    final char[] buf;
    int methodStart;
    int codeStart;
    int offset;

    public CodeOffsetAdapter(ClassReader cr) {
        this(cr, new AbstractClassVisitor());
    }

    public CodeOffsetAdapter(ClassReader cr, ClassVisitor v) {
        super(v);
        this.cr = cr;
        this.buf = new char[cr.header];
        this.methodStart = cr.header + 6;
        this.methodStart += 4 + 2 * cr.readUnsignedShort(this.methodStart);
        for (int i = cr.readUnsignedShort(this.methodStart - 2); i > 0; --i) {
            this.methodStart += 8;
            for (int j = cr.readUnsignedShort(this.methodStart - 2); j > 0; --j) {
                this.methodStart += 6 + cr.readInt(this.methodStart + 2);
            }
        }
        this.methodStart += 2;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor v = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodAdapter(v){
            private int methodEnd;
            {
                String name = CodeOffsetAdapter.this.cr.readUTF8(CodeOffsetAdapter.this.methodStart + 2, CodeOffsetAdapter.this.buf);
                String desc = CodeOffsetAdapter.this.cr.readUTF8(CodeOffsetAdapter.this.methodStart + 4, CodeOffsetAdapter.this.buf);
                int attrCount = CodeOffsetAdapter.this.cr.readUnsignedShort(CodeOffsetAdapter.this.methodStart + 6);
                debug.debug("visiting %s%s (%d)%n", name, desc, CodeOffsetAdapter.this.methodStart);
                debug.debug("%d attributes%n", attrCount);
                CodeOffsetAdapter.this.codeStart = this.methodEnd = CodeOffsetAdapter.this.methodStart + 8;
                if (attrCount > 0) {
                    while (--attrCount >= 0) {
                        String attrName = CodeOffsetAdapter.this.cr.readUTF8(CodeOffsetAdapter.this.codeStart, CodeOffsetAdapter.this.buf);
                        debug.debug("attribute %s%n", attrName);
                        if ("Code".equals(attrName)) {
                            CodeOffsetAdapter.this.codeStart += 6;
                            CodeOffsetAdapter.this.offset = CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.cr.readInt(CodeOffsetAdapter.this.codeStart - 4);
                            CodeOffsetAdapter.this.codeStart += 8;
                            while (--attrCount >= 0) {
                                debug.debug("attribute %s%n", CodeOffsetAdapter.this.cr.readUTF8(CodeOffsetAdapter.this.offset, CodeOffsetAdapter.this.buf));
                                CodeOffsetAdapter.this.offset += 6 + CodeOffsetAdapter.this.cr.readInt(CodeOffsetAdapter.this.offset + 2);
                            }
                            this.methodEnd = CodeOffsetAdapter.this.offset;
                            break;
                        }
                        CodeOffsetAdapter.this.codeStart += 6 + CodeOffsetAdapter.this.cr.readInt(CodeOffsetAdapter.this.codeStart + 2);
                        this.methodEnd = CodeOffsetAdapter.this.codeStart;
                    }
                }
                CodeOffsetAdapter.this.offset = 0;
            }

            private int readInt(int i) {
                return CodeOffsetAdapter.this.cr.readInt(CodeOffsetAdapter.this.codeStart + i);
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                super.visitFieldInsn(opcode, owner, name, desc);
                debug.debug("%d visitFieldInsn(%d, %s, %s, %s)%n", CodeOffsetAdapter.this.offset, opcode, owner, name, desc);
                CodeOffsetAdapter.this.offset += 3;
            }

            @Override
            public void visitIincInsn(int var, int increment) {
                super.visitIincInsn(var, increment);
                debug.debug("%d visitIincInsn(%d, %d)%n", CodeOffsetAdapter.this.offset, var, increment);
                CodeOffsetAdapter.this.offset += 3;
            }

            @Override
            public void visitInsn(int opcode) {
                super.visitInsn(opcode);
                debug.debug("%d visitInsn(%d)%n", CodeOffsetAdapter.this.offset, opcode);
                ++CodeOffsetAdapter.this.offset;
            }

            @Override
            public void visitIntInsn(int opcode, int operand) {
                super.visitIntInsn(opcode, operand);
                debug.debug("%d visitIntInsn(%d, %d)%n", CodeOffsetAdapter.this.offset, opcode, operand);
                CodeOffsetAdapter.this.offset = CodeOffsetAdapter.this.offset + (opcode == 17 ? 3 : 2);
            }

            @Override
            public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
                super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
                debug.debug("%d visitInvokeDynamicInsn(%s, %s)%n", CodeOffsetAdapter.this.offset, name, desc, bsm, bsmArgs);
                CodeOffsetAdapter.this.offset += 5;
            }

            @Override
            public void visitJumpInsn(int opcode, Label label) {
                super.visitJumpInsn(opcode, label);
                debug.debug("%d visitJumpInsn(%d, %s)%n", CodeOffsetAdapter.this.offset, opcode, label);
                CodeOffsetAdapter.this.offset = CodeOffsetAdapter.this.offset + (CodeOffsetAdapter.this.cr.readByte(CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset) < 200 ? 3 : 4);
                assert (CodeOffsetAdapter.this.offset > 0 && this.methodEnd > CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset);
            }

            @Override
            public void visitLdcInsn(Object cst) {
                super.visitLdcInsn(cst);
                debug.debug("%d visitLdcInsn(%s)%n", CodeOffsetAdapter.this.offset, cst);
                CodeOffsetAdapter.this.offset = CodeOffsetAdapter.this.offset + (CodeOffsetAdapter.this.cr.readByte(CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset) > 18 ? 3 : 2);
                assert (CodeOffsetAdapter.this.offset > 0 && this.methodEnd > CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset);
            }

            @Override
            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                super.visitLookupSwitchInsn(dflt, keys, labels);
                debug.debug("%d visitLookupSwitchInsn(%s)%n", CodeOffsetAdapter.this.offset, dflt, keys, labels);
                CodeOffsetAdapter.this.offset += 8 - (CodeOffsetAdapter.this.offset & 3);
                CodeOffsetAdapter.this.offset += 4 + 8 * this.readInt(CodeOffsetAdapter.this.offset);
                assert (CodeOffsetAdapter.this.offset > 0 && this.methodEnd > CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                super.visitMethodInsn(opcode, owner, name, desc);
                debug.debug("%d visitMethodInsn(%d, %s, %s, %s)%n", CodeOffsetAdapter.this.offset, opcode, owner, name, desc);
                CodeOffsetAdapter.this.offset = CodeOffsetAdapter.this.offset + (opcode == 185 ? 5 : 3);
            }

            @Override
            public void visitMultiANewArrayInsn(String desc, int dims) {
                super.visitMultiANewArrayInsn(desc, dims);
                debug.debug("%d visitMultiANewArrayInsn(%s, %d)%n", CodeOffsetAdapter.this.offset, desc, dims);
                CodeOffsetAdapter.this.offset += 4;
            }

            @Override
            public void visitTableSwitchInsn(int min2, int max, Label dflt, Label[] labels) {
                super.visitTableSwitchInsn(min2, max, dflt, labels);
                debug.debug("%d visitTableSwitchInsn(%d, %d, %s)%n", CodeOffsetAdapter.this.offset, min2, max, dflt, labels);
                CodeOffsetAdapter.this.offset += 8 - (CodeOffsetAdapter.this.offset & 3);
                CodeOffsetAdapter.this.offset += 4 * (this.readInt(CodeOffsetAdapter.this.offset + 4) - this.readInt(CodeOffsetAdapter.this.offset) + 3);
                assert (CodeOffsetAdapter.this.offset > 0 && this.methodEnd > CodeOffsetAdapter.this.codeStart + CodeOffsetAdapter.this.offset);
            }

            @Override
            public void visitTypeInsn(int opcode, String desc) {
                super.visitTypeInsn(opcode, desc);
                debug.debug("%d visitTypeInsn(%d, %s)%n", CodeOffsetAdapter.this.offset, opcode, desc);
                CodeOffsetAdapter.this.offset += 3;
            }

            @Override
            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, var);
                debug.debug("%d visitVarInsn(%d, %d)%n", CodeOffsetAdapter.this.offset, opcode, var);
                CodeOffsetAdapter.this.offset = CodeOffsetAdapter.this.offset + (var < 4 ? 1 : 2);
            }

            @Override
            public void visitEnd() {
                CodeOffsetAdapter.this.methodStart = this.methodEnd;
            }
        };
    }

    public int getMethodCodeOffset() {
        return this.offset;
    }

    public int getBytecodeOffset() {
        return this.codeStart + this.offset;
    }

    static {
        debug.setEnabled(false);
    }
}

